/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;

public abstract class MultiNodeRestTest
extends MultipleCacheManagersTest {
    private RestClient client;
    protected Map<String, RestCacheClient> cacheClients;
    private final List<RestServerHelper> restServers = new ArrayList<RestServerHelper>();

    abstract int getMembers();

    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(this.getMembers(), GlobalConfigurationBuilder.defaultClusteredBuilder(), new ConfigurationBuilder(), true, new String[0]);
        this.cacheManagers.forEach(cm -> {
            this.getCacheConfigs().forEach((name, configBuilder) -> cm.defineConfiguration(name, configBuilder.build()));
            RestServerHelper restServer = new RestServerHelper((EmbeddedCacheManager)cm);
            restServer.start(TestResourceTracker.getCurrentTestShortName());
            this.restServers.add(restServer);
        });
        RestClientConfigurationBuilder clientConfigurationBuilder = new RestClientConfigurationBuilder();
        this.restServers.forEach(s -> clientConfigurationBuilder.addServer().host(s.getHost()).port(s.getPort()));
        this.client = RestClient.forConfiguration((RestClientConfiguration)clientConfigurationBuilder.build());
        this.cacheClients = this.getCacheConfigs().keySet().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((RestClient)this.client).cache(arg_0)));
        String protoFileContents = Util.getResourceAsString((String)this.getProtoFile(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.registerProtobuf(protoFileContents);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.client.close();
        this.restServers.forEach(RestServerHelper::stop);
    }

    @AfterMethod
    protected void clearContent() {
    }

    protected void registerProtobuf(String protoFileContents) {
        CompletionStage response = this.client.schemas().post("file.proto", protoFileContents);
        ResponseAssertion.assertThat(response).hasNoErrors();
    }

    protected abstract Map<String, ConfigurationBuilder> getCacheConfigs();

    protected abstract String getProtoFile();
}

