/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestEventListener;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.health.HealthStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.rest.resources.SSEListener;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.ContainerResourceTest")
public class ContainerResourceTest
extends AbstractRestResourceTest {
    private static final String PERSISTENT_LOCATION = CommonsTestingUtil.tmpDirectory((String[])new String[]{ContainerResourceTest.class.getName()});
    private Configuration cache2Config;
    private Configuration templateConfig;
    private RestCacheManagerClient cacheManagerClient;
    private ControlledTimeService timeService;

    public Object[] factory() {
        return new Object[]{new ContainerResourceTest().withSecurity(true).protocol(Protocol.HTTP_11), new ContainerResourceTest().withSecurity(false).protocol(Protocol.HTTP_11), new ContainerResourceTest().withSecurity(true).protocol(Protocol.HTTP_20), new ContainerResourceTest().withSecurity(false).protocol(Protocol.HTTP_20)};
    }

    @Override
    protected GlobalConfigurationBuilder getGlobalConfigForNode(int id) {
        GlobalConfigurationBuilder config = super.getGlobalConfigForNode(id);
        config.globalState().enable().configurationStorage(ConfigurationStorage.OVERLAY).persistentLocation(Paths.get(PERSISTENT_LOCATION, Integer.toString(id)).toString()).metrics().accurateSize(true);
        return config;
    }

    @Override
    protected void createCacheManagers() throws Exception {
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
        super.createCacheManagers();
        this.cacheManagerClient = this.client.cacheManager("default");
        this.timeService = new ControlledTimeService();
        this.cacheManagers.forEach(cm -> TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, (Object)this.timeService, (boolean)true));
    }

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        Configuration cache1Config = this.getCache1Config();
        this.cache2Config = this.getCache2Config();
        ConfigurationBuilder templateConfigBuilder = new ConfigurationBuilder();
        templateConfigBuilder.template(true).clustering().cacheMode(CacheMode.LOCAL).encoding().key().mediaType("text/plain");
        this.templateConfig = templateConfigBuilder.build();
        cm.defineConfiguration("cache1", cache1Config);
        cm.defineConfiguration("cache2", this.cache2Config);
        cm.defineConfiguration("template", this.templateConfig);
    }

    private Configuration getCache1Config() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.statistics().enable().clustering().cacheMode(CacheMode.DIST_SYNC).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        return builder.build();
    }

    private Configuration getCache2Config() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.statistics().enable().clustering().cacheMode(CacheMode.LOCAL).encoding().key().mediaType("text/plain");
        return builder.build();
    }

    @Test
    public void testHealth() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.health());
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)response.getBody());
        Json clusterHealth = jsonNode.at("cluster_health");
        AssertJUnit.assertEquals((String)clusterHealth.at("health_status").asString(), (String)HealthStatus.FAILED.toString());
        AssertJUnit.assertEquals((int)clusterHealth.at("number_of_nodes").asInteger(), (int)2);
        AssertJUnit.assertEquals((int)clusterHealth.at("node_names").asJsonList().size(), (int)2);
        Json cacheHealth = jsonNode.at("cache_health");
        List<String> cacheNames = this.extractCacheNames(cacheHealth);
        Assert.assertTrue((boolean)cacheNames.contains("cache1"));
        Assert.assertTrue((boolean)cacheNames.contains("cache2"));
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.health(true));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
    }

    @Test
    public void testCacheConfigs() {
        String accept = "text/plain; q=0.9, application/json; q=0.6";
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.cacheConfigurations(accept));
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json jsonNode = Json.read((String)json);
        Map<String, String> cachesAndConfig = this.cacheAndConfig(jsonNode);
        AssertJUnit.assertEquals((String)cachesAndConfig.get("template"), (String)ContainerResourceTest.cacheConfigToJson("template", this.templateConfig));
        AssertJUnit.assertEquals((String)cachesAndConfig.get("cache2"), (String)ContainerResourceTest.cacheConfigToJson("cache2", this.cache2Config));
    }

    @Test
    public void testCacheConfigsTemplates() {
        String accept = "text/plain; q=0.9, application/json; q=0.6";
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.templates(accept));
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json jsonNode = Json.read((String)json);
        Map<String, String> cachesAndConfig = this.cacheAndConfig(jsonNode);
        AssertJUnit.assertEquals((String)cachesAndConfig.get("template"), (String)ContainerResourceTest.cacheConfigToJson("template", this.templateConfig));
        AssertJUnit.assertFalse((boolean)cachesAndConfig.containsKey("cache1"));
        AssertJUnit.assertFalse((boolean)cachesAndConfig.containsKey("cache2"));
    }

    @Test
    public void testCaches() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.caches());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json jsonNode = Json.read((String)json);
        List<String> names = this.find(jsonNode, "name");
        Set expectedNames = Util.asSet((Object[])new String[]{"defaultcache", "cache1", "cache2", "invalid"});
        AssertJUnit.assertEquals((Object)expectedNames, new HashSet<String>(names));
        List<String> status = this.find(jsonNode, "status");
        Assert.assertTrue((boolean)status.contains("RUNNING"));
        List<String> types = this.find(jsonNode, "type");
        Assert.assertTrue((boolean)types.contains("local-cache"));
        Assert.assertTrue((boolean)types.contains("distributed-cache"));
        List<String> simpleCaches = this.find(jsonNode, "simple_cache");
        Assert.assertTrue((boolean)simpleCaches.contains("false"));
        List<String> transactional = this.find(jsonNode, "transactional");
        Assert.assertTrue((boolean)transactional.contains("false"));
        List<String> persistent = this.find(jsonNode, "persistent");
        Assert.assertTrue((boolean)persistent.contains("false"));
        List<String> bounded = this.find(jsonNode, "bounded");
        Assert.assertTrue((boolean)bounded.contains("false"));
        List<String> secured = this.find(jsonNode, "secured");
        Assert.assertTrue((boolean)secured.contains("false"));
        List<String> indexed = this.find(jsonNode, "indexed");
        Assert.assertTrue((boolean)indexed.contains("false"));
        List<String> hasRemoteBackup = this.find(jsonNode, "has_remote_backup");
        Assert.assertTrue((boolean)hasRemoteBackup.contains("false"));
        List<String> health = this.find(jsonNode, "health");
        Assert.assertTrue((boolean)health.contains("HEALTHY"));
        List<String> isRebalancingEnabled = this.find(jsonNode, "rebalancing_enabled");
        Assert.assertTrue((boolean)isRebalancingEnabled.contains("true"));
    }

    @Test
    public void testCachesWithIgnoreCache() {
        if (this.security) {
            Security.doAs((Subject)TestingUtil.makeSubject((String[])new String[]{AuthorizationPermission.ADMIN.name()}), () -> this.serverStateManager.ignoreCache("cache1"));
        } else {
            this.serverStateManager.ignoreCache("cache1");
        }
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.caches());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json jsonNode = Json.read((String)json);
        List<String> names = this.find(jsonNode, "name");
        Set expectedNames = Util.asSet((Object[])new String[]{"defaultcache", "cache1", "cache2", "invalid"});
        AssertJUnit.assertEquals((Object)expectedNames, new HashSet<String>(names));
        List<String> status = this.find(jsonNode, "status");
        Assert.assertTrue((boolean)status.contains("RUNNING"));
        Assert.assertTrue((boolean)status.contains("IGNORED"));
    }

    private List<String> find(Json array, String name) {
        return array.asJsonList().stream().map(j -> j.at(name).getValue().toString()).collect(Collectors.toList());
    }

    @Test
    public void testGetGlobalConfig() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.globalConfiguration());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        EmbeddedCacheManager embeddedCacheManager = (EmbeddedCacheManager)this.cacheManagers.get(0);
        GlobalConfiguration globalConfiguration = embeddedCacheManager.withSubject(ADMIN_USER).getCacheManagerConfiguration();
        StringBuilderWriter sw = new StringBuilderWriter();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(MediaType.APPLICATION_JSON).build();){
            new ParserRegistry().serialize(w, globalConfiguration, Collections.emptyMap());
        }
        AssertJUnit.assertEquals((String)sw.toString(), (String)json);
    }

    @Test
    public void testGetGlobalConfigXML() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.globalConfiguration("application/xml"));
        ResponseAssertion.assertThat(response).isOk();
        String xml = response.getBody();
        ParserRegistry parserRegistry = new ParserRegistry();
        ConfigurationBuilderHolder builderHolder = parserRegistry.parse(xml);
        GlobalConfigurationBuilder globalConfigurationBuilder = builderHolder.getGlobalConfigurationBuilder();
        Assert.assertNotNull((Object)globalConfigurationBuilder.build());
    }

    @Test
    public void testInfo() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.info());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json cmInfo = Json.read((String)json);
        AssertJUnit.assertFalse((boolean)cmInfo.at("version").asString().isEmpty());
        AssertJUnit.assertEquals((int)2, (int)cmInfo.at("cluster_members").asList().size());
        AssertJUnit.assertEquals((int)2, (int)cmInfo.at("cluster_members_physical_addresses").asList().size());
        AssertJUnit.assertEquals((String)"LON-1", (String)cmInfo.at("local_site").asString());
        Assert.assertTrue((boolean)cmInfo.at("relay_node").asBoolean());
        AssertJUnit.assertEquals((int)1, (int)cmInfo.at("relay_nodes_address").asList().size());
        AssertJUnit.assertEquals((int)1, (int)cmInfo.at("sites_view").asList().size());
        AssertJUnit.assertEquals((Object)"LON-1", cmInfo.at("sites_view").asList().get(0));
        Assert.assertTrue((boolean)cmInfo.at("rebalancing_enabled").asBoolean());
    }

    @Test
    public void testStats() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.stats());
        ResponseAssertion.assertThat(response).isOk();
        String json = response.getBody();
        Json cmStats = Json.read((String)json);
        Assert.assertTrue((boolean)cmStats.at("statistics_enabled").asBoolean());
        AssertJUnit.assertEquals((int)0, (int)cmStats.at("stores").asInteger());
        AssertJUnit.assertEquals((int)0, (int)cmStats.at("number_of_entries").asInteger());
        this.timeService.advance(1000L);
        ((EmbeddedCacheManager)this.cacheManagers.iterator().next()).getCache("cache1").put((Object)"key", (Object)"value");
        cmStats = Json.read((String)((RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.stats())).getBody());
        AssertJUnit.assertEquals((int)1, (int)cmStats.at("stores").asInteger());
        AssertJUnit.assertEquals((int)1, (int)cmStats.at("number_of_entries").asInteger());
    }

    @Test
    public void testConfigListener() throws InterruptedException, IOException {
        SSEListener sseListener = new SSEListener();
        Closeable listen = this.client.raw().listen("/rest/v2/container/config?action=listen", Collections.emptyMap(), (RestEventListener)sseListener);
        AssertJUnit.assertTrue((boolean)sseListener.openLatch.await(10L, TimeUnit.SECONDS));
        this.createCache("{\"local-cache\":{\"encoding\":{\"media-type\":\"text/plain\"}}}", "listen1");
        AssertJUnit.assertEquals((String)"create-cache", (String)sseListener.events.poll(10L, TimeUnit.SECONDS));
        AssertJUnit.assertTrue((boolean)((String)sseListener.data.removeFirst()).contains("text/plain"));
        this.createCache("{\"local-cache\":{\"encoding\":{\"media-type\":\"application/octet-stream\"}}}", "listen2");
        AssertJUnit.assertEquals((String)"create-cache", (String)sseListener.events.poll(10L, TimeUnit.SECONDS));
        AssertJUnit.assertTrue((boolean)((String)sseListener.data.removeFirst()).contains("application/octet-stream"));
        ResponseAssertion.assertThat(this.client.cache("listen1").delete()).isOk();
        AssertJUnit.assertEquals((String)"remove-cache", (String)sseListener.events.poll(10L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals((String)"listen1", (String)((String)sseListener.data.removeFirst()));
        listen.close();
    }

    private void createCache(String json, String name) {
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        CompletionStage response = this.client.cache(name).createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void testRebalancingActions() {
        this.assertRebalancingStatus(true);
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.disableRebalancing());
        ResponseAssertion.assertThat(response).isOk();
        this.assertRebalancingStatus(false);
        response = (RestResponse)CompletionStages.join((CompletionStage)this.cacheManagerClient.enableRebalancing());
        ResponseAssertion.assertThat(response).isOk();
        this.assertRebalancingStatus(true);
    }

    private void assertRebalancingStatus(boolean enabled) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            this.eventuallyEquals(enabled, () -> {
                try {
                    return ((LocalTopologyManager)TestingUtil.extractGlobalComponent((CacheContainer)cm, LocalTopologyManager.class)).isRebalancingEnabled();
                }
                catch (Exception e) {
                    Assert.fail((String)"Unexpected exception", (Throwable)e);
                    return !enabled;
                }
            });
        }
    }

    private Map<String, String> cacheAndConfig(Json list) {
        HashMap<String, String> result = new HashMap<String, String>();
        list.asJsonList().forEach(node -> result.put(node.at("name").asString(), node.at("configuration").toString()));
        return result;
    }

    private List<String> extractCacheNames(Json cacheStatuses) {
        return cacheStatuses.asJsonList().stream().map(j -> j.at("cache_name").asString()).collect(Collectors.toList());
    }
}

