/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.stream.LongStream;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.rest.search.MultiNodeRestTest;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.search.SearchCountClusteredTest")
public class SearchCountClusteredTest
extends MultiNodeRestTest {
    static final int INDEXED_ENTRIES = 300;
    private static final int NOT_INDEXED_ENTRIES = 200;
    static final String INDEXED_CACHE = "indexed";
    static final String NOT_INDEXED_CACHE = "not-indexed";
    public static final int DEFAULT_PAGE_SIZE = 10;

    @Override
    int getMembers() {
        return 3;
    }

    protected CacheMode getCacheMode() {
        return CacheMode.DIST_SYNC;
    }

    @Override
    protected Map<String, ConfigurationBuilder> getCacheConfigs() {
        HashMap<String, ConfigurationBuilder> caches = new HashMap<String, ConfigurationBuilder>();
        ConfigurationBuilder indexedCache = new ConfigurationBuilder();
        CacheMode cacheMode = this.getCacheMode();
        if (cacheMode.isClustered()) {
            indexedCache.clustering().cacheMode(cacheMode);
        }
        indexedCache.statistics().enable().indexing().enable().addIndexedEntity("IndexedEntity").storage(IndexStorage.LOCAL_HEAP);
        indexedCache.encoding().mediaType("application/x-protostream");
        caches.put(INDEXED_CACHE, indexedCache);
        ConfigurationBuilder notIndexedCache = new ConfigurationBuilder();
        if (cacheMode.isClustered()) {
            notIndexedCache.clustering().cacheMode(cacheMode);
        }
        notIndexedCache.encoding().mediaType("application/x-protostream");
        caches.put(NOT_INDEXED_CACHE, notIndexedCache);
        return caches;
    }

    @Override
    protected String getProtoFile() {
        return "count.proto";
    }

    @BeforeClass
    public void setUp() {
        LongStream.range(0L, 300L).forEach(i -> {
            String str = "index " + i;
            String value = Json.object().set("_type", (Object)"IndexedEntity").set("indexedStoredField", (Object)str).set("indexedNotStoredField", (Object)str).set("sortableStoredField", (Object)(i % 20L)).set("sortableNotStoredField", (Object)("index_" + i % 20L)).set("notIndexedField", (Object)str).toString();
            FunctionalTestUtils.await((CompletionStage)this.indexedCache().put(String.valueOf(i), RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)value)));
        });
        LongStream.range(0L, 200L).forEach(i -> {
            String value = "text " + i;
            Json json = Json.object().set("_type", (Object)"NotIndexedEntity").set("field1", (Object)value).set("field2", (Object)value);
            FunctionalTestUtils.await((CompletionStage)this.nonIndexedCache().put(String.valueOf(i), RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json.toString())));
        });
    }

    @Test
    public void testMatchAll() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "FROM IndexedEntity");
        this.assertTotalAndPageSize(result, 300, 300);
    }

    @Test
    public void testMatchAllPagination() {
        CompletionStage<RestResponse> result = this.queryWithPagination(this.indexedCache(), "FROM IndexedEntity", 17, 0);
        this.assertTotalAndPageSize(result, 300, 17);
    }

    @Test
    public void testLimit() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "FROM IndexedEntity");
        this.assertTotalAndPageSize(result, 300, 300);
    }

    @Test
    public void testLimitPagination() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.indexedCache(), "FROM IndexedEntity");
        this.assertTotalAndPageSize(result, 300, 10);
    }

    @Test
    public void testSortedStored() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "FROM IndexedEntity ORDER BY sortableStoredField DESC");
        this.assertTotalAndPageSize(result, 300, 300);
    }

    @Test
    public void testSortedStoredPagination() {
        CompletionStage<RestResponse> result = this.queryWithPagination(this.indexedCache(), "SELECT sortableStoredField FROM IndexedEntity ORDER BY sortableStoredField DESC", 35, 0);
        this.assertTotalAndPageSize(result, 300, 35);
    }

    @Test
    public void testSelectIndexed() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "SELECT indexedStoredField FROM IndexedEntity");
        this.assertTotalAndPageSize(result, 300, 300);
    }

    @Test
    public void testSelectIndexedPagination() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.indexedCache(), "SELECT indexedStoredField FROM IndexedEntity");
        this.assertTotalAndPageSize(result, 300, 10);
    }

    @Test
    public void testPagination() {
        CompletionStage<RestResponse> result = this.queryWithPagination(this.indexedCache(), "SELECT indexedStoredField FROM IndexedEntity", 8, 2);
        this.assertTotalAndPageSize(result, 300, 8);
    }

    @Test
    public void testAggregation() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "SELECT count(indexedStoredField) FROM IndexedEntity");
        int indexedStoredField = this.getFieldAggregationValue(result, "indexedStoredField");
        AssertJUnit.assertEquals((int)300, (int)indexedStoredField);
    }

    @Test
    public void testGrouping() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "SELECT count(sortableStoredField) FROM IndexedEntity GROUP BY sortableStoredField");
        this.assertTotalAndPageSize(result, 20, 20);
    }

    @Test
    public void testGroupingPagination() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.indexedCache(), "SELECT count(sortableStoredField) FROM IndexedEntity GROUP BY sortableStoredField");
        this.assertTotalAndPageSize(result, 20, 10);
    }

    @Test
    public void testCountOnly() {
        CompletionStage<RestResponse> result = this.queryWithPagination(this.indexedCache(), "FROM IndexedEntity", 0, 0);
        this.assertTotalAndPageSize(result, 300, 0);
    }

    @Test
    public void testSortedNotStored() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "FROM IndexedEntity ORDER BY sortableNotStoredField DESC");
        this.assertTotalAndPageSize(result, 300, 300);
    }

    @Test
    public void testSortedNotStoredPagination() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.indexedCache(), "FROM IndexedEntity ORDER BY sortableNotStoredField DESC");
        this.assertTotalAndPageSize(result, 300, 10);
    }

    @Test
    public void testSelectNonStoredField() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "SELECT indexedNotStoredField FROM IndexedEntity");
        this.assertTotalAndPageSize(result, 300, 300);
    }

    @Test
    public void testSelectNonStoredFieldPagination() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.indexedCache(), "SELECT indexedNotStoredField FROM IndexedEntity");
        this.assertTotalAndPageSize(result, 300, 10);
    }

    @Test
    public void testSelectNotIndexedField() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "SELECT notIndexedField FROM IndexedEntity");
        this.assertTotalAndPageSize(result, 300, 300);
    }

    @Test
    public void testSelectNotIndexedFieldPagination() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.indexedCache(), "SELECT notIndexedField FROM IndexedEntity");
        this.assertTotalAndPageSize(result, 300, 10);
    }

    @Test
    public void testHybridPaginated() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.indexedCache(), "SELECT notIndexedField FROM IndexedEntity WHERE indexedStoredField : 'index'");
        this.assertTotalAndPageSize(result, 300, 10);
    }

    @Test
    public void testHybridNonPaginated() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "SELECT notIndexedField FROM IndexedEntity WHERE indexedStoredField : 'index'");
        this.assertTotalAndPageSize(result, 300, 300);
    }

    @Test
    public void testAggregationHybrid() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.indexedCache(), "SELECT count(indexedStoredField), max(notIndexedField) FROM IndexedEntity");
        int indexedStoredField = this.getFieldAggregationValue(result, "indexedStoredField");
        AssertJUnit.assertEquals((int)300, (int)indexedStoredField);
    }

    @Test
    public void testAggregationHybridPagination() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.indexedCache(), "SELECT count(indexedStoredField), max(notIndexedField) FROM IndexedEntity");
        int indexedStoredField = this.getFieldAggregationValue(result, "indexedStoredField");
        AssertJUnit.assertEquals((int)300, (int)indexedStoredField);
    }

    @Test
    public void testCountOnlyHybrid() {
        CompletionStage<RestResponse> result = this.queryWithPagination(this.indexedCache(), "SELECT notIndexedField FROM IndexedEntity", 0, 0);
        this.assertTotalAndPageSize(result, 300, 0);
    }

    @Test
    public void testMatchAllNotIndexed() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.nonIndexedCache(), "FROM NotIndexedEntity");
        this.assertTotalAndPageSize(result, 200, 200);
    }

    public void testMatchAllNotIndexedPaginated() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.nonIndexedCache(), "FROM NotIndexedEntity");
        this.assertTotalAndPageSize(result, 200, 10);
    }

    @Test
    public void testMaxResultsNotIndexedPaginated() {
        CompletionStage<RestResponse> result = this.queryWithPagination(this.nonIndexedCache(), "FROM NotIndexedEntity", 5, 1);
        this.assertTotalAndPageSize(result, 200, 5);
    }

    @Test
    public void testMaxResultsNotIndexed() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.nonIndexedCache(), "FROM NotIndexedEntity");
        this.assertTotalAndPageSize(result, 200, 200);
    }

    @Test
    public void testSortedNotIndexed() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.nonIndexedCache(), "FROM NotIndexedEntity ORDER BY field2");
        this.assertTotalAndPageSize(result, 200, 200);
    }

    @Test
    public void testSortedNotIndexedPaginated() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.nonIndexedCache(), "FROM NotIndexedEntity ORDER BY field2");
        this.assertTotalAndPageSize(result, 200, 10);
    }

    @Test
    public void testPaginatedNotIndexed() {
        CompletionStage<RestResponse> result = this.queryWithPagination(this.nonIndexedCache(), "SELECT field1 FROM NotIndexedEntity", 5, 2);
        this.assertTotalAndPageSize(result, 200, 5);
    }

    @Test
    public void testSelectNotIndexed() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.nonIndexedCache(), "SELECT field1 FROM NotIndexedEntity");
        this.assertTotalAndPageSize(result, 200, 10);
    }

    @Test
    public void testSelectNotIndexedPaginated() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.nonIndexedCache(), "SELECT field1 FROM NotIndexedEntity");
        this.assertTotalAndPageSize(result, 200, 10);
    }

    @Test
    public void testAggregationNotIndexed() {
        CompletionStage<RestResponse> result = this.queryWithoutPagination(this.nonIndexedCache(), "SELECT count(field1), max(field2) FROM NotIndexedEntity");
        int field1Count = this.getFieldAggregationValue(result, "field1");
        AssertJUnit.assertEquals((int)200, (int)field1Count);
    }

    @Test
    public void testAggregationNotIndexedPagination() {
        CompletionStage<RestResponse> result = this.queryWithDefaultPagination(this.nonIndexedCache(), "SELECT count(field1), max(field2) FROM NotIndexedEntity");
        int field1Count = this.getFieldAggregationValue(result, "field1");
        AssertJUnit.assertEquals((int)200, (int)field1Count);
    }

    @Test
    public void testCountOnlyNotIndexed() {
        CompletionStage<RestResponse> result = this.queryWithPagination(this.nonIndexedCache(), "SELECT field1 FROM NotIndexedEntity", 0, 0);
        this.assertTotalAndPageSize(result, 200, 0);
    }

    private void assertTotalAndPageSize(CompletionStage<RestResponse> response, int totalResults, int pageSize) {
        RestResponse restResponse = (RestResponse)FunctionalTestUtils.await(response);
        String body = restResponse.getBody();
        Json responseDoc = Json.read((String)body);
        Json total = responseDoc.at("total_results");
        AssertJUnit.assertEquals((long)totalResults, (long)total.asLong());
        long hitsSize = responseDoc.at("hits").asJsonList().size();
        AssertJUnit.assertEquals((long)pageSize, (long)hitsSize);
    }

    private CompletionStage<RestResponse> queryWithoutPagination(RestCacheClient client, String query) {
        return client.query(query, -1, 0);
    }

    private CompletionStage<RestResponse> queryWithDefaultPagination(RestCacheClient client, String query) {
        return client.query(query);
    }

    private CompletionStage<RestResponse> queryWithPagination(RestCacheClient client, String query, int maxResults, int offset) {
        return client.query(query, maxResults, offset);
    }

    private int getFieldAggregationValue(CompletionStage<RestResponse> response, String field) {
        RestResponse restResponse = (RestResponse)FunctionalTestUtils.await(response);
        String body = restResponse.getBody();
        return ((Json)Json.read((String)body).at("hits").asJsonList().get(0)).at("hit").at(field).asInteger();
    }

    private RestCacheClient indexedCache() {
        return (RestCacheClient)this.cacheClients.get(INDEXED_CACHE);
    }

    private RestCacheClient nonIndexedCache() {
        return (RestCacheClient)this.cacheClients.get(NOT_INDEXED_CACHE);
    }
}

