/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.rest.authentication.Authenticator;

public class AuthenticationConfiguration
extends ConfigurationElement<AuthenticationConfiguration> {
    public static final AttributeDefinition<String> SECURITY_REALM = AttributeDefinition.builder((String)"security-realm", null, String.class).immutable().build();
    public static final AttributeDefinition<List<String>> MECHANISMS = AttributeDefinition.builder((String)"mechanisms", null, List.class).initializer(ArrayList::new).immutable().serializer(AttributeSerializer.STRING_COLLECTION).build();
    public static final AttributeDefinition<Boolean> METRICS_AUTH = AttributeDefinition.builder((String)"metrics-auth", (Object)true, Boolean.class).build();
    private final Boolean enabled;
    private final Authenticator authenticator;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AuthenticationConfiguration.class, new AttributeDefinition[]{MECHANISMS, SECURITY_REALM, METRICS_AUTH});
    }

    AuthenticationConfiguration(AttributeSet attributes, Authenticator authenticator, Boolean enabled) {
        super("authentication", attributes, new ConfigurationElement[0]);
        this.enabled = enabled;
        this.authenticator = authenticator;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public List<String> mechanisms() {
        return (List)this.attributes.attribute(MECHANISMS).get();
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public boolean metricsAuth() {
        return (Boolean)this.attributes.attribute(METRICS_AUTH).get();
    }

    public String securityRealm() {
        return (String)this.attributes.attribute(SECURITY_REALM).get();
    }
}

