/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.AuthenticationConfiguration;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.AbstractProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;

public class AuthenticationConfigurationBuilder
extends AbstractProtocolServerConfigurationChildBuilder<RestServerConfiguration, AuthenticationConfigurationBuilder>
implements Builder<AuthenticationConfiguration> {
    private final AttributeSet attributes = AuthenticationConfiguration.attributeDefinitionSet();
    private Authenticator authenticator;
    private boolean enabled;

    AuthenticationConfigurationBuilder(ProtocolServerConfigurationBuilder builder) {
        super((ProtocolServerConfigurationChildBuilder)builder);
    }

    public AuthenticationConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public AuthenticationConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AuthenticationConfigurationBuilder securityRealm(String realm) {
        this.attributes.attribute(AuthenticationConfiguration.SECURITY_REALM).set((Object)realm);
        return this;
    }

    public String securityRealm() {
        return (String)this.attributes.attribute(AuthenticationConfiguration.SECURITY_REALM).get();
    }

    public boolean hasSecurityRealm() {
        return !this.attributes.attribute(AuthenticationConfiguration.SECURITY_REALM).isNull();
    }

    public AuthenticationConfigurationBuilder authenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder addMechanisms(String ... mechanisms) {
        List mechs = (List)this.attributes.attribute(AuthenticationConfiguration.MECHANISMS).get();
        for (int i = 0; i < mechanisms.length; ++i) {
            mechs.add(mechanisms[i]);
        }
        this.attributes.attribute(AuthenticationConfiguration.MECHANISMS).set((Object)mechs);
        return this.enable();
    }

    public boolean hasMechanisms() {
        return !((List)this.attributes.attribute(AuthenticationConfiguration.MECHANISMS).get()).isEmpty();
    }

    public List<String> mechanisms() {
        return (List)this.attributes.attribute(AuthenticationConfiguration.MECHANISMS).get();
    }

    public AuthenticationConfigurationBuilder metricsAuth(boolean metricsAuth) {
        this.attributes.attribute(AuthenticationConfiguration.METRICS_AUTH).set((Object)metricsAuth);
        return this;
    }

    public void validate() {
        if (this.enabled && this.authenticator == null) {
            throw RestServerConfigurationBuilder.logger.authenticationWithoutAuthenticator();
        }
    }

    public AuthenticationConfiguration create() {
        return new AuthenticationConfiguration(this.attributes.protect(), this.authenticator, this.enabled);
    }

    public Builder<?> read(AuthenticationConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public AuthenticationConfigurationBuilder self() {
        return this;
    }
}

