/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestEventListener;
import org.infinispan.client.rest.RestRawClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.context.Flag;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.rest.resources.SSEListener;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.yaml.snakeyaml.Yaml;

@Test(groups={"functional"}, testName="rest.CacheResourceV2Test")
public class CacheResourceV2Test
extends AbstractRestResourceTest {
    private static final long MAX_EMPTY_INDEX_SIZE = 300L;
    private static final long MIN_NON_EMPTY_INDEX_SIZE = 1000L;
    private static final String PERSISTENT_LOCATION = CommonsTestingUtil.tmpDirectory((String[])new String[]{CacheResourceV2Test.class.getName()});
    private static final String PROTO_SCHEMA = " /* @Indexed */                     \n message Entity {                   \n    /* @Field */                    \n    required int32 value=1;         \n    optional string description=2;  \n }                                  \n /* @Indexed */                     \n message Another {                  \n    /* @Field */                    \n    required int32 value=1;         \n    optional string description=2;  \n }";

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        cm.defineConfiguration("default", this.getDefaultCacheBuilder().build());
        cm.defineConfiguration("proto", this.getProtoCacheBuilder().build());
        Cache metadataCache = cm.getCache("___protobuf_metadata");
        metadataCache.putIfAbsent((Object)"sample.proto", (Object)PROTO_SCHEMA);
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        cm.defineConfiguration("indexedCache", this.getIndexedPersistedCache().build());
        cm.defineConfiguration("denyReadWritesCache", this.getDefaultCacheBuilder().clustering().partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).build());
    }

    public ConfigurationBuilder getProtoCacheBuilder() {
        ConfigurationBuilder builder = CacheResourceV2Test.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.encoding().mediaType("application/x-protostream");
        return builder;
    }

    public Object[] factory() {
        return new Object[]{new CacheResourceV2Test().withSecurity(false).protocol(Protocol.HTTP_11).ssl(false), new CacheResourceV2Test().withSecurity(true).protocol(Protocol.HTTP_20).ssl(false), new CacheResourceV2Test().withSecurity(true).protocol(Protocol.HTTP_11).ssl(true), new CacheResourceV2Test().withSecurity(true).protocol(Protocol.HTTP_20).ssl(true)};
    }

    private ConfigurationBuilder getIndexedPersistedCache() {
        ConfigurationBuilder builder = CacheResourceV2Test.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.statistics().enable();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Entity").addIndexedEntity("Another").statistics().enable().persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(true)).storeName("store");
        return builder;
    }

    @Override
    protected void createCacheManagers() throws Exception {
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
        super.createCacheManagers();
    }

    @Override
    protected GlobalConfigurationBuilder getGlobalConfigForNode(int id) {
        GlobalConfigurationBuilder config = super.getGlobalConfigForNode(id);
        config.globalState().enable().configurationStorage(ConfigurationStorage.OVERLAY).persistentLocation(Paths.get(PERSISTENT_LOCATION, Integer.toString(id)).toString()).metrics().accurateSize(true);
        return config;
    }

    @Test
    public void testCacheV2KeyOps() {
        RestCacheClient cacheClient = this.client.cache("default");
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.post("key", "value"));
        ResponseAssertion.assertThat(response).isOk();
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.post("key", "value"));
        ResponseAssertion.assertThat(response).isConflicted().hasReturnedText("An entry already exists");
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.put("key", "value-new"));
        ResponseAssertion.assertThat(response).isOk();
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.get("key"));
        ResponseAssertion.assertThat(response).hasReturnedText("value-new");
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.head("key"));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.remove("key"));
        ResponseAssertion.assertThat(response).isOk();
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.get("key"));
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void testCreateCacheEncodedName() {
        this.testCreateAndUseCache("a/");
        this.testCreateAndUseCache("a/b/c");
        this.testCreateAndUseCache("a-b-c");
        this.testCreateAndUseCache("\u00e1b\\\u0107\u00e9/+-$");
        this.testCreateAndUseCache("org.infinispan.cache");
        this.testCreateAndUseCache("a%25bc");
    }

    @Test
    public void testCreateCacheEncoding() {
        String cacheName = "encoding-test";
        String json = "{\"local-cache\":{\"encoding\":{\"media-type\":\"text/plain\"}}}";
        this.createCache(json, cacheName);
        String cacheConfig = this.getCacheConfig("application/json", cacheName);
        Json encoding = Json.read((String)cacheConfig).at("local-cache").at("encoding");
        Json keyMediaType = encoding.at("key").at("media-type");
        Json valueMediaType = encoding.at("value").at("media-type");
        AssertJUnit.assertEquals((String)"text/plain", (String)keyMediaType.asString());
        AssertJUnit.assertEquals((String)"text/plain", (String)valueMediaType.asString());
    }

    private void testCreateAndUseCache(String name) {
        String cacheConfig = "{\"distributed-cache\":{\"mode\":\"SYNC\"}}";
        RestCacheClient cacheClient = this.client.cache(name);
        RestEntity config = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfig);
        CompletionStage response = cacheClient.createWithConfiguration(config, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        CompletionStage sizeResponse = cacheClient.size();
        ResponseAssertion.assertThat(sizeResponse).isOk();
        ResponseAssertion.assertThat(sizeResponse).containsReturnedText("0");
        RestResponse namesResponse = (RestResponse)CompletionStages.join((CompletionStage)this.client.caches());
        ResponseAssertion.assertThat(namesResponse).isOk();
        List names = Json.read((String)namesResponse.getBody()).asJsonList().stream().map(Json::asString).collect(Collectors.toList());
        AssertJUnit.assertTrue((boolean)names.contains(name));
        CompletionStage putResponse = cacheClient.post("key", "value");
        ResponseAssertion.assertThat(putResponse).isOk();
        CompletionStage getResponse = cacheClient.get("key");
        ResponseAssertion.assertThat(getResponse).isOk();
        ResponseAssertion.assertThat(getResponse).containsReturnedText("value");
    }

    @Test
    public void testCreateAndAlterCache() {
        String cacheConfig = "{\n  \"distributed-cache\" : {\n    \"mode\" : \"SYNC\",\n    \"statistics\" : true,\n    \"encoding\" : {\n      \"key\" : {\n        \"media-type\" : \"application/x-protostream\"\n      },\n      \"value\" : {\n        \"media-type\" : \"application/x-protostream\"\n      }\n    },\n    \"expiration\" : {\n      \"lifespan\" : \"60000\"\n    },\n    \"memory\" : {\n      \"max-count\" : \"1000\",\n      \"when-full\" : \"REMOVE\"\n    }\n  }\n}\n";
        String cacheConfigAlter = "{\n  \"distributed-cache\" : {\n    \"mode\" : \"SYNC\",\n    \"statistics\" : true,\n    \"encoding\" : {\n      \"key\" : {\n        \"media-type\" : \"application/x-protostream\"\n      },\n      \"value\" : {\n        \"media-type\" : \"application/x-protostream\"\n      }\n    },\n    \"expiration\" : {\n      \"lifespan\" : \"30000\"\n    },\n    \"memory\" : {\n      \"max-count\" : \"2000\",\n      \"when-full\" : \"REMOVE\"\n    }\n  }\n}\n";
        String cacheConfigConflict = "{\n  \"distributed-cache\" : {\n    \"mode\" : \"ASYNC\"\n  }\n}\n";
        RestCacheClient cacheClient = this.client.cache("mutable");
        CompletionStage response = cacheClient.createWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfig), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.updateWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfigAlter), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.configuration();
        ResponseAssertion.assertThat(response).isOk();
        String configFromServer = ((RestResponse)CompletionStages.join((CompletionStage)response)).getBody();
        AssertJUnit.assertTrue((boolean)configFromServer.contains("\"expiration\":{\"lifespan\":\"30000\"}"));
        AssertJUnit.assertTrue((boolean)configFromServer.contains("\"memory\":{\"max-count\":\"2000\""));
        response = cacheClient.updateWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfigConflict), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isBadRequest();
    }

    @Test
    public void testMutableAttributes() {
        String cacheName = "mutable-attributes";
        String json = "{\"local-cache\":{\"encoding\":{\"media-type\":\"text/plain\"}}}";
        RestCacheClient cacheClient = this.createCache(json, cacheName);
        CompletionStage response = cacheClient.configurationAttributes(true);
        ResponseAssertion.assertThat(response).isOk();
        Json attributes = Json.read((String)((RestResponse)CompletionStages.join((CompletionStage)response)).getBody());
        AssertJUnit.assertEquals((int)10, (int)attributes.asJsonMap().size());
        AssertJUnit.assertEquals((String)"long", (String)attributes.at("clustering.remote-timeout").at("type").asString());
        AssertJUnit.assertEquals((long)15000L, (long)attributes.at("clustering.remote-timeout").at("value").asLong());
    }

    @Test
    public void testCacheV2LifeCycle() throws Exception {
        String xml = Util.getResourceAsString((String)"cache.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        String json = Util.getResourceAsString((String)"cache.json", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        RestEntity xmlEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)xml);
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        CompletionStage response = this.client.cache("cache1").createWithConfiguration(xmlEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isOk();
        this.assertPersistence("cache1", false);
        response = this.client.cache("cache2").createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        this.assertPersistence("cache2", true);
        String mediaList = "application/json,text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
        response = this.client.cache("cache1").configuration(mediaList);
        ResponseAssertion.assertThat(response).isOk();
        String cache1Cfg = ((RestResponse)CompletionStages.join((CompletionStage)response)).getBody();
        response = this.client.cache("cache2").configuration();
        ResponseAssertion.assertThat(response).isOk();
        String cache2Cfg = ((RestResponse)CompletionStages.join((CompletionStage)response)).getBody();
        AssertJUnit.assertEquals((String)cache1Cfg, (String)cache2Cfg.replace("cache2", "cache1"));
        response = this.client.cache("cache1").configuration("application/xml");
        ResponseAssertion.assertThat(response).isOk();
        String cache1Xml = ((RestResponse)CompletionStages.join((CompletionStage)response)).getBody();
        ParserRegistry registry = new ParserRegistry();
        Configuration xmlConfig = registry.parse(cache1Xml).getCurrentConfigurationBuilder().build();
        AssertJUnit.assertEquals((long)1200000L, (long)xmlConfig.clustering().l1().lifespan());
        AssertJUnit.assertEquals((long)60500L, (long)xmlConfig.clustering().stateTransfer().timeout());
    }

    @Test
    public void testCreateDeleteCache() throws Exception {
        this.createDeleteCache(Util.getResourceAsString((String)"cache.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    @Test
    public void testCreateDeleteCacheFromFragment() throws Exception {
        this.createDeleteCache(Util.getResourceAsString((String)"cache-fragment.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    private void createDeleteCache(String xml) {
        RestEntity xmlEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)xml);
        RestCacheClient cacheClient = this.client.cache("cacheCRUD");
        CompletionStage response = cacheClient.createWithConfiguration(xmlEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isOk().hasJson().hasProperty("current_number_of_entries").is(-1);
        response = cacheClient.delete();
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isNotFound().hasReturnedText("ISPN012010: Cache with name 'cacheCRUD' not found amongst the configured caches");
    }

    private void assertPersistence(String name, boolean persisted) {
        EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.iterator().next();
        Cache configCache = cm.getCache("org.infinispan.CONFIG");
        AssertJUnit.assertEquals((boolean)persisted, (boolean)configCache.entrySet().stream().anyMatch((SerializablePredicate & Serializable)e -> ((ScopedState)e.getKey()).getName().equals(name) && !((CacheState)e.getValue()).getFlags().contains(CacheContainerAdmin.AdminFlag.VOLATILE)));
    }

    @Test
    public void testCacheV2Stats() {
        String cacheJson = "{ \"distributed-cache\" : { \"statistics\":true } }";
        RestCacheClient cacheClient = this.client.cache("statCache");
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheJson);
        CompletionStage response = cacheClient.createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
        ResponseAssertion.assertThat(response).isOk();
        this.putStringValueInCache("statCache", "key1", "data");
        this.putStringValueInCache("statCache", "key2", "data");
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)((RestResponse)CompletionStages.join((CompletionStage)response)).getBody());
        AssertJUnit.assertEquals((int)jsonNode.at("current_number_of_entries").asInteger(), (int)2);
        AssertJUnit.assertEquals((int)jsonNode.at("stores").asInteger(), (int)2);
        response = cacheClient.clear();
        ResponseAssertion.assertThat(response).isOk();
        response = cacheClient.stats();
        ResponseAssertion.assertThat(response).isOk().hasJson().hasProperty("current_number_of_entries").is(0);
    }

    @Test
    public void testCacheSize() {
        for (int i = 0; i < 100; ++i) {
            this.putInCache("default", i, "" + i, "application/json");
        }
        CompletionStage response = this.client.cache("default").size();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsReturnedText("100");
    }

    @Test
    public void testCacheFullDetail() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").details());
        Json document = Json.read((String)response.getBody());
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Object)document.at("stats")).isNotNull();
        Assertions.assertThat((Object)document.at("size")).isNotNull();
        Assertions.assertThat((Object)document.at("configuration")).isNotNull();
        Assertions.assertThat((Object)document.at("rehash_in_progress")).isNotNull();
        Assertions.assertThat((Object)document.at("persistent")).isNotNull();
        Assertions.assertThat((Object)document.at("bounded")).isNotNull();
        Assertions.assertThat((Object)document.at("indexed")).isNotNull();
        Assertions.assertThat((Object)document.at("has_remote_backup")).isNotNull();
        Assertions.assertThat((Object)document.at("secured")).isNotNull();
        Assertions.assertThat((Object)document.at("indexing_in_progress")).isNotNull();
        Assertions.assertThat((Object)document.at("queryable")).isNotNull();
        Assertions.assertThat((Object)document.at("rebalancing_enabled")).isNotNull();
        Assertions.assertThat((String)document.at("key_storage").asString()).isEqualTo((Object)"application/unknown");
        Assertions.assertThat((String)document.at("value_storage").asString()).isEqualTo((Object)"application/unknown");
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("proto").details());
        document = Json.read((String)response.getBody());
        Assertions.assertThat((String)document.at("key_storage").asString()).isEqualTo((Object)"application/x-protostream");
        Assertions.assertThat((String)document.at("value_storage").asString()).isEqualTo((Object)"application/x-protostream");
    }

    public void testCacheQueryable() {
        this.createCache(new ConfigurationBuilder(), "cacheNotQueryable");
        Json details = this.getCacheDetail("cacheNotQueryable");
        AssertJUnit.assertFalse((boolean)details.at("queryable").asBoolean());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP);
        builder.indexing().enable().addIndexedEntity("Entity");
        this.createCache(builder, "cacheIndexed");
        details = this.getCacheDetail("cacheIndexed");
        AssertJUnit.assertTrue((boolean)details.at("queryable").asBoolean());
        ConfigurationBuilder proto = new ConfigurationBuilder();
        proto.encoding().mediaType("application/x-protostream");
        this.createCache(proto, "cacheQueryable");
        details = this.getCacheDetail("cacheQueryable");
        AssertJUnit.assertTrue((boolean)details.at("queryable").asBoolean());
    }

    @Test
    public void testCreateInvalidCache() {
        String invalidConfig = "<infinispan>\n <cache-container>\n   <replicated-cache name=\"books\">\n     <encoding media-type=\"application/x-java-object\"/>\n     <indexing>\n       <indexed-entities>\n         <indexed-entity>Dummy</indexed-entity>\n        </indexed-entities>\n     </indexing>\n   </replicated-cache>\n </cache-container>\n</infinispan>";
        CompletionStage response = this.client.cache("CACHE").createWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)invalidConfig), new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isBadRequest().hasReturnedText("Unable to instantiate 'Dummy'");
        response = this.client.cache("CACHE").exists();
        ResponseAssertion.assertThat(response).isOk();
        CompletionStage healthResponse = this.client.cacheManager("default").health();
        ResponseAssertion.assertThat(healthResponse).isOk().containsReturnedText("{\"status\":\"FAILED\",\"cache_name\":\"CACHE\"}");
        response = this.client.cache("CACHE").delete();
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.cache("CACHE").exists();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    private RestCacheClient createCache(ConfigurationBuilder builder, String name) {
        return this.createCache(CacheResourceV2Test.cacheConfigToJson(name, builder.build()), name);
    }

    private RestCacheClient createCache(String json, String name) {
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        RestCacheClient cache = this.client.cache(name);
        CompletionStage response = cache.createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        return cache;
    }

    private Json getCacheDetail(String name) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache(name).details());
        ResponseAssertion.assertThat(response).isOk();
        return Json.read((String)response.getBody());
    }

    @Test
    public void testCacheNames() {
        CompletionStage response = this.client.caches();
        ResponseAssertion.assertThat(response).isOk();
        Json jsonNode = Json.read((String)((RestResponse)CompletionStages.join((CompletionStage)response)).getBody());
        Set cacheNames = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCacheNames();
        int size = jsonNode.asList().size();
        AssertJUnit.assertEquals((int)cacheNames.size(), (int)size);
        for (int i = 0; i < size; ++i) {
            AssertJUnit.assertTrue((boolean)cacheNames.contains(jsonNode.at(i).asString()));
        }
    }

    @Test
    public void testFlags() {
        RestResponse response = this.insertEntity(1, 1000, new String[0]);
        ResponseAssertion.assertThat(response).isOk();
        this.assertIndexed(1000);
        response = this.insertEntity(2, 1200, Flag.SKIP_INDEXING.toString(), Flag.SKIP_CACHE_LOAD.toString());
        ResponseAssertion.assertThat(response).isOk();
        this.assertNotIndexed(1200);
        response = this.insertEntity(3, 1200, "Invalid");
        ResponseAssertion.assertThat(response).isBadRequest().hasReturnedText("No enum constant org.infinispan.context.Flag.Invalid");
    }

    @Test
    public void testValidateCacheQueryable() {
        this.registerSchema("simple.proto", "message Simple { required int32 value=1;}");
        this.correctReportNotQueryableCache("jsonCache", new ConfigurationBuilder().encoding().mediaType("application/json").build());
    }

    private void correctReportNotQueryableCache(String name, Configuration configuration) {
        this.createAndWriteToCache(name, configuration);
        RestResponse response = this.queryCache(name);
        ResponseAssertion.assertThat(response).isBadRequest();
        Json json = Json.read((String)response.getBody());
        AssertJUnit.assertTrue((boolean)json.at("error").at("cause").toString().matches(".*ISPN028015.*"));
    }

    private RestResponse queryCache(String name) {
        return (RestResponse)CompletionStages.join((CompletionStage)this.client.cache(name).query("FROM Simple"));
    }

    private void createAndWriteToCache(String name, Configuration configuration) {
        String jsonConfig = CacheResourceV2Test.cacheConfigToJson(name, configuration);
        RestEntity configEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)jsonConfig);
        CompletionStage response = this.client.cache(name).createWithConfiguration(configEntity, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        RestEntity valueEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)"{\"_type\":\"Simple\",\"value\":1}");
        response = this.client.cache(name).post("1", valueEntity);
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void testGetAllKeys() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").keys());
        List emptyKeys = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)0, (int)emptyKeys.size());
        this.putTextEntryInCache("default", "1", "value");
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").keys());
        List singleSet = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        int entries = 10;
        for (int i = 0; i < entries; ++i) {
            this.putTextEntryInCache("default", String.valueOf(i), "value");
        }
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").keys());
        Set keys = Json.read((String)response.getBody()).asJsonList().stream().map(Json::asInteger).collect(Collectors.toSet());
        AssertJUnit.assertEquals((int)entries, (int)keys.size());
        AssertJUnit.assertTrue((boolean)IntStream.range(0, entries).allMatch(keys::contains));
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").keys(5));
        Set keysLimited = Json.read((String)response.getBody()).asJsonList().stream().map(Json::asInteger).collect(Collectors.toSet());
        AssertJUnit.assertEquals((int)5, (int)keysLimited.size());
    }

    @Test
    public void testStreamEntries() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").entries());
        List emptyEntries = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)0, (int)emptyEntries.size());
        this.putTextEntryInCache("default", "key_0", "value_0");
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").entries());
        List singleSet = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        for (int i = 0; i < 20; ++i) {
            this.putTextEntryInCache("default", "key_" + i, "value_" + i);
        }
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").entries());
        List jsons = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)20, (int)jsons.size());
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").entries(3));
        jsons = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)3, (int)jsons.size());
        Json first = (Json)jsons.get(0);
        String entry = first.toPrettyString();
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"key\" : \"key_"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"value\" : \"value_"});
        Assertions.assertThat((String)entry).doesNotContain((CharSequence)"timeToLiveSeconds");
        Assertions.assertThat((String)entry).doesNotContain((CharSequence)"maxIdleTimeSeconds");
        Assertions.assertThat((String)entry).doesNotContain((CharSequence)"created");
        Assertions.assertThat((String)entry).doesNotContain((CharSequence)"lastUsed");
        Assertions.assertThat((String)entry).doesNotContain((CharSequence)"expireTime");
    }

    private String asString(Json json) {
        return json.isObject() ? json.toString() : json.asString();
    }

    private void testStreamEntriesFromCache(String cacheName, MediaType cacheMediaType, MediaType writeMediaType, Map<String, String> data) {
        this.createCache(cacheName, cacheMediaType);
        data.forEach((key, value) -> this.writeEntry((String)key, (String)value, cacheName, writeMediaType));
        RestCacheClient cacheClient = this.client.cache(cacheName);
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.entries(true));
        Map<String, String> entries = this.entriesAsMap(response);
        String contentTypeHeader = response.getHeader(ResponseHeader.VALUE_CONTENT_TYPE_HEADER.getValue());
        AssertJUnit.assertEquals((int)data.size(), (int)entries.size());
        entries.forEach((key, value) -> AssertJUnit.assertEquals((String)value, (String)((String)data.get(key))));
        String aKey = data.keySet().iterator().next();
        String aValue = data.get(aKey);
        String changedValue = aValue.replace("value", "value-changed");
        this.writeEntry(aKey, changedValue, cacheName, MediaType.fromString((String)contentTypeHeader));
        entries = this.entriesAsMap((RestResponse)CompletionStages.join((CompletionStage)cacheClient.entries(true)));
        AssertJUnit.assertEquals((String)changedValue, (String)entries.get(aKey));
    }

    public void testStreamFromXMLCache() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("<id>1</id>", "<value>value1</value>");
        data.put("<id>2</id>", "<value>value2</value>");
        this.testStreamEntriesFromCache("xml", MediaType.APPLICATION_XML, MediaType.APPLICATION_XML, data);
    }

    public void testStreamFromTextPlainCache() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key-1", "value-1");
        data.put("key-2", "value-2");
        this.testStreamEntriesFromCache("text", MediaType.TEXT_PLAIN, MediaType.TEXT_PLAIN, data);
    }

    public void testStreamFromJSONCache() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("1", "{\"value\":1}");
        data.put("2", "{\"value\":2}");
        this.testStreamEntriesFromCache("json", MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON, data);
    }

    public void testStreamFromDefaultCache() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("0x01", "0x010203");
        data.put("0x02", "0x020406");
        this.testStreamEntriesFromCache("noEncoding", null, MediaType.APPLICATION_OCTET_STREAM.withEncoding("hex"), data);
    }

    private void createCache(String cacheName, MediaType mediaType) {
        RestCacheClient cacheClient = this.client.cache(cacheName);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        if (mediaType != null) {
            builder.encoding().mediaType(mediaType.toString());
        }
        String jsonConfig = CacheResourceV2Test.cacheConfigToJson(cacheName, builder.build());
        RestEntity cacheConfig = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)jsonConfig);
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.createWithConfiguration(cacheConfig, new CacheContainerAdmin.AdminFlag[0]));
        ResponseAssertion.assertThat(response).isOk();
    }

    private void writeEntry(String key, String value, String cacheName, MediaType mediaType) {
        RestCacheClient cacheClient = this.client.cache(cacheName);
        RestResponse response = mediaType == null ? (RestResponse)CompletionStages.join((CompletionStage)cacheClient.put(key, value)) : (RestResponse)CompletionStages.join((CompletionStage)cacheClient.put(key, mediaType.toString(), RestEntity.create((MediaType)mediaType, (String)value)));
        ResponseAssertion.assertThat(response).isOk();
    }

    private Map<String, String> entriesAsMap(RestResponse response) {
        ResponseAssertion.assertThat(response).isOk();
        List entries = Json.read((String)response.getBody()).asJsonList();
        return entries.stream().collect(Collectors.toMap(j -> this.asString(j.at("key")), j -> this.asString(j.at("value"))));
    }

    @Test
    public void testStreamEntriesWithMetadata() {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").entries(-1, true));
        List emptyEntries = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)0, (int)emptyEntries.size());
        this.putTextEntryInCache("default", "key_0", "value_0");
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").entries(-1, true));
        List singleSet = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)singleSet.size());
        for (int i = 0; i < 20; ++i) {
            this.putTextEntryInCache("default", "key_" + i, "value_" + i);
        }
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").entries(-1, true));
        List jsons = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)20, (int)jsons.size());
        response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").entries(3, true));
        jsons = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)3, (int)jsons.size());
        Json first = (Json)jsons.get(0);
        String entry = first.toPrettyString();
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"key\" : \"key_"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"value\" : \"value_"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"timeToLiveSeconds\" : -1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"maxIdleTimeSeconds\" : -1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"created\" : -1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"lastUsed\" : -1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"expireTime\" : -1"});
    }

    @Test
    public void testStreamEntriesWithMetadataAndExpirationTimesConvertedToSeconds() {
        RestEntity textValue = RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"value1");
        CompletionStages.join((CompletionStage)this.client.cache("default").put("key1", "text/plain", textValue, 1000L, 5000L));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").entries(1, true));
        List jsons = Json.read((String)response.getBody()).asJsonList();
        AssertJUnit.assertEquals((int)1, (int)jsons.size());
        Json first = (Json)jsons.get(0);
        String entry = first.toPrettyString();
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"key\" : \"key1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"value\" : \"value1"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"timeToLiveSeconds\" : 1000"});
        Assertions.assertThat((String)entry).contains(new CharSequence[]{"\"maxIdleTimeSeconds\" : 5000"});
    }

    @Test
    public void testProtobufMetadataManipulation() {
        String cache = "___protobuf_metadata";
        this.putStringValueInCache(cache, "file1.proto", "message A{}");
        this.putStringValueInCache(cache, "file2.proto", "message B{}");
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("___protobuf_metadata").keys());
        String contentAsString = response.getBody();
        List keys = Json.read((String)contentAsString).asJsonList();
        AssertJUnit.assertEquals((int)2, (int)keys.size());
    }

    @Test
    public void testGetProtoCacheConfig() {
        this.testGetProtoCacheConfig("application/xml");
        this.testGetProtoCacheConfig("application/json");
    }

    @Test
    public void testRebalancingActions() {
        String cacheName = "default";
        this.assertRebalancingStatus(cacheName, true);
        RestCacheClient cacheClient = this.client.cache(cacheName);
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.disableRebalancing());
        ResponseAssertion.assertThat(response).isOk();
        this.assertRebalancingStatus(cacheName, false);
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.enableRebalancing());
        ResponseAssertion.assertThat(response).isOk();
        this.assertRebalancingStatus(cacheName, true);
    }

    private void assertRebalancingStatus(String cacheName, boolean enabled) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            this.eventuallyEquals(enabled, () -> {
                try {
                    return ((LocalTopologyManager)TestingUtil.extractGlobalComponent((CacheContainer)cm, LocalTopologyManager.class)).isCacheRebalancingEnabled(cacheName);
                }
                catch (Exception e) {
                    Assert.fail((String)"Unexpected exception", (Throwable)e);
                    return !enabled;
                }
            });
        }
    }

    private void testGetProtoCacheConfig(String accept) {
        this.getCacheConfig(accept, "___protobuf_metadata");
    }

    private String getCacheConfig(String accept, String name) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache(name).configuration(accept));
        ResponseAssertion.assertThat(response).isOk();
        return response.getBody();
    }

    @Test
    public void testConversionFromXML() {
        RestRawClient rawClient = this.client.raw();
        String xml = "<infinispan>\n    <cache-container>\n        <distributed-cache name=\"cacheName\" mode=\"SYNC\">\n            <memory>\n                <object size=\"20\"/>\n            </memory>\n        </distributed-cache>\n    </cache-container>\n</infinispan>";
        CompletionStage response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap("Accept", "application/json"), xml, "application/xml");
        ResponseAssertion.assertThat(response).isOk();
        this.checkJSON(response);
        response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap("Accept", "application/yaml"), xml, "application/xml");
        ResponseAssertion.assertThat(response).isOk();
        this.checkYaml(response);
    }

    @Test
    public void testConversionFromJSON() throws Exception {
        RestRawClient rawClient = this.client.raw();
        String json = "{\"distributed-cache\":{\"mode\":\"SYNC\",\"memory\":{\"storage\":\"OBJECT\",\"max-count\":\"20\"}}}";
        CompletionStage response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap("Accept", "application/xml"), json, "application/json");
        ResponseAssertion.assertThat(response).isOk();
        this.checkXML(response);
        response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap("Accept", "application/yaml"), json, "application/json");
        ResponseAssertion.assertThat(response).isOk();
        this.checkYaml(response);
    }

    @Test
    public void testConversionFromYAML() throws Exception {
        RestRawClient rawClient = this.client.raw();
        String yaml = "distributedCache:\n  mode: 'SYNC'\n  memory:\n    storage: 'OBJECT'\n    maxCount: 20";
        CompletionStage response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap("Accept", "application/xml"), yaml, "application/yaml");
        ResponseAssertion.assertThat(response).isOk();
        this.checkXML(response);
        response = rawClient.post("/rest/v2/caches?action=convert", Collections.singletonMap("Accept", "application/json"), yaml, "application/yaml");
        ResponseAssertion.assertThat(response).isOk();
        this.checkJSON(response);
    }

    private void checkJSON(CompletionStage<RestResponse> response) {
        Json jsonNode = Json.read((String)((RestResponse)CompletionStages.join(response)).getBody());
        Json distCache = jsonNode.at("distributed-cache");
        Json memory = distCache.at("memory");
        AssertJUnit.assertEquals((String)"SYNC", (String)distCache.at("mode").asString());
        AssertJUnit.assertEquals((int)20, (int)memory.at("max-count").asInteger());
    }

    private void checkXML(CompletionStage<RestResponse> response) throws Exception {
        String xml = ((RestResponse)CompletionStages.join(response)).getBody();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
        Element root = doc.getDocumentElement();
        AssertJUnit.assertEquals((String)"distributed-cache", (String)root.getTagName());
        AssertJUnit.assertEquals((String)"SYNC", (String)root.getAttribute("mode"));
        NodeList children = root.getElementsByTagName("memory");
        AssertJUnit.assertEquals((int)1, (int)children.getLength());
        Element memory = (Element)children.item(0);
        AssertJUnit.assertEquals((String)"OBJECT", (String)memory.getAttribute("storage"));
        AssertJUnit.assertEquals((String)"20", (String)memory.getAttribute("max-count"));
    }

    private void checkYaml(CompletionStage<RestResponse> response) {
        Yaml yaml = new Yaml();
        Map config = (Map)yaml.load(((RestResponse)CompletionStages.join(response)).getBody());
        AssertJUnit.assertEquals((String)"SYNC", (String)((String)CacheResourceV2Test.getYamlProperty(config, "distributedCache", "mode")));
        AssertJUnit.assertEquals((String)"OBJECT", (String)((String)CacheResourceV2Test.getYamlProperty(config, "distributedCache", "memory", "storage")));
        AssertJUnit.assertEquals((String)"20", (String)((String)CacheResourceV2Test.getYamlProperty(config, "distributedCache", "memory", "maxCount")));
    }

    public static <T> T getYamlProperty(Map<String, Object> yaml, String ... names) {
        for (int i = 0; i < names.length - 1; ++i) {
            if ((yaml = (Map)yaml.get(names[i])) != null) continue;
            return null;
        }
        return (T)yaml.get(names[names.length - 1]);
    }

    @Test
    public void testCacheExists() {
        AssertJUnit.assertEquals((int)404, (int)this.checkCache("nonexistent"));
        AssertJUnit.assertEquals((int)204, (int)this.checkCache("invalid"));
        AssertJUnit.assertEquals((int)204, (int)this.checkCache("default"));
        AssertJUnit.assertEquals((int)204, (int)this.checkCache("indexedCache"));
    }

    @Test
    public void testCRUDWithProtobufPrimitives() throws Exception {
        RestCacheClient client = this.client.cache("proto");
        MediaType integerType = MediaType.APPLICATION_OBJECT.withClassType(Integer.class);
        RestEntity value = RestEntity.create((MediaType)integerType, (String)"1");
        CompletionStage response = client.put("1", integerType.toString(), value);
        ResponseAssertion.assertThat(response).isOk();
        RestEntity anotherValue = RestEntity.create((MediaType)integerType, (String)"2");
        response = client.put("1", integerType.toString(), anotherValue);
        ResponseAssertion.assertThat(response).isOk();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(RequestHeader.KEY_CONTENT_TYPE_HEADER.getValue(), integerType.toString());
        headers.put(RequestHeader.ACCEPT_HEADER.getValue(), integerType.toString());
        response = client.get("1", headers);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("2");
        headers = new HashMap();
        headers.put(RequestHeader.KEY_CONTENT_TYPE_HEADER.getValue(), integerType.toString());
        headers.put(RequestHeader.ACCEPT_HEADER.getValue(), "application/x-protostream");
        response = client.get("1", headers);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedBytes(new ProtoStreamMarshaller().objectToByteBuffer((Object)2));
    }

    @Test
    public void testSearchStatistics() {
        RestCacheClient cacheClient = this.client.cache("indexedCache");
        CompletionStages.join((CompletionStage)cacheClient.clear());
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.clearSearchStats());
        ResponseAssertion.assertThat(response).isOk();
        if (this.security) {
            RestClient adminClient = RestClient.forConfiguration((RestClientConfiguration)this.getClientConfig().security().authentication().username("admin").password("admin").build());
            response = (RestResponse)CompletionStages.join((CompletionStage)adminClient.cache("indexedCache").clearSearchStats());
            Util.close((AutoCloseable)adminClient);
        }
        ResponseAssertion.assertThat(response).isOk();
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.searchStats());
        Json statJson = Json.read((String)response.getBody());
        this.assertIndexStatsEmpty(statJson.at("index"));
        this.assertAllQueryStatsEmpty(statJson.at("query"));
        this.insertEntity(1, "Entity", 1, "One");
        this.insertEntity(11, "Entity", 11, "Eleven");
        this.insertEntity(21, "Entity", 21, "Twenty One");
        this.insertEntity(3, "Another", 3, "Three");
        this.insertEntity(33, "Another", 33, "Thirty Three");
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.size());
        ResponseAssertion.assertThat(response).hasReturnedText("5");
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.searchStats());
        ResponseAssertion.assertThat(response).isOk();
        statJson = Json.read((String)response.getBody());
        this.assertAllQueryStatsEmpty(statJson.at("query"));
        String indexedQuery = "FROM Entity WHERE value > 5";
        IntStream.range(0, 3).forEach(i -> {
            RestResponse response1 = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.query(indexedQuery));
            ResponseAssertion.assertThat(response1).isOk();
            Json queryJson = Json.read((String)response1.getBody());
            AssertJUnit.assertEquals((int)2, (int)queryJson.at("total_results").asInteger());
        });
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.searchStats());
        statJson = Json.read((String)response.getBody());
        AssertJUnit.assertEquals((long)0L, (long)statJson.at("query").at("hybrid").at("count").asLong());
        AssertJUnit.assertEquals((long)0L, (long)statJson.at("query").at("non_indexed").at("count").asLong());
        Json queryStats = statJson.at("query");
        this.assertQueryStatEmpty(queryStats.at("hybrid"));
        this.assertQueryStatEmpty(queryStats.at("non_indexed"));
        AssertJUnit.assertEquals((long)3L, (long)statJson.at("query").at("indexed_local").at("count").asLong());
        AssertJUnit.assertTrue((statJson.at("query").at("indexed_local").at("average").asLong() > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((statJson.at("query").at("indexed_local").at("max").asLong() > 0L ? 1 : 0) != 0);
        AssertJUnit.assertEquals((long)3L, (long)statJson.at("query").at("indexed_distributed").at("count").asLong());
        AssertJUnit.assertTrue((statJson.at("query").at("indexed_distributed").at("average").asLong() > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((statJson.at("query").at("indexed_distributed").at("max").asLong() > 0L ? 1 : 0) != 0);
        String hybrid = "FROM Entity WHERE value > 5 AND description = 'One'";
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.query(hybrid));
        Json queryJson = Json.read((String)response.getBody());
        AssertJUnit.assertEquals((int)0, (int)queryJson.at("total_results").asInteger());
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.searchStats());
        statJson = Json.read((String)response.getBody());
        AssertJUnit.assertEquals((long)1L, (long)statJson.at("query").at("hybrid").at("count").asLong());
        AssertJUnit.assertTrue((statJson.at("query").at("hybrid").at("average").asLong() > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((statJson.at("query").at("hybrid").at("max").asLong() > 0L ? 1 : 0) != 0);
        response = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.searchStats());
        statJson = Json.read((String)response.getBody());
        AssertJUnit.assertEquals((int)3, (int)statJson.at("index").at("types").at("Entity").at("count").asInteger());
        AssertJUnit.assertEquals((int)2, (int)statJson.at("index").at("types").at("Another").at("count").asInteger());
        Assertions.assertThat((long)statJson.at("index").at("types").at("Entity").at("size").asLong()).isGreaterThan(1000L);
        Assertions.assertThat((long)statJson.at("index").at("types").at("Another").at("size").asLong()).isGreaterThan(1000L);
        AssertJUnit.assertFalse((boolean)statJson.at("index").at("reindexing").asBoolean());
    }

    @Test
    public void testIndexDataSyncInvalidSchema() {
        String notQuiteIndexed = "package schemas;\n /* @Indexed */\n message Entity {\n    optional string name=1;\n }";
        RestResponse restResponse = (RestResponse)CompletionStages.join((CompletionStage)this.client.schemas().put("schemas.proto", notQuiteIndexed));
        ResponseAssertion.assertThat(restResponse).isOk();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntities(new String[]{"schemas.Entity"});
        String cacheConfig = CacheResourceV2Test.cacheConfigToJson("sync-data-index", builder.build());
        RestCacheClient cacheClient = this.client.cache("sync-data-index");
        RestEntity config = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfig);
        CompletionStage response = cacheClient.createWithConfiguration(config, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        String value = Json.object().set("_type", (Object)"schemas.Entity").set("name", (Object)"Jun").toString();
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)value);
        restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.put("key", restEntity));
        ResponseAssertion.assertThat(restResponse).containsReturnedText("make sure at least one field has the @Field annotation");
        response = cacheClient.size();
        ResponseAssertion.assertThat(response).containsReturnedText("0");
    }

    @Test
    public void testLazySearchMapping() {
        String proto = " package future;\n /* @Indexed */\n message Entity {\n    /* @Field */\n    optional string name=1;\n }";
        String value = Json.object().set("_type", (Object)"future.Entity").set("name", (Object)"Kim").toString();
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)value);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntities(new String[]{"future.Entity"});
        String cacheConfig = CacheResourceV2Test.cacheConfigToJson("index-lazy", builder.build());
        RestCacheClient cacheClient = this.client.cache("index-lazy");
        RestEntity config = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)cacheConfig);
        CompletionStage response = cacheClient.createWithConfiguration(config, new CacheContainerAdmin.AdminFlag[0]);
        ResponseAssertion.assertThat(response).isOk();
        RestResponse restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.query("From future.Entity"));
        ResponseAssertion.assertThat(restResponse).containsReturnedText("Unknown type name : future.Entity");
        restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.put("key", restEntity));
        ResponseAssertion.assertThat(restResponse).containsReturnedText("Unknown type name : future.Entity");
        restResponse = (RestResponse)CompletionStages.join((CompletionStage)this.client.schemas().put("future.proto", proto));
        ResponseAssertion.assertThat(restResponse).isOk();
        restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.put("key", restEntity));
        ResponseAssertion.assertThat(restResponse).isOk();
        restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.query("From future.Entity"));
        ResponseAssertion.assertThat(restResponse).isOk();
        ResponseAssertion.assertThat(restResponse).containsReturnedText("Kim");
    }

    @Test
    public void testCacheListener() throws InterruptedException, IOException {
        SSEListener sseListener = new SSEListener();
        Closeable listen = this.client.raw().listen("/rest/v2/caches/default?action=listen", Collections.singletonMap("Accept", "text/plain"), (RestEventListener)sseListener);
        AssertJUnit.assertTrue((boolean)sseListener.openLatch.await(10L, TimeUnit.SECONDS));
        this.putTextEntryInCache("default", "AKey", "AValue");
        AssertJUnit.assertEquals((String)"cache-entry-created", (String)sseListener.events.poll(10L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals((String)"AKey", (String)((String)sseListener.data.removeFirst()));
        this.removeTextEntryFromCache("default", "AKey");
        AssertJUnit.assertEquals((String)"cache-entry-removed", (String)sseListener.events.poll(10L, TimeUnit.SECONDS));
        listen.close();
    }

    @Test
    public void testConnectStoreValidation() {
        RestCacheClient cacheClient = this.client.cache("default");
        this.assertBadResponse(cacheClient, "true");
        this.assertBadResponse(cacheClient, "2");
        this.assertBadResponse(cacheClient, "[1,2,3]");
        this.assertBadResponse(cacheClient, "\"random text\"");
        this.assertBadResponse(cacheClient, "{\"jdbc-store\":{\"shared\":true}}");
        this.assertBadResponse(cacheClient, "{\"jdbc-store\":{\"shared\":true},\"remote-store\":{\"shared\":true}}");
    }

    @Test
    public void testSourceConnected() {
        RestCacheClient cacheClient = this.client.cache("default");
        RestResponse restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.sourceConnected());
        ResponseAssertion.assertThat(restResponse).isNotFound();
    }

    @Test
    public void testCacheAvailability() {
        RestCacheClient cacheClient = this.client.cache("denyReadWritesCache");
        RestResponse restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.getAvailability());
        ResponseAssertion.assertThat(restResponse).isOk().containsReturnedText("AVAILABLE");
        restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.setAvailability("DEGRADED_MODE"));
        ResponseAssertion.assertThat(restResponse).isOk();
        restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.getAvailability());
        ResponseAssertion.assertThat(restResponse).isOk().containsReturnedText("DEGRADED_MODE");
        cacheClient = this.client.cache("org.infinispan.CONFIG");
        restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.getAvailability());
        ResponseAssertion.assertThat(restResponse).isOk().containsReturnedText("AVAILABLE");
        restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.setAvailability("DEGRADED_MODE"));
        ResponseAssertion.assertThat(restResponse).isOk();
        restResponse = (RestResponse)CompletionStages.join((CompletionStage)cacheClient.getAvailability());
        ResponseAssertion.assertThat(restResponse).isOk().containsReturnedText("AVAILABLE");
    }

    private void assertBadResponse(RestCacheClient client, String config) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)client.connectSource(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)config)));
        ResponseAssertion.assertThat(response).isBadRequest();
        ResponseAssertion.assertThat(response).containsReturnedText("Invalid remote-store JSON description");
    }

    private void assertQueryStatEmpty(Json queryTypeStats) {
        AssertJUnit.assertEquals((int)0, (int)queryTypeStats.at("count").asInteger());
        AssertJUnit.assertEquals((int)0, (int)queryTypeStats.at("max").asInteger());
        AssertJUnit.assertEquals((Object)0.0, (Object)queryTypeStats.at("average").asDouble());
        Assert.assertNull((Object)queryTypeStats.at("slowest"));
    }

    private void assertAllQueryStatsEmpty(Json queryStats) {
        queryStats.asJsonMap().forEach((name, s) -> this.assertQueryStatEmpty((Json)s));
    }

    private void assertIndexStatsEmpty(Json indexStats) {
        indexStats.at("types").asJsonMap().forEach((name, json) -> {
            AssertJUnit.assertEquals((int)0, (int)json.at("count").asInteger());
            Assertions.assertThat((long)json.at("size").asLong()).isGreaterThanOrEqualTo(0L);
        });
    }

    private int checkCache(String name) {
        CompletionStage response = this.client.cache(name).exists();
        return ((RestResponse)CompletionStages.join((CompletionStage)response)).getStatus();
    }

    private void registerSchema(String name, String schema) {
        CompletionStage response = this.client.schemas().put(name, schema);
        ResponseAssertion.assertThat(response).isOk().hasNoErrors();
    }

    private RestResponse insertEntity(int key, int value, String ... flags) {
        String json = String.format("{\"_type\": \"Entity\",\"value\": %d}", value);
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json);
        RestCacheClient cacheClient = this.client.cache("indexedCache");
        return (RestResponse)CompletionStages.join((CompletionStage)cacheClient.put(String.valueOf(key), restEntity, flags));
    }

    private void insertEntity(int cacheKey, String type, int intValue, String stringValue) {
        Json json = Json.object().set("_type", (Object)type).set("value", (Object)intValue).set("description", (Object)stringValue);
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)json.toString());
        RestCacheClient cacheClient = this.client.cache("indexedCache");
        CompletionStage response = cacheClient.put(String.valueOf(cacheKey), restEntity);
        ResponseAssertion.assertThat(response).isOk();
    }

    private void assertIndexed(int value) {
        this.assertIndex(value, true);
    }

    private void assertNotIndexed(int value) {
        this.assertIndex(value, false);
    }

    private void assertIndex(int value, boolean present) {
        String query = "FROM Entity WHERE value = " + value;
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("indexedCache").query(query));
        ResponseAssertion.assertThat(response).isOk();
        AssertJUnit.assertEquals((boolean)present, (boolean)response.getBody().contains(String.valueOf(value)));
    }
}

