/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.assertion;

import org.infinispan.commons.dataconversion.internal.Json;
import org.testng.AssertJUnit;

public class JsonAssertion {
    String path;
    private Json node;

    public JsonAssertion(Json node) {
        this(node, "");
    }

    public JsonAssertion(Json node, String path) {
        this.node = node;
        this.path = path;
        AssertJUnit.assertNotNull((String)path, (Object)node);
    }

    public JsonAssertion hasProperty(String propertyName) {
        return new JsonAssertion(this.node.at(propertyName), this.propertyPath(propertyName));
    }

    public JsonAssertion hasNullProperty(String propertyName) {
        this.hasProperty(propertyName).isNull();
        return this;
    }

    public JsonAssertion hasNoProperty(String propertyName) {
        AssertJUnit.assertFalse((String)this.propertyPath(propertyName), (boolean)this.node.has(propertyName));
        return this;
    }

    public void is(int value) {
        AssertJUnit.assertEquals((int)value, (int)this.node.asInteger());
    }

    public void is(String value) {
        AssertJUnit.assertEquals((String)value, (String)this.node.asString());
    }

    public void isNull() {
        AssertJUnit.assertTrue((String)this.path, (boolean)this.node.isNull());
    }

    private String propertyPath(String propertyName) {
        return this.path.isEmpty() ? propertyName : this.path + "." + propertyName;
    }
}

