/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.cachemanager;

import java.util.Map;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.impl.SimpleRequest;
import org.infinispan.server.core.CacheInfo;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.RestCacheManagerTest")
public class RestCacheManagerTest
extends SingleCacheManagerTest {
    @BeforeClass
    public void prepare() {
        Configuration config = new ConfigurationBuilder().build();
        this.cacheManager.defineConfiguration("cache1", config);
        this.cacheManager.defineConfiguration("cache2", config);
    }

    @Test
    public void shouldReuseEncodedCaches() {
        EmbeddedCacheManager embeddedCacheManager = (EmbeddedCacheManager)Mockito.spy((Object)this.cacheManager);
        RestCacheManager restCacheManager = new RestCacheManager(embeddedCacheManager, c -> Boolean.FALSE);
        Map knownCaches = (Map)TestingUtil.extractField((Object)restCacheManager, (String)"knownCaches");
        SimpleRequest request = new SimpleRequest.Builder().setPath("/test").build();
        restCacheManager.getCache("cache1", (RestRequest)request);
        restCacheManager.getCache("cache2", (RestRequest)request);
        Assert.assertEquals((int)knownCaches.size(), (int)2);
        Assert.assertEquals((int)this.cachesSize((CacheInfo<Object, Object>)((CacheInfo)knownCaches.get("cache1"))), (int)1);
        Assert.assertEquals((int)this.cachesSize((CacheInfo<Object, Object>)((CacheInfo)knownCaches.get("cache2"))), (int)1);
        Mockito.reset((Object[])new EmbeddedCacheManager[]{embeddedCacheManager});
        restCacheManager.getCache("cache1", (RestRequest)request);
        restCacheManager.getCache("cache2", (RestRequest)request);
        ((EmbeddedCacheManager)Mockito.verify((Object)embeddedCacheManager, (VerificationMode)Mockito.never())).getCache("cache1");
        ((EmbeddedCacheManager)Mockito.verify((Object)embeddedCacheManager, (VerificationMode)Mockito.never())).getCache("cache2");
        Assert.assertEquals((int)this.cachesSize((CacheInfo<Object, Object>)((CacheInfo)knownCaches.get("cache1"))), (int)1);
        Assert.assertEquals((int)this.cachesSize((CacheInfo<Object, Object>)((CacheInfo)knownCaches.get("cache2"))), (int)1);
        restCacheManager.getCache("cache1", MediaType.MATCH_ALL, MediaType.APPLICATION_JSON, (RestRequest)request);
        restCacheManager.getCache("cache2", MediaType.MATCH_ALL, MediaType.TEXT_PLAIN, (RestRequest)request);
        Assert.assertEquals((int)knownCaches.size(), (int)2);
        Assert.assertEquals((int)this.cachesSize((CacheInfo<Object, Object>)((CacheInfo)knownCaches.get("cache1"))), (int)2);
        Assert.assertEquals((int)this.cachesSize((CacheInfo<Object, Object>)((CacheInfo)knownCaches.get("cache2"))), (int)2);
        Mockito.reset((Object[])new EmbeddedCacheManager[]{embeddedCacheManager});
        restCacheManager.getCache("cache1", MediaType.MATCH_ALL, MediaType.fromString((String)"application/json; charset=UTF-8"), (RestRequest)request);
        restCacheManager.getCache("cache2", MediaType.MATCH_ALL, MediaType.fromString((String)"text/plain; charset=SHIFT-JIS"), (RestRequest)request);
        Assert.assertEquals((int)knownCaches.size(), (int)2);
        Assert.assertEquals((int)this.cachesSize((CacheInfo<Object, Object>)((CacheInfo)knownCaches.get("cache1"))), (int)3);
        Assert.assertEquals((int)this.cachesSize((CacheInfo<Object, Object>)((CacheInfo)knownCaches.get("cache2"))), (int)3);
        ((EmbeddedCacheManager)Mockito.verify((Object)embeddedCacheManager, (VerificationMode)Mockito.never())).getCache("cache1");
        ((EmbeddedCacheManager)Mockito.verify((Object)embeddedCacheManager, (VerificationMode)Mockito.never())).getCache("cache2");
        restCacheManager.getCache("cache1", MediaType.MATCH_ALL, MediaType.fromString((String)"application/json; charset=UTF-8"), (RestRequest)request);
        restCacheManager.getCache("cache2", MediaType.MATCH_ALL, MediaType.fromString((String)"text/plain; charset=SHIFT-JIS"), (RestRequest)request);
        Assert.assertEquals((int)this.cachesSize((CacheInfo<Object, Object>)((CacheInfo)knownCaches.get("cache1"))), (int)3);
        Assert.assertEquals((int)this.cachesSize((CacheInfo<Object, Object>)((CacheInfo)knownCaches.get("cache2"))), (int)3);
        ((EmbeddedCacheManager)Mockito.verify((Object)embeddedCacheManager, (VerificationMode)Mockito.never())).getCache("cache1");
        ((EmbeddedCacheManager)Mockito.verify((Object)embeddedCacheManager, (VerificationMode)Mockito.never())).getCache("cache2");
    }

    private int cachesSize(CacheInfo<Object, Object> cacheInfo) {
        Map caches = (Map)TestingUtil.extractField(cacheInfo, (String)"encodedCaches");
        return caches.size();
    }

    protected EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false));
    }
}

