/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.framework;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.ResourceManager;
import org.infinispan.rest.framework.RestDispatcher;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.framework.impl.ResourceManagerImpl;
import org.infinispan.rest.framework.impl.RestDispatcherImpl;
import org.infinispan.rest.framework.impl.SimpleRequest;
import org.infinispan.rest.framework.impl.SimpleRestResponse;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.CustomAuditLoggerTest;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="rest.framework.RestDispatcherTest")
public class RestDispatcherTest {
    @Test
    public void testDispatch() {
        ResourceManagerImpl manager = new ResourceManagerImpl();
        manager.registerResource("/", (ResourceHandler)new RootResource());
        manager.registerResource("ctx", (ResourceHandler)new CounterResource());
        manager.registerResource("ctx", (ResourceHandler)new MemoryResource());
        manager.registerResource("ctx", (ResourceHandler)new EchoResource());
        manager.registerResource("ctx", (ResourceHandler)new FileResource());
        GlobalConfiguration globalConfiguration = new GlobalConfigurationBuilder().build();
        RestDispatcherImpl restDispatcher = new RestDispatcherImpl((ResourceManager)manager, new Authorizer(globalConfiguration.security(), AuditContext.SERVER, "test", null));
        SimpleRequest restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/").build();
        CompletionStage response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"Hello World!", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/image.gif").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"Hello World!", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.POST).setPath("//ctx/counters/counter1").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((int)200, (int)((RestResponse)CompletionStages.join((CompletionStage)response)).getStatus());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/counters/counter1?action=increment").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((int)200, (int)((RestResponse)CompletionStages.join((CompletionStage)response)).getStatus());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/counters//counter1").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"counter1->1", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.POST).setPath("/ctx/jvm").build();
        this.assertNoResource((RestDispatcher)restDispatcher, restRequest);
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/jvm/memory").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertTrue((Long.parseLong(((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString()) > 0L ? 1 : 0) != 0);
        restRequest = new SimpleRequest.Builder().setMethod(Method.HEAD).setPath("/ctx/jvm/memory").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertTrue((Long.parseLong(((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString()) > 0L ? 1 : 0) != 0);
        restRequest = new SimpleRequest.Builder().setMethod(Method.HEAD).setPath("/ctx/v2/java-memory").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertTrue((Long.parseLong(((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString()) > 0L ? 1 : 0) != 0);
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/context/var1/var2").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"var1,var2", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/context/var1/var2/var3?action=triple").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"triple(var1,var2,var3)", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/context/var1/var2/var3?action=invalid").build();
        this.assertNoResource((RestDispatcher)restDispatcher, restRequest);
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/web/").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"/ctx/web/index.html", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/web/file.txt").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"/ctx/web/file.txt", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/web/dir/file.txt").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"/ctx/web/dir/file.txt", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/web/dir1/dir2/file.txt").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"/ctx/web/dir1/dir2/file.txt", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.POST).setPath("/ctx/counters/{c}").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((int)200, (int)((RestResponse)CompletionStages.join((CompletionStage)response)).getStatus());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/counters/{c}").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"{c}->0", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
    }

    @Test
    public void testDispatchWithAuthz() {
        Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin"});
        Subject LIFECYCLE = TestingUtil.makeSubject((String[])new String[]{"lifecycle"});
        ResourceManagerImpl manager = new ResourceManagerImpl();
        manager.registerResource("ctx", (ResourceHandler)new SecureResource());
        CustomAuditLoggerTest.TestAuditLogger auditLogger = new CustomAuditLoggerTest.TestAuditLogger();
        GlobalConfiguration globalConfiguration = new GlobalConfigurationBuilder().security().authorization().enable().auditLogger((AuditLogger)auditLogger).principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).build();
        RestDispatcherImpl restDispatcher = new RestDispatcherImpl((ResourceManager)manager, new Authorizer(globalConfiguration.security(), AuditContext.SERVER, "test", null));
        SimpleRequest restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/secure").build();
        CompletionStage response = restDispatcher.dispatch((RestRequest)restRequest);
        Exceptions.expectCompletionException(SecurityException.class, (CompletionStage)response);
        AssertJUnit.assertEquals((String)"Permission to ADMIN is DENY for user null", (String)auditLogger.getLastRecord());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/secure").setSubject(LIFECYCLE).build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        Exceptions.expectCompletionException(SecurityException.class, (CompletionStage)response);
        AssertJUnit.assertEquals((String)"Permission to ADMIN is DENY for user Subject:\n\tPrincipal: TestPrincipal [name=lifecycle]\n", (String)auditLogger.getLastRecord());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/secure").setSubject(ADMIN).build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"Subject:\n\tPrincipal: TestPrincipal [name=admin]\n", (String)((RestResponse)CompletionStages.join((CompletionStage)response)).getEntity().toString());
        AssertJUnit.assertEquals((String)"Permission to ADMIN is ALLOW for user Subject:\n\tPrincipal: TestPrincipal [name=admin]\n", (String)auditLogger.getLastRecord());
    }

    private void assertNoResource(RestDispatcher dispatcher, RestRequest restRequest) {
        try {
            CompletionStage response = dispatcher.dispatch(restRequest);
            if (CompletionStages.join((CompletionStage)response) != null) {
                Assert.fail();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class SecureResource
    implements ResourceHandler {
        SecureResource() {
        }

        public Invocations getInvocations() {
            return new Invocations.Builder().invocation().method(Method.GET).path("/secure").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::handleGet).create();
        }

        private CompletionStage<RestResponse> handleGet(RestRequest restRequest) {
            return CompletableFuture.completedFuture(new SimpleRestResponse.Builder().entity((Object)restRequest.getSubject().toString()).build());
        }
    }

    static class FileResource
    implements ResourceHandler {
        FileResource() {
        }

        public Invocations getInvocations() {
            return new Invocations.Builder().invocation().method(Method.GET).path("/web").path("/web/*").handleWith(this::handleGet).create();
        }

        private CompletionStage<RestResponse> handleGet(RestRequest restRequest) {
            String path = restRequest.path();
            if (path.endsWith("web/")) {
                path = path.concat("index.html");
            }
            return CompletableFuture.completedFuture(new SimpleRestResponse.Builder().entity((Object)path).build());
        }
    }

    static class RootResource
    implements ResourceHandler {
        RootResource() {
        }

        public Invocations getInvocations() {
            return new Invocations.Builder().invocation().method(Method.GET).path("/").path("/image.gif").handleWith(this::serveStaticResource).create();
        }

        private CompletionStage<RestResponse> serveStaticResource(RestRequest restRequest) {
            return CompletableFuture.completedFuture(new SimpleRestResponse.Builder().entity((Object)"Hello World!").build());
        }
    }

    static class MemoryResource
    implements ResourceHandler {
        MemoryResource() {
        }

        public Invocations getInvocations() {
            return new Invocations.Builder().invocation().methods(new Method[]{Method.GET, Method.HEAD}).path("/jvm/memory").path("/v2/java-memory").handleWith(this::showMemory).create();
        }

        private CompletionStage<RestResponse> showMemory(RestRequest request) {
            return CompletableFuture.completedFuture(new SimpleRestResponse.Builder().entity((Object)String.valueOf(Runtime.getRuntime().freeMemory())).build());
        }
    }

    static class CounterResource
    implements ResourceHandler {
        private final Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();

        CounterResource() {
        }

        public Invocations getInvocations() {
            return new Invocations.Builder().invocation().name("allCounters").method(Method.GET).path("/counters").handleWith(this::listAllCounters).invocation().name("addCounter").method(Method.POST).path("/counters/{name}").handleWith(this::addCounter).invocation().name("getCounter").method(Method.GET).path("/counters/{name}").handleWith(this::getCounter).invocation().name("incrementCounter").method(Method.GET).path("/counters/{name}").withAction("increment").handleWith(this::incrementCounter).create();
        }

        private CompletionStage<RestResponse> listAllCounters(RestRequest request) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            StringBuilder sb = new StringBuilder();
            this.counters.forEach((key, value) -> sb.append((String)key).append("->").append(value.get()));
            return CompletableFuture.completedFuture(responseBuilder.status(200).entity((Object)sb.toString()).build());
        }

        private CompletionStage<RestResponse> addCounter(RestRequest request) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            String newCounterName = (String)request.variables().get("name");
            if (newCounterName == null) {
                return CompletableFuture.completedFuture(responseBuilder.status(503).build());
            }
            this.counters.put(newCounterName, new AtomicInteger());
            return CompletableFuture.completedFuture(responseBuilder.status(200).build());
        }

        private CompletionStage<RestResponse> getCounter(RestRequest restRequest) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            String name = (String)restRequest.variables().get("name");
            AtomicInteger atomicInteger = this.counters.get(name);
            if (atomicInteger == null) {
                return CompletableFuture.completedFuture(responseBuilder.status(404).build());
            }
            return CompletableFuture.completedFuture(responseBuilder.status(200).entity((Object)(name + "->" + atomicInteger.get())).build());
        }

        private CompletionStage<RestResponse> incrementCounter(RestRequest request) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            String name = (String)request.variables().get("name");
            if (name == null) {
                return CompletableFuture.completedFuture(responseBuilder.status(404).build());
            }
            this.counters.get(name).incrementAndGet();
            return CompletableFuture.completedFuture(responseBuilder.status(200).build());
        }
    }

    static class EchoResource
    implements ResourceHandler {
        EchoResource() {
        }

        public Invocations getInvocations() {
            return new Invocations.Builder().invocation().name("doubleVars").method(Method.GET).path("/context/{variable1}/{variable2}").handleWith(this::doubleVars).invocation().name("tripleVars").method(Method.GET).path("/context/{variable1}/{variable2}/{variable3}").withAction("triple").handleWith(this::tripleVarWithAction).create();
        }

        private CompletionStage<RestResponse> tripleVarWithAction(RestRequest restRequest) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            String variable1 = (String)restRequest.variables().get("variable1");
            String variable2 = (String)restRequest.variables().get("variable2");
            String variable3 = (String)restRequest.variables().get("variable3");
            String action = restRequest.getAction();
            return CompletableFuture.completedFuture(responseBuilder.entity((Object)(action + "(" + variable1 + "," + variable2 + "," + variable3 + ")")).build());
        }

        private CompletionStage<RestResponse> doubleVars(RestRequest restRequest) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            String variable1 = (String)restRequest.variables().get("variable1");
            String variable2 = (String)restRequest.variables().get("variable2");
            return CompletableFuture.completedFuture(responseBuilder.entity((Object)(variable1 + "," + variable2)).build());
        }
    }
}

