/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.cors.CorsConfig;
import java.util.Arrays;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;

public class CorsRuleConfiguration
extends ConfigurationElement<CorsRuleConfiguration> {
    public static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", null, String.class).immutable().build();
    public static final AttributeDefinition<Boolean> ALLOW_CREDENTIALS = AttributeDefinition.builder((String)"allow-credentials", null, Boolean.class).immutable().build();
    public static final AttributeDefinition<Long> MAX_AGE = AttributeDefinition.builder((String)"max-age-seconds", null, Long.class).immutable().build();
    public static final AttributeDefinition<String[]> ALLOW_ORIGINS = AttributeDefinition.builder((String)"allowed-origins", null, String[].class).serializer(CorsRuleConfiguration.stringArraySerializer()).immutable().build();
    public static final AttributeDefinition<String[]> ALLOW_METHODS = AttributeDefinition.builder((String)"allowed-methods", null, String[].class).serializer(CorsRuleConfiguration.stringArraySerializer()).immutable().build();
    public static final AttributeDefinition<String[]> ALLOW_HEADERS = AttributeDefinition.builder((String)"allowed-headers", null, String[].class).serializer(CorsRuleConfiguration.stringArraySerializer()).immutable().build();
    public static final AttributeDefinition<String[]> EXPOSE_HEADERS = AttributeDefinition.builder((String)"expose-headers", null, String[].class).serializer(CorsRuleConfiguration.stringArraySerializer()).immutable().build();
    private final CorsConfig corsConfig;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(CorsRuleConfiguration.class, new AttributeDefinition[]{NAME, ALLOW_CREDENTIALS, MAX_AGE, ALLOW_ORIGINS, ALLOW_METHODS, ALLOW_HEADERS, EXPOSE_HEADERS});
    }

    CorsRuleConfiguration(AttributeSet attributes, CorsConfig corsConfig) {
        super("cors-rule", true, attributes, new ConfigurationElement[0]);
        this.corsConfig = corsConfig;
    }

    CorsConfig corsConfig() {
        return this.corsConfig;
    }

    private static AttributeSerializer<String[]> stringArraySerializer() {
        return (w, n, v) -> {
            if (w.hasFeature(ConfigurationFormatFeature.MIXED_ELEMENTS)) {
                w.writeAttribute(n, v);
            } else {
                w.writeArrayElement(n, n, null, Arrays.asList(v));
            }
        };
    }
}

