/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.rest.RestCounterClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestSchemaClient;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.ConvertUtil;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.MultiResourceTest")
public class MultiResourceTest
extends AbstractRestResourceTest {
    private ExecutorService service;

    public Object[] factory() {
        return new Object[]{new MultiResourceTest().withSecurity(false).protocol(Protocol.HTTP_11).ssl(false), new MultiResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(false), new MultiResourceTest().withSecurity(true).protocol(Protocol.HTTP_11).ssl(true), new MultiResourceTest().withSecurity(true).protocol(Protocol.HTTP_20).ssl(true)};
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.service = Executors.newFixedThreadPool(5);
        this.createCaches("cache1", "cache2");
        this.createCounters("counter1", "counter2");
        this.createSchema("1.proto", "message A1 {}");
        this.createSchema("2.proto", "message B1 {}");
    }

    @AfterMethod
    public void tearDown() {
        CompletionStages.join((CompletionStage)this.client.cache("cache1").delete());
        CompletionStages.join((CompletionStage)this.client.cache("cache2").delete());
        CompletionStages.join((CompletionStage)this.client.counter("counter1").delete());
        CompletionStages.join((CompletionStage)this.client.counter("counter2").delete());
        CompletionStages.join((CompletionStage)this.client.schemas().delete("1.proto"));
        CompletionStages.join((CompletionStage)this.client.schemas().delete("2.proto"));
        this.service.shutdown();
    }

    @Test
    public void testMultiThreadedOps() throws Exception {
        CountDownLatch startLatch = new CountDownLatch(1);
        CompletableFuture<Boolean> r1 = this.doCacheReadWrite(startLatch, "cache1");
        CompletableFuture<Boolean> r2 = this.doCacheReadWrite(startLatch, "cache2");
        CompletableFuture<Boolean> r3 = this.doCounterReadAndWrite(startLatch, "counter1");
        CompletableFuture<Boolean> r4 = this.doCounterReadAndWrite(startLatch, "counter2");
        CompletableFuture<Boolean> r5 = this.doSchemaReadWrite(startLatch, "1.proto", "A");
        CompletableFuture<Boolean> r6 = this.doSchemaReadWrite(startLatch, "2.proto", "B");
        List<CompletableFuture> futures = Arrays.asList(r1, r2, r3, r4, r5, r6);
        startLatch.countDown();
        for (CompletableFuture future : futures) {
            CompletableFutures.await((CompletableFuture)future, (long)10L, (TimeUnit)TimeUnit.SECONDS);
            AssertJUnit.assertTrue((boolean)((Boolean)future.get()));
        }
    }

    private CompletableFuture<Boolean> doSchemaReadWrite(CountDownLatch startLatch, String protoName, String messagePrefix) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String messageFormat = "message %s%d {}";
                startLatch.await();
                this.createSchema(protoName, String.format(messageFormat, messagePrefix, 1));
                this.createSchema(protoName, String.format(messageFormat, messagePrefix, 2));
                this.createSchema(protoName, String.format(messageFormat, messagePrefix, 3));
                String lastSchema = String.format(messageFormat, messagePrefix, 4);
                this.createSchema(protoName, lastSchema);
                AssertJUnit.assertEquals((String)lastSchema, (String)this.getProtobuf(protoName));
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }, this.service);
    }

    private CompletableFuture<Boolean> doCounterReadAndWrite(CountDownLatch startLatch, String counterName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                startLatch.await();
                this.callCounterOp(counterName, "increment");
                this.callCounterOp(counterName, "increment");
                this.callCounterOp(counterName, "increment");
                this.callCounterOp(counterName, "increment");
                this.callCounterOp(counterName, "increment");
                this.callCounterOp(counterName, "decrement");
                this.callCounterOp(counterName, "decrement");
                this.callCounterOp(counterName, "decrement");
                RestCounterClient counterClient = this.client.counter(counterName);
                MultiResourceTest.eventually(() -> {
                    RestResponse r = (RestResponse)CompletionStages.join((CompletionStage)counterClient.get());
                    ResponseAssertion.assertThat(r).isOk();
                    long value = Long.parseLong(r.getBody());
                    return value == 2L;
                });
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }, this.service);
    }

    private CompletableFuture<Boolean> doCacheReadWrite(CountDownLatch startLatch, String cacheName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                startLatch.await();
                this.changeValue(cacheName, "1", "1");
                this.changeValue(cacheName, "2", "2");
                this.changeValue(cacheName, "3", "3");
                this.changeValue(cacheName, "1", "1'");
                this.changeValue(cacheName, "2", "2'");
                this.changeValue(cacheName, "3", "3'");
                AssertJUnit.assertEquals((String)"1'", (String)this.getValue(cacheName, "1"));
                AssertJUnit.assertEquals((String)"2'", (String)this.getValue(cacheName, "2"));
                AssertJUnit.assertEquals((String)"3'", (String)this.getValue(cacheName, "3"));
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }, this.service);
    }

    private void callCounterOp(String name, String op) {
        RestCounterClient counterClient = this.client.counter(name);
        RestResponse response = null;
        switch (op) {
            case "increment": {
                response = (RestResponse)CompletionStages.join((CompletionStage)counterClient.increment());
                break;
            }
            case "decrement": {
                response = (RestResponse)CompletionStages.join((CompletionStage)counterClient.decrement());
                break;
            }
            default: {
                Assert.fail((String)("Invalid operation " + op));
            }
        }
        ResponseAssertion.assertThat(response).isOk();
    }

    private String getValue(String cacheName, String key) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache(cacheName).get(key));
        ResponseAssertion.assertThat(response).isOk();
        return response.getBody();
    }

    private void changeValue(String cacheName, String key, String value) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache(cacheName).put(key, value));
        ResponseAssertion.assertThat(response).isOk();
    }

    private void createSchema(String name, String value) throws Exception {
        RestSchemaClient schemas = this.client.schemas();
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)schemas.put(name, value));
        ResponseAssertion.assertThat(response).isOk();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(response.getBody());
        AssertJUnit.assertEquals((String)"null", (String)jsonNode.get("error").asText());
    }

    private String getProtobuf(String name) {
        RestSchemaClient schemas = this.client.schemas();
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)schemas.get(name));
        ResponseAssertion.assertThat(response).isOk();
        return response.getBody();
    }

    private void createCounters(String ... names) {
        CounterConfiguration configuration = CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).lowerBound(0L).upperBound(100L).initialValue(0L).build();
        for (String counterName : names) {
            AbstractCounterConfiguration config = ConvertUtil.configToParsedConfig((String)counterName, (CounterConfiguration)configuration);
            RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.counter(counterName).create(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)MultiResourceTest.counterConfigToJson(config))));
            ResponseAssertion.assertThat(response).isOk();
        }
    }

    private void createCaches(String ... names) {
        RestEntity jsonEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)"{}");
        for (String cacheName : names) {
            CompletionStage response = this.client.cache(cacheName).createWithConfiguration(jsonEntity, new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
            ResponseAssertion.assertThat(response).isOk();
        }
    }
}

