/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.HashMap;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.search.BaseRestSearchTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.search.IndexedRestSearchTest")
public class IndexedRestSearchTest
extends BaseRestSearchTest {
    @Override
    protected ConfigurationBuilder getConfigBuilder() {
        ConfigurationBuilder configurationBuilder = IndexedRestSearchTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
        configurationBuilder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("org.infinispan.rest.search.entity.Person");
        return configurationBuilder;
    }

    @Test
    public void testReplaceIndexedDocument() throws Exception {
        this.put(10, this.createPerson(0, "P", "", "?", "?", "MALE", new int[0]).toString());
        this.put(10, this.createPerson(0, "P", "Surname", "?", "?", "MALE", new int[0]).toString());
        RestResponse response = (RestResponse)CompletionStages.join(this.get("10", "application/json"));
        Json person = Json.read((String)response.getBody());
        AssertJUnit.assertEquals((String)"Surname", (String)person.at("surname").asString());
    }

    @Test
    public void testCORS() {
        String searchUrl = this.getPath();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put(HttpHeaderNames.HOST.toString(), "localhost");
        headers.put(HttpHeaderNames.ORIGIN.toString(), "http://localhost:" + this.pickServer().getPort());
        headers.put(HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD.toString(), "GET");
        RestResponse preFlight = (RestResponse)CompletionStages.join((CompletionStage)this.client.raw().options(searchUrl, headers));
        ResponseAssertion.assertThat(preFlight).isOk();
        ResponseAssertion.assertThat(preFlight).hasNoContent();
        ResponseAssertion.assertThat(preFlight).containsAllHeaders("access-control-allow-origin", "access-control-allow-methods");
    }
}

