/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.rest.RestEventListener;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;

public class SSEListener
implements RestEventListener {
    private static final Log log = LogFactory.getLog(SSEListener.class);
    BlockingDeque<KeyValuePair<String, String>> events = new LinkedBlockingDeque<KeyValuePair<String, String>>();
    CountDownLatch openLatch = new CountDownLatch(1);

    public void onOpen(RestResponse response) {
        log.tracef("open", new Object[0]);
        this.openLatch.countDown();
    }

    public void onMessage(String id, String type, String data) {
        log.tracef("Received %s %s %s", (Object)id, (Object)type, (Object)data);
        this.events.add((KeyValuePair<String, String>)new KeyValuePair((Object)type, (Object)data));
    }

    public void expectEvent(String type, String subString) throws InterruptedException {
        KeyValuePair<String, String> event = this.events.poll(10L, TimeUnit.SECONDS);
        Assert.assertNotNull(event);
        AssertJUnit.assertEquals((String)type, (String)((String)event.getKey()));
        Assert.assertTrue((boolean)((String)event.getValue()).contains(subString));
    }
}

