/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.tracing;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;

public class OpenTelemetryClient {
    private final SdkTracerProvider tracerProvider;
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;

    public OpenTelemetryClient(SpanExporter spanExporter) {
        SpanProcessor spanProcessor = SimpleSpanProcessor.create((SpanExporter)spanExporter);
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder().addSpanProcessor(spanProcessor);
        this.tracerProvider = builder.build();
        this.openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(this.tracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).buildAndRegisterGlobal();
        this.tracer = this.openTelemetry.getTracer("org.infinispan.hotrod.client.test", "1.0.0");
    }

    public void shutdown() {
        this.tracerProvider.shutdown();
        GlobalOpenTelemetry.resetForTest();
    }

    public OpenTelemetry openTelemetry() {
        return this.openTelemetry;
    }

    public void withinClientSideSpan(String spanName, Runnable operations) {
        Span span = this.tracer.spanBuilder(spanName).setSpanKind(SpanKind.CLIENT).startSpan();
        try (Scope scope = span.makeCurrent();){
            operations.run();
        }
        catch (Throwable throwable) {
            span.setStatus(StatusCode.ERROR, "Something bad happened!");
            span.recordException(throwable);
            throw throwable;
        }
        finally {
            span.end();
        }
    }
}

