/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.tracing;

import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.rest.tracing.OpenTelemetryClient;
import org.infinispan.server.core.telemetry.TelemetryService;
import org.infinispan.server.core.telemetry.impl.OpenTelemetryService;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.tracing.TracingPropagationTest")
public class TracingPropagationTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "tracing";
    private final InMemorySpanExporter inMemorySpanExporter = InMemorySpanExporter.create();
    private final OpenTelemetryClient oTelConfig = new OpenTelemetryClient((SpanExporter)this.inMemorySpanExporter);
    private RestServerHelper restServer;
    private RestClient restClient;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager();
        cacheManager.createCache(CACHE_NAME, TracingPropagationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.LOCAL).build());
        GlobalComponentRegistry globalComponentRegistry = cacheManager.getGlobalComponentRegistry();
        globalComponentRegistry.registerComponent((Object)new OpenTelemetryService(this.oTelConfig.openTelemetry()), TelemetryService.class);
        this.restServer = new RestServerHelper(cacheManager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).build());
        return cacheManager;
    }

    @Test
    public void smokeTest() {
        RestCacheClient client = this.restClient.cache(CACHE_NAME);
        this.oTelConfig.withinClientSideSpan("user-client-side-span", () -> {
            Map<String, String> contextMap = TracingPropagationTest.getContextMap();
            Assertions.assertThat(contextMap).isNotEmpty();
            CompletionStage resp1 = client.put("aaa", MediaType.TEXT_PLAIN.toString(), RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"bbb"), contextMap);
            CompletionStage resp2 = client.put("bbb", MediaType.TEXT_PLAIN.toString(), RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (String)"ccc"), contextMap);
            ResponseAssertion.assertThat(resp1).isOk();
            ResponseAssertion.assertThat(resp2).isOk();
        });
        List spans = this.inMemorySpanExporter.getFinishedSpanItems();
        Assertions.assertThat((List)spans).hasSize(3);
        String traceId = null;
        HashSet<String> spanIds = new HashSet<String>();
        HashMap<String, Integer> parentSpanIds = new HashMap<String, Integer>();
        String parentSpan = null;
        for (SpanData span : spans) {
            if (traceId == null) {
                traceId = span.getTraceId();
            } else {
                Assertions.assertThat((String)span.getTraceId()).isEqualTo((Object)traceId);
            }
            spanIds.add(span.getSpanId());
            parentSpanIds.compute(span.getParentSpanId(), (key, value) -> value == null ? 1 : value + 1);
            Integer times = (Integer)parentSpanIds.get(span.getParentSpanId());
            if (times != 2) continue;
            parentSpan = span.getParentSpanId();
        }
        Assertions.assertThat(spanIds).hasSize(3);
        Assertions.assertThat(parentSpanIds).hasSize(2);
        Assertions.assertThat(spanIds).contains(new Object[]{parentSpan});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void teardown() {
        try {
            this.oTelConfig.shutdown();
            this.restClient.close();
        }
        catch (IOException iOException) {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
        finally {
            try {
                this.restServer.stop();
            }
            finally {
                super.teardown();
            }
        }
    }

    public static Map<String, String> getContextMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        W3CTraceContextPropagator.getInstance().inject(Context.current(), result, (carrier, key, value) -> carrier.put(key, value));
        return result;
    }
}

