/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.codehaus.jackson.map.ObjectMapper;
import org.infinispan.Cache;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.ManagerInstance$;
import org.infinispan.rest.Server$;
import scala.Function1;
import scala.MatchError;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/rest")
public class Server
implements ScalaObject {
    public volatile int bitmap$0;
    private XStream xstream;
    private ObjectMapper jsonMapper;
    private List<Variant> variantList;
    @HeaderParam(value="performAsync")
    private final boolean useAsync;
    @Context
    private final Request request;

    public Server(@Context Request request, @HeaderParam(value="performAsync") boolean useAsync) {
        this.request = request;
        this.useAsync = useAsync;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XStream xstream() {
        if ((this.bitmap$0 & 0x10) != 0) return this.xstream;
        Server server = this;
        synchronized (server) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.xstream = new XStream();
                this.bitmap$0 |= 0x10;
            }
            return this.xstream;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectMapper jsonMapper() {
        if ((this.bitmap$0 & 4) != 0) return this.jsonMapper;
        Server server = this;
        synchronized (server) {
            if ((this.bitmap$0 & 4) == 0) {
                this.jsonMapper = new ObjectMapper();
                this.bitmap$0 |= 4;
            }
            return this.jsonMapper;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Variant> variantList() {
        if ((this.bitmap$0 & 1) != 0) return this.variantList;
        Server server = this;
        synchronized (server) {
            if ((this.bitmap$0 & 1) == 0) {
                this.variantList = Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build();
                this.bitmap$0 |= 1;
            }
            return this.variantList;
        }
    }

    public EntityTag calcETAG(MIMECacheEntry entry) {
        return new EntityTag(new StringBuilder().append((Object)entry.contentType).append((Object)BoxesRunTime.boxToLong((long)entry.lastModified)).append((Object)BoxesRunTime.boxToInteger((int)entry.data.length)).toString());
    }

    @DELETE
    @Path(value="/{cacheName}")
    public void killCache(@PathParam(value="cacheName") String cacheName) {
        ManagerInstance$.MODULE$.getCache(cacheName).stop();
    }

    @DELETE
    @Path(value="/{cacheName}/{cacheKey}")
    public Object removeEntry(@PathParam(value="cacheName") String cacheName, @PathParam(value="cacheKey") String key) {
        return this.useAsync ? ManagerInstance$.MODULE$.getCache(cacheName).removeAsync((Object)key) : ManagerInstance$.MODULE$.getCache(cacheName).remove(key);
    }

    @PUT
    @POST
    @Path(value="/{cacheName}/{cacheKey}")
    public Response putEntry(@PathParam(value="cacheName") String cacheName, @PathParam(value="cacheKey") String key, @HeaderParam(value="Content-Type") String mediaType, byte[] data, @HeaderParam(value="timeToLiveSeconds") long ttl, @HeaderParam(value="maxIdleTimeSeconds") long idleTime) {
        boolean bl;
        long l;
        long l2;
        block17: {
            Response response;
            block3: {
                block7: {
                    Object object;
                    MIMECacheEntry obj;
                    Cache cache;
                    block12: {
                        block16: {
                            block10: {
                                block13: {
                                    block15: {
                                        block14: {
                                            block4: {
                                                block11: {
                                                    int n;
                                                    block9: {
                                                        block5: {
                                                            block8: {
                                                                block6: {
                                                                    block2: {
                                                                        cache = ManagerInstance$.MODULE$.getCache(cacheName);
                                                                        String string = this.request.getMethod();
                                                                        String string2 = "POST";
                                                                        if ((string != null ? !string.equals(string2) : string2 != null) || !cache.containsKey(key)) break block2;
                                                                        response = Response.status((Response.Status)Response.Status.CONFLICT).build();
                                                                        break block3;
                                                                    }
                                                                    String string = mediaType;
                                                                    String string3 = "application/x-java-serialized-object";
                                                                    obj = !(string != null ? !string.equals(string3) : string3 != null) ? new ObjectInputStream(new ByteArrayInputStream(data)).readObject() : new MIMECacheEntry(mediaType, data);
                                                                    l2 = ttl;
                                                                    l = idleTime;
                                                                    bl = this.useAsync;
                                                                    if (l2 != 0L) break block4;
                                                                    n = 0;
                                                                    if (l != 0L) break block5;
                                                                    if (bl) break block6;
                                                                    object = cache.put(key, obj);
                                                                    break block7;
                                                                }
                                                                if (!bl) break block8;
                                                                object = cache.putAsync((Object)key, (Object)obj);
                                                                break block7;
                                                            }
                                                            throw new MatchError((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)l2), (Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToBoolean((boolean)bl)));
                                                        }
                                                        if (bl) break block9;
                                                        long x = n;
                                                        long y = l;
                                                        break block10;
                                                    }
                                                    if (!bl) break block11;
                                                    long x = n;
                                                    long y = l;
                                                    break block12;
                                                }
                                                throw new MatchError((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)l2), (Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToBoolean((boolean)bl)));
                                            }
                                            if (l != 0L) break block13;
                                            if (bl) break block14;
                                            object = cache.put((Object)key, (Object)obj, ttl, TimeUnit.SECONDS);
                                            break block7;
                                        }
                                        if (!bl) break block15;
                                        object = cache.putAsync((Object)key, (Object)obj, ttl, TimeUnit.SECONDS);
                                        break block7;
                                    }
                                    throw new MatchError((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)l2), (Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToBoolean((boolean)bl)));
                                }
                                if (bl) break block16;
                                long x = l2;
                                long y = l;
                            }
                            object = cache.put((Object)key, (Object)obj, ttl, TimeUnit.SECONDS, idleTime, TimeUnit.SECONDS);
                            break block7;
                        }
                        if (!bl) break block17;
                        long x = l2;
                        long y = l;
                    }
                    object = cache.putAsync((Object)key, (Object)obj, ttl, TimeUnit.SECONDS, idleTime, TimeUnit.SECONDS);
                }
                response = Response.ok().build();
            }
            return response;
        }
        throw new MatchError((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)l2), (Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToBoolean((boolean)bl)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @HEAD
    @Path(value="/{cacheName}/{cacheKey}")
    public Response headEntry(@PathParam(value="cacheName") String cacheName, @PathParam(value="cacheKey") String key) {
        Response response;
        Object object = ManagerInstance$.MODULE$.getEntry(cacheName, key);
        if (object instanceof MIMECacheEntry) {
            MIMECacheEntry b;
            Date lastMod = new Date(b.lastModified);
            MIMECacheEntry mIMECacheEntry = (MIMECacheEntry)object;
            b = mIMECacheEntry;
            Response.ResponseBuilder responseBuilder = this.request.evaluatePreconditions(lastMod, this.calcETAG(b));
            if (responseBuilder == null) {
                if (responseBuilder != null) throw new MatchError((Object)responseBuilder);
                response = Response.ok().type(b.contentType).lastModified(lastMod).tag(this.calcETAG(b)).build();
                return response;
            } else {
                response = responseBuilder.build();
            }
            return response;
        } else if (object instanceof Object || ScalaRunTime$.MODULE$.isArray(object)) {
            response = Response.ok().build();
            return response;
        } else {
            if (!BoxesRunTime.equals((Object)object, null)) throw new MatchError(object);
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return response;
    }

    public Object streamIt(Function1<OutputStream, Object> action$1) {
        return new $anon$1(this, action$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/{cacheName}/{cacheKey}")
    public Response getEntry(@PathParam(value="cacheName") String cacheName, @PathParam(value="cacheKey") String key) {
        Response response;
        Object object = ManagerInstance$.MODULE$.getEntry(cacheName, key);
        if (object instanceof MIMECacheEntry) {
            MIMECacheEntry b;
            Date lastMod = new Date(b.lastModified);
            MIMECacheEntry mIMECacheEntry = (MIMECacheEntry)object;
            b = mIMECacheEntry;
            Response.ResponseBuilder responseBuilder = this.request.evaluatePreconditions(lastMod, this.calcETAG(b));
            if (responseBuilder == null) {
                if (responseBuilder != null) throw new MatchError((Object)responseBuilder);
                response = Response.ok((Object)b.data, (String)b.contentType).lastModified(lastMod).tag(this.calcETAG(b)).build();
                return response;
            } else {
                response = responseBuilder.build();
            }
            return response;
        } else if (object instanceof String) {
            response = Response.ok((Object)((String)object), (String)"text/plain").build();
            return response;
        } else if (object instanceof Object || ScalaRunTime$.MODULE$.isArray(object)) {
            String selectedMediaType;
            String string;
            Object obj$1 = object;
            Variant variant = this.request.selectVariant(this.variantList());
            Variant variant2 = variant;
            String string2 = string = (selectedMediaType = variant2 == null || variant2.equals(null) ? "application/x-java-serialized-object" : variant.getMediaType().toString());
            String string3 = "application/json";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                response = Response.ok().type(selectedMediaType).entity(this.streamIt((Function1)new $anonfun$getEntry$1(this, obj$1))).build();
                return response;
            } else {
                String string4 = string;
                String string5 = "application/xml";
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    response = Response.ok().type(selectedMediaType).entity(this.streamIt((Function1)new $anonfun$getEntry$2(this, obj$1))).build();
                    return response;
                } else {
                    Object object2 = obj$1;
                    if (object2 instanceof Serializable) {
                        Serializable serializable;
                        Serializable ser$1 = serializable = (Serializable)object2;
                        response = Response.ok().type("application/x-java-serialized-object").entity(this.streamIt((Function1)new $anonfun$getEntry$3(this, ser$1))).build();
                        return response;
                    } else {
                        response = Response.notAcceptable((List)this.variantList()).build();
                    }
                }
            }
            return response;
        } else {
            if (!BoxesRunTime.equals((Object)object, null)) throw new MatchError(object);
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return response;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

