/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.Client$;
import org.infinispan.rest.ManagerInstance$;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

@Test
@ScalaSignature(bytes="\u0006\u0001-3\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\t!\u0003\u0002\u0010\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0005e\u0016\u001cHO\u0003\u0002\u0006\r\u0005Q\u0011N\u001c4j]&\u001c\b/\u00198\u000b\u0003\u001d\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0006\u0013!\tY\u0001#D\u0001\r\u0015\tia\"\u0001\u0003mC:<'\"A\b\u0002\t)\fg/Y\u0005\u0003#1\u0011aa\u00142kK\u000e$\bCA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aC*dC2\fwJ\u00196fGRDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0001?\u0005!\u0001jT*U+\u0005\u0001\u0003CA\u0006\"\u0013\t\u0011CB\u0001\u0004TiJLgn\u001a\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u000b!{5\u000b\u0016\u0011\t\u000b\u0019\u0002A\u0011A\u0014\u0002%Q,7\u000f\u001e\"bg&\u001cw\n]3sCRLwN\\\u000b\u0002QA\u00111#K\u0005\u0003UQ\u0011A!\u00168ji\")A\u0006\u0001C\u0001O\u0005aA/Z:u\u000b6\u0004H/_$fi\")a\u0006\u0001C\u0001O\u00059A/Z:u\u000f\u0016$\b\"\u0002\u0019\u0001\t\u00039\u0013\u0001\u0003;fgRDU-\u00193\t\u000bI\u0002A\u0011A\u001a\u0002#Q,7\u000f\u001e)pgR$U\u000f\u001d7jG\u0006$X\rF\u0001)\u0011\u0015)\u0004\u0001\"\u0001(\u0003e!Xm\u001d;QkR$\u0015\r^1XSRDG+[7f)>d\u0015N^3\t\u000b]\u0002A\u0011A\u0014\u0002\u001fQ,7\u000f\u001e*f[>4X-\u00128uefDQ!\u000f\u0001\u0005\u0002\u001d\n1\u0003^3ti^K\u0007/Z\"bG\",')^2lKRDQa\u000f\u0001\u0005\u0002\u001d\n!\u0003^3ti\u0006\u001b\u0018P\\2BI\u0012\u0014V-\\8wK\")Q\b\u0001C\u0001O\u0005Q2\u000f[8vY\u0012\u001cu\u000e]3XSRD7+\u001a:jC2L'0\u00192mK\"\u0012Ah\u0010\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b1\"\u00198o_R\fG/[8og*\u0011AIB\u0001\u0007i\u0016\u001cHO\\4\n\u0005\u0019\u000b%\u0001\u0002+fgRDQ\u0001\u0013\u0001\u0005\u0002\u001d\n\u0011$\u001b8tKJ$8+\u001a:jC2L'0\u00192mK>\u0013'.Z2ug\"\u0012qi\u0010\u0015\u0003\u0001}\u0002")
public class IntegrationTest
implements ScalaObject {
    private final String HOST;

    public String HOST() {
        return this.HOST;
    }

    public void testBasicOperation() {
        HttpClient client = new HttpClient();
        PutMethod insert = new PutMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache/mydata").toString());
        TopScope$ topScope$ = package$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
        insert.setRequestBody((InputStream)new ByteArrayInputStream(initialXML.toString().getBytes()));
        insert.setRequestHeader("Content-Type", "application/octet-stream");
        Client$.MODULE$.call((HttpMethodBase)insert);
        Assert.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        Assert.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache/mydata").toString());
        Client$.MODULE$.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        Assert.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        TopScope$ topScope$2 = package$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        Assert.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        Assert.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache/mydata").toString());
        Client$.MODULE$.call((HttpMethodBase)remove);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)insert);
        Client$.MODULE$.call((HttpMethodBase)get);
        TopScope$ topScope$3 = package$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        Assert.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache").toString());
        Client$.MODULE$.call((HttpMethodBase)removeAll);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache/mydata").toString());
        insertMore.setRequestBody((InputStream)new ByteArrayInputStream(byteData));
        insertMore.setRequestHeader("Content-Type", "application/octet-stream");
        Client$.MODULE$.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache/mydata").toString());
        Client$.MODULE$.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        Assert.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        Assert.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/emptycache/nodata").toString())).getStatusCode());
    }

    public void testGet() {
        PostMethod post = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/more2/data").toString());
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/more2/data").toString()));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead() {
        PostMethod post = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/more/data").toString());
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/more/data").toString()));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testPostDuplicate() {
        PostMethod post = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/data").toString());
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        Assert.assertEquals((int)409, (int)Client$.MODULE$.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/data").toString());
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive() {
        PostMethod post = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/putttl/data").toString());
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "2");
        post.setRequestHeader("maxIdleTimeSeconds", "3");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/putttl/data").toString()));
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        Thread.sleep(3000L);
        Client$.MODULE$.call(get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testRemoveEntry() {
        PostMethod put = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString());
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString())).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString()));
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString())).getStatusCode());
    }

    public void testWipeCacheBucket() {
        PostMethod put = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString());
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove2").toString());
        put_.setRequestHeader("Content-Type", "application/text");
        put_.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put_);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString())).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee").toString()));
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString())).getStatusCode());
    }

    public void testAsyncAddRemove() {
        PostMethod put = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/async").toString());
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestHeader("performAsync", "true");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Thread.sleep(50L);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/async").toString())).getStatusCode());
        DeleteMethod del = new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/async").toString());
        del.setRequestHeader("performAsync", "true");
        Client$.MODULE$.call((HttpMethodBase)del);
        Thread.sleep(50L);
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/async").toString())).getStatusCode());
    }

    @Test
    public void shouldCopeWithSerializable() {
        Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/wang/wangKey").toString()));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        ManagerInstance$.MODULE$.getCache("wang").put("wangKey", obj);
        ManagerInstance$.MODULE$.getCache("wang").put("wangKey2", "hola");
        ManagerInstance$.MODULE$.getCache("wang").put("wangKey3", new MyNonSer());
        GetMethod get = new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/wang/wangKey").toString());
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((String)"mic", (String)res.name());
        Assert.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/wang/wangKey2").toString()));
        Assert.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        Assert.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        Assert.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/wang/wangKey3").toString());
        get3.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get3);
        Assert.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        Assert.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    @Test
    public void insertSerializableObjects() {
        PutMethod put = new PutMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/something").toString());
        put.setRequestHeader("Content-Type", "application/x-java-serialized-object");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        put.setRequestBody((InputStream)new ByteArrayInputStream(bout.toByteArray()));
        Client$.MODULE$.call((HttpMethodBase)put);
        MySer x = (MySer)ManagerInstance$.MODULE$.getCache("posteee").get("something");
        String string = x.name();
        String string2 = "mic";
        Assert.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888/";
    }
}

