/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.Client$;
import org.infinispan.rest.ManagerInstance$;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="rest.IntegrationTest")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0005\u0003\u001f%sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\tI,7\u000f\u001e\u0006\u0003\u000b\u0019\t!\"\u001b8gS:L7\u000f]1o\u0015\u00059\u0011aA8sO\u000e\u00011c\u0001\u0001\u000b%A\u00111\u0002E\u0007\u0002\u0019)\u0011QBD\u0001\u0005Y\u0006twMC\u0001\u0010\u0003\u0011Q\u0017M^1\n\u0005Ea!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0002}\tA\u0001S(T)V\t\u0001\u0005\u0005\u0002\fC%\u0011!\u0005\u0004\u0002\u0007'R\u0014\u0018N\\4\t\r\u0011\u0002\u0001\u0015!\u0003!\u0003\u0015Auj\u0015+!\u0011\u001d1\u0003A1A\u0005\u0002}\t\u0011bY1dQ\u0016t\u0015-\\3\t\r!\u0002\u0001\u0015!\u0003!\u0003)\u0019\u0017m\u00195f\u001d\u0006lW\r\t\u0005\bU\u0001\u0011\r\u0011\"\u0001 \u0003!1W\u000f\u001c7QCRD\u0007B\u0002\u0017\u0001A\u0003%\u0001%A\u0005gk2d\u0007+\u0019;iA!9a\u0006\u0001b\u0001\n\u0003y\u0012\u0001\u0006#B)\u0016{\u0006+\u0011+U\u000bJsuL\u0015$DcE\u00124\u0007\u0003\u00041\u0001\u0001\u0006I\u0001I\u0001\u0016\t\u0006#Vi\u0018)B)R+%KT0S\r\u000e\u000b\u0014GM\u001a!\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003I!Xm\u001d;CCNL7m\u00149fe\u0006$\u0018n\u001c8\u0015\u0005Q:\u0004CA\n6\u0013\t1DC\u0001\u0003V]&$\b\"\u0002\u001d2\u0001\u0004I\u0014!A7\u0011\u0005ijT\"A\u001e\u000b\u0005qb\u0011a\u0002:fM2,7\r^\u0005\u0003}m\u0012a!T3uQ>$\u0007\"\u0002!\u0001\t\u0003\t\u0015\u0001\u0004;fgR,U\u000e\u001d;z\u000f\u0016$X#\u0001\u001b\t\u000b\r\u0003A\u0011\u0001#\u0002\u000fQ,7\u000f^$fiR\u0011A'\u0012\u0005\u0006q\t\u0003\r!\u000f\u0005\u0006\u000f\u0002!\t\u0001S\u0001\ti\u0016\u001cH\u000fS3bIR\u0011A'\u0013\u0005\u0006q\u0019\u0003\r!\u000f\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0014i\u0016\u001cHoR3u\u0013\u001a,f.\\8eS\u001aLW\r\u001a\u000b\u0003i5CQ\u0001\u000f&A\u0002eBQa\u0014\u0001\u0005\u0002A\u000b\u0011\u0003^3tiB{7\u000f\u001e#va2L7-\u0019;f)\t!\u0014\u000bC\u00039\u001d\u0002\u0007\u0011\bC\u0003T\u0001\u0011\u0005A+A\ruKN$\b+\u001e;ECR\fw+\u001b;i)&lW\rV8MSZ,GC\u0001\u001bV\u0011\u0015A$\u000b1\u0001:\u0011\u00159\u0006\u0001\"\u0001Y\u0003i!Xm\u001d;QkR$\u0015\r^1XSRDW*\u0019=JI2,wJ\u001c7z)\t!\u0014\fC\u00039-\u0002\u0007\u0011\bC\u0003\\\u0001\u0011\u0005A,A\u000fuKN$\b+\u001e;ECR\fw+\u001b;i)&lW\rV8MSZ,wJ\u001c7z)\t!T\fC\u000395\u0002\u0007\u0011\bC\u0003`\u0001\u0011%\u0001-A\rqkR\fe\u000eZ!tg\u0016\u0014H/\u00129iK6,'/\u00197ECR\fG\u0003\u0002\u001bbE*DQ\u0001\u000f0A\u0002eBQa\u00190A\u0002\u0011\f\u0011\u0003^5nKR{G*\u001b<f'\u0016\u001cwN\u001c3t!\t)\u0007N\u0004\u0002\u0014M&\u0011q\rF\u0001\u0007!J,G-\u001a4\n\u0005\tJ'BA4\u0015\u0011\u0015Yg\f1\u0001e\u0003Ii\u0017\r_%eY\u0016$\u0016.\\3TK\u000e|g\u000eZ:\t\u000b5\u0004A\u0011\u00018\u0002\u001fQ,7\u000f\u001e*f[>4X-\u00128uef$\"\u0001N8\t\u000bab\u0007\u0019A\u001d\t\u000bE\u0004A\u0011\u0001:\u0002'Q,7\u000f^,ja\u0016\u001c\u0015m\u00195f\u0005V\u001c7.\u001a;\u0015\u0005Q\u001a\b\"\u0002\u001dq\u0001\u0004I\u0004\"B;\u0001\t\u00031\u0018A\u0005;fgR\f5/\u001f8d\u0003\u0012$'+Z7pm\u0016$\"\u0001N<\t\u000ba\"\b\u0019A\u001d\t\u000be\u0004A\u0011\u0001>\u0002=Q,7\u000f^*i_VdGmQ8qK^KG\u000f[*fe&\fG.\u001b>bE2,GC\u0001\u001b|\u0011\u0015A\u0004\u00101\u0001:\u0011\u0015i\b\u0001\"\u0001\u007f\u0003u!Xm\u001d;J]N,'\u000f^*fe&\fG.\u001b>bE2,wJ\u00196fGR\u001cHC\u0001\u001b\u0000\u0011\u0015AD\u00101\u0001:\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\tA\u0003^3ti:{g.\u001a=jgR,g\u000e^\"bG\",Gc\u0001\u001b\u0002\b!1\u0001(!\u0001A\u0002eBq!a\u0003\u0001\t\u0003\ti!\u0001\u0011uKN$()\u001f;f\u0003J\u0014\u0018-_!t'\u0016\u0014\u0018.\u00197ju\u0016$wJ\u00196fGR\u001cHc\u0001\u001b\u0002\u0010!1\u0001(!\u0003A\u0002eBq!a\u0005\u0001\t\u0003\t)\"A\u0011uKN$()\u001f;f\u0003J\u0014\u0018-_!t\u001f\u000e$XmY*ue\u0016\fWn\u00142kK\u000e$8\u000fF\u00025\u0003/Aa\u0001OA\t\u0001\u0004I\u0004bBA\u000e\u0001\u0011%\u0011QD\u0001\u0010g\u0016tGMQ=uK\u0006\u0013(/Y=BgR)A'a\b\u0002\"!1\u0001(!\u0007A\u0002eBq!a\t\u0002\u001a\u0001\u0007A-A\u0006d_:$XM\u001c;UsB,\u0007bBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0001\u0016i\u0016\u001cH/\u00134V]6|G-\u001b4jK\u0012\u001c\u0016N\\2f)\r!\u00141\u0006\u0005\u0007q\u0005\u0015\u0002\u0019A\u001d\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005yA/Z:u\u000bR\u000bwm\u00115b]\u001e,7\u000fF\u00025\u0003gAa\u0001OA\u0017\u0001\u0004I\u0004bBA\u001c\u0001\u0011\u0005\u0011\u0011H\u0001\u001di\u0016\u001cHoU3sS\u0006d\u0017N_3e'R\u0014\u0018N\\4HKR\u0014\u0015\u0010^3t)\r!\u00141\b\u0005\u0007q\u0005U\u0002\u0019A\u001d\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B\u0005\u0019\u0001/\u001e;\u0015\t\u0005\r\u0013q\u000b\t\u0005\u0003\u000b\n\u0019&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003)AG\u000f\u001e9dY&,g\u000e\u001e\u0006\u0005\u0003\u001b\ny%A\u0004d_6lwN\\:\u000b\u0007\u0005Ec!\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003+\n9E\u0001\bIiR\u0004X*\u001a;i_\u0012\u0014\u0015m]3\t\ra\ni\u00041\u0001:\u0011\u001d\ty\u0004\u0001C\u0005\u00037\"b!a\u0011\u0002^\u0005}\u0003B\u0002\u001d\u0002Z\u0001\u0007\u0011\b\u0003\u0005\u0002b\u0005e\u0003\u0019AA2\u0003\u0011!\u0017\r^1\u0011\u0007M\t)'C\u0002\u0002hQ\u00111!\u00118z\u0011\u001d\ty\u0004\u0001C\u0005\u0003W\"\u0002\"a\u0011\u0002n\u0005=\u0014\u0011\u000f\u0005\u0007q\u0005%\u0004\u0019A\u001d\t\u0011\u0005\u0005\u0014\u0011\u000ea\u0001\u0003GBq!a\t\u0002j\u0001\u0007A\rC\u0004\u0002v\u0001!I!a\u001e\u0002\u0007\u001d,G\u000f\u0006\u0003\u0002D\u0005e\u0004B\u0002\u001d\u0002t\u0001\u0007\u0011\bC\u0004\u0002v\u0001!I!! \u0015\r\u0005\r\u0013qPAA\u0011\u0019A\u00141\u0010a\u0001s!A\u00111QA>\u0001\u0004\t))\u0001\u0006v]6|GmU5oG\u0016\u0004BaEADI&\u0019\u0011\u0011\u0012\u000b\u0003\r=\u0003H/[8o\u0011\u001d\t)\b\u0001C\u0005\u0003\u001b#\u0002\"a\u0011\u0002\u0010\u0006E\u00151\u0013\u0005\u0007q\u0005-\u0005\u0019A\u001d\t\u0011\u0005\r\u00151\u0012a\u0001\u0003\u000bC\u0001\"!&\u0002\f\u0002\u0007\u0011QQ\u0001\u000bC\u000e\u001cW\r\u001d;UsB,\u0007bBA;\u0001\u0011%\u0011\u0011\u0014\u000b\u000b\u0003\u0007\nY*!(\u0002 \u0006\u0005\u0006B\u0002\u001d\u0002\u0018\u0002\u0007\u0011\b\u0003\u0005\u0002\u0004\u0006]\u0005\u0019AAC\u0011!\t)*a&A\u0002\u0005\u0015\u0005\u0002CAR\u0003/\u0003\r!!*\u0002\u000f\u0015D\boQ8eKB\u00191#a*\n\u0007\u0005%FCA\u0002J]RDq!!,\u0001\t\u0013\ty+A\u0006gk2d\u0007+\u0019;i\u0017\u0016LHc\u00013\u00022\"1\u0001(a+A\u0002eBq!!.\u0001\t\u0003\t9,\u0001\u0004bI\u0012$\u0015-\u001f\u000b\u0006I\u0006e\u0016Q\u0018\u0005\b\u0003w\u000b\u0019\f1\u0001e\u0003\u0015\tG)\u0019;f\u0011!\ty,a-A\u0002\u0005\u0015\u0016\u0001\u00023bsND3\u0002AAb\u0003'\f).a7\u0002^B!\u0011QYAh\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017aC1o]>$\u0018\r^5p]NT1!!4\u0007\u0003\u0019!Xm\u001d;oO&!\u0011\u0011[Ad\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\t\t9.\t\u0002\u0002Z\u0006Qa-\u001e8di&|g.\u00197\u0002\u0011Q,7\u000f\u001e(b[\u0016\f#!a8\u0002)I,7\u000f\u001e\u0018J]R,wM]1uS>tG+Z:u\u0001")
public class IntegrationTest
implements ScalaObject {
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"rest/").append((Object)this.cacheName()).toString();
    private final String DATE_PATTERN_RFC1123;

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String DATE_PATTERN_RFC1123() {
        return this.DATE_PATTERN_RFC1123;
    }

    public void testBasicOperation(Method m) {
        HttpClient client = new HttpClient();
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        TopScope$ topScope$ = package$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
        insert.setRequestBody((InputStream)new ByteArrayInputStream(initialXML.toString().getBytes()));
        insert.setRequestHeader("Content-Type", "application/octet-stream");
        Client$.MODULE$.call((HttpMethodBase)insert);
        Assert.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        Assert.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        Assert.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        TopScope$ topScope$2 = package$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        Assert.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        Assert.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)remove);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)insert);
        Client$.MODULE$.call((HttpMethodBase)get);
        TopScope$ topScope$3 = package$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        Assert.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        Client$.MODULE$.call((HttpMethodBase)removeAll);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestBody((InputStream)new ByteArrayInputStream(byteData));
        insertMore.setRequestHeader("Content-Type", "application/octet-stream");
        Client$.MODULE$.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        Assert.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        Assert.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        Assert.assertNotNull((Object)lastMod);
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = Client$.MODULE$.call((HttpMethodBase)getAgain);
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        Assert.assertEquals((int)409, (int)Client$.MODULE$.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = scala.math.package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(timeToLiveSeconds).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = scala.math.package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(maxIdleTimeSeconds).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        Client$.MODULE$.call(get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestHeader("Content-Type", "application/text");
        put_.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put_);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestHeader("performAsync", "true");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Thread.sleep(50L);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        Client$.MODULE$.call((HttpMethodBase)del);
        Thread.sleep(50L);
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(m.getName(), obj);
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), "hola");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((String)"mic", (String)res.name());
        Assert.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        Assert.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        Assert.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        Assert.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get3);
        Assert.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        Assert.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(m, bout.toByteArray(), "application/x-java-serialized-object");
        byte[] cfr_ignored_0 = (byte[])ManagerInstance$.MODULE$.getCache("___defaultcache").get(m.getName());
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        Assert.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Assert.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), (ClassManifest)Manifest$.MODULE$.Byte());
        this.put(m, serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        Assert.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        Assert.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)dateLast)).getResponseBodyAsString());
        Assert.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)datePlus)).getResponseBodyAsString());
        HttpMethodBase httpMethodBase = this.get(m, (Option<String>)new Some((Object)dateMinus), (Option<String>)None$.MODULE$, 412);
    }

    public void testETagChanges(Method m) {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        Assert.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        Assert.assertFalse((boolean)eTagFirst.equals(eTagSecond));
    }

    public void testSerializedStringGetBytes(Method m) {
        byte[] data = new StringBuilder().append((Object)"v-").append((Object)m.getName()).toString().getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(m, bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"application/x-java-serialized-object")).getResponseBody();
        Assert.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        Assert.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    private HttpMethodBase put(Method m) {
        return this.put(m, "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) {
        return this.put(m, data, "application/text");
    }

    private HttpMethodBase put(Method m, Object data, String contentType) {
        Object object;
        block4: {
            StringRequestEntity stringRequestEntity;
            PutMethod put;
            block3: {
                block2: {
                    put = new PutMethod(this.fullPathKey(m));
                    put.setRequestHeader("Content-Type", contentType);
                    object = data;
                    if (!(object instanceof String)) break block2;
                    stringRequestEntity = new StringRequestEntity((String)object);
                    break block3;
                }
                if (!(object instanceof byte[])) break block4;
                stringRequestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream((byte[])object));
            }
            StringRequestEntity reqEntity = stringRequestEntity;
            put.setRequestEntity((RequestEntity)reqEntity);
            Client$.MODULE$.call((HttpMethodBase)put);
            Assert.assertEquals((int)200, (int)put.getStatusCode());
            return put;
        }
        throw new MatchError(object);
    }

    private HttpMethodBase get(Method m) {
        return this.get(m, (Option<String>)None$.MODULE$);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince) {
        return this.get(m, unmodSince, (Option<String>)None$.MODULE$, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType) {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType, int expCode) {
        GetMethod get = new GetMethod(this.fullPathKey(m));
        Option<String> option = unmodSince;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            get.setRequestHeader("If-Unmodified-Since", (String)unmodSince.get());
        }
        Option<String> option2 = acceptType;
        None$ none$2 = None$.MODULE$;
        if (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) {
            get.setRequestHeader("Accept", (String)acceptType.get());
        }
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    private String fullPathKey(Method m) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    public String addDay(String aDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat(this.DATE_PATTERN_RFC1123(), Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888/";
        this.cacheName = "___defaultcache";
        this.DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    }
}

