/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.Client$;
import org.infinispan.rest.ManagerInstance$;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.rest.ServerInstance$;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="rest.IntegrationTest")
@ScalaSignature(bytes="\u0006\u0001\t\re\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0005\u0003\u001f%sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\tI,7\u000f\u001e\u0006\u0003\u000b\u0019\t!\"\u001b8gS:L7\u000f]1o\u0015\u00059\u0011aA8sO\u000e\u00011c\u0001\u0001\u000b%A\u00111\u0002E\u0007\u0002\u0019)\u0011QBD\u0001\u0005Y\u0006twMC\u0001\u0010\u0003\u0011Q\u0017M^1\n\u0005Ea!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0002}\tA\u0001S(T)V\t\u0001\u0005\u0005\u0002\fC%\u0011!\u0005\u0004\u0002\u0007'R\u0014\u0018N\\4\t\r\u0011\u0002\u0001\u0015!\u0003!\u0003\u0015Auj\u0015+!\u0011\u001d1\u0003A1A\u0005\u0002}\t\u0011bY1dQ\u0016t\u0015-\\3\t\r!\u0002\u0001\u0015!\u0003!\u0003)\u0019\u0017m\u00195f\u001d\u0006lW\r\t\u0005\bU\u0001\u0011\r\u0011\"\u0001 \u0003!1W\u000f\u001c7QCRD\u0007B\u0002\u0017\u0001A\u0003%\u0001%A\u0005gk2d\u0007+\u0019;iA!9a\u0006\u0001b\u0001\n\u0003y\u0012\u0001\u0006#B)\u0016{\u0006+\u0011+U\u000bJsuL\u0015$DcE\u00124\u0007\u0003\u00041\u0001\u0001\u0006I\u0001I\u0001\u0016\t\u0006#Vi\u0018)B)R+%KT0S\r\u000e\u000b\u0014GM\u001a!\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0015\u0019X\r^+q)\u0005!\u0004CA\n6\u0013\t1DC\u0001\u0003V]&$\bFA\u00199!\tId(D\u0001;\u0015\tYD(A\u0006b]:|G/\u0019;j_:\u001c(BA\u001f\u0007\u0003\u0019!Xm\u001d;oO&\u0011qH\u000f\u0002\f\u0005\u00164wN]3DY\u0006\u001c8\u000fC\u0003B\u0001\u0011\u00051'\u0001\u0005uK\u0006\u0014Hi\\<oQ\t\u00015\t\u0005\u0002:\t&\u0011QI\u000f\u0002\u000b\u0003\u001a$XM]\"mCN\u001c\b\"B$\u0001\t\u0003A\u0015A\u0005;fgR\u0014\u0015m]5d\u001fB,'/\u0019;j_:$\"\u0001N%\t\u000b)3\u0005\u0019A&\u0002\u00035\u0004\"\u0001T(\u000e\u00035S!A\u0014\u0007\u0002\u000fI,g\r\\3di&\u0011\u0001+\u0014\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000bI\u0003A\u0011A*\u0002\u0019Q,7\u000f^#naRLx)\u001a;\u0016\u0003QBQ!\u0016\u0001\u0005\u0002Y\u000bq\u0001^3ti\u001e+G\u000f\u0006\u00025/\")!\n\u0016a\u0001\u0017\")\u0011\f\u0001C\u00015\u0006AA/Z:u\u0011\u0016\fG\r\u0006\u000257\")!\n\u0017a\u0001\u0017\")Q\f\u0001C\u0001=\u0006\u0019B/Z:u\u000f\u0016$\u0018JZ+o[>$\u0017NZ5fIR\u0011Ag\u0018\u0005\u0006\u0015r\u0003\ra\u0013\u0005\u0006C\u0002!\tAY\u0001\u0012i\u0016\u001cH\u000fU8ti\u0012+\b\u000f\\5dCR,GC\u0001\u001bd\u0011\u0015Q\u0005\r1\u0001L\u0011\u0015)\u0007\u0001\"\u0001g\u0003e!Xm\u001d;QkR$\u0015\r^1XSRDG+[7f)>d\u0015N^3\u0015\u0005Q:\u0007\"\u0002&e\u0001\u0004Y\u0005\"B5\u0001\t\u0003Q\u0017A\u0007;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5NCbLE\r\\3P]2LHC\u0001\u001bl\u0011\u0015Q\u0005\u000e1\u0001L\u0011\u0015i\u0007\u0001\"\u0001o\u0003u!Xm\u001d;QkR$\u0015\r^1XSRDG+[7f)>d\u0015N^3P]2LHC\u0001\u001bp\u0011\u0015QE\u000e1\u0001L\u0011\u0015\t\b\u0001\"\u0003s\u0003e\u0001X\u000f^!oI\u0006\u001b8/\u001a:u\u000bBDW-\\3sC2$\u0015\r^1\u0015\tQ\u001aH\u000f \u0005\u0006\u0015B\u0004\ra\u0013\u0005\u0006kB\u0004\rA^\u0001\u0012i&lW\rV8MSZ,7+Z2p]\u0012\u001c\bCA<{\u001d\t\u0019\u00020\u0003\u0002z)\u00051\u0001K]3eK\u001aL!AI>\u000b\u0005e$\u0002\"B?q\u0001\u00041\u0018AE7bq&#G.\u001a+j[\u0016\u001cVmY8oINDaa \u0001\u0005\u0002\u0005\u0005\u0011A\u0006;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5JM6\u000bGo\u00195\u0015\u0007Q\n\u0019\u0001C\u0003K}\u0002\u00071\nC\u0004\u0002\b\u0001!\t!!\u0003\u00025Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"LeMT8oK6\u000bGo\u00195\u0015\u0007Q\nY\u0001\u0003\u0004K\u0003\u000b\u0001\ra\u0013\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0003y!Xm\u001d;QkR$\u0015\r^1XSRD\u0017JZ'pI&4\u0017.\u001a3TS:\u001cW\rF\u00025\u0003'AaASA\u0007\u0001\u0004Y\u0005bBA\f\u0001\u0011\u0005\u0011\u0011D\u0001!i\u0016\u001cH\u000fU;u\t\u0006$\u0018mV5uQ&3WK\\'pI&4\u0017.\u001a3TS:\u001cW\rF\u00025\u00037AaASA\u000b\u0001\u0004Y\u0005bBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\u001ai\u0016\u001cH\u000fR3mKR,G)\u0019;b/&$\b.\u00134NCR\u001c\u0007\u000eF\u00025\u0003GAaASA\u000f\u0001\u0004Y\u0005bBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0001\u001ei\u0016\u001cH\u000fR3mKR,G)\u0019;b/&$\b.\u00134O_:,W*\u0019;dQR\u0019A'a\u000b\t\r)\u000b)\u00031\u0001L\u0011\u001d\ty\u0003\u0001C\u0001\u0003c\t\u0011\u0005^3ti\u0012+G.\u001a;f\t\u0006$\u0018mV5uQ&3Wj\u001c3jM&,GmU5oG\u0016$2\u0001NA\u001a\u0011\u0019Q\u0015Q\u0006a\u0001\u0017\"9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0012a\t;fgR$U\r\\3uK\u0012\u000bG/Y,ji\"Le-\u00168n_\u0012Lg-[3e'&t7-\u001a\u000b\u0004i\u0005m\u0002B\u0002&\u00026\u0001\u00071\nC\u0004\u0002@\u0001!\t!!\u0011\u0002QQ,7\u000f\u001e#fY\u0016$XmQ1dQ\u0016\u0004&/Z2p]\u0012LG/[8o+:LW\u000e\u001d7f[\u0016tG/\u001a3\u0015\u0007Q\n\u0019\u0005\u0003\u0004K\u0003{\u0001\ra\u0013\u0005\b\u0003\u000f\u0002A\u0011BA%\u0003\u0015\"Xm\u001d;EK2,G/\u001a)sK\u000e|g\u000eZ5uS>t\u0017\r\\+oS6\u0004H.Z7f]R,G\rF\u00025\u0003\u0017Bq!!\u0014\u0002F\u0001\u0007a/A\u0006gk2d\u0007+\u0019;i\u0017\u0016L\bbBA$\u0001\u0011%\u0011\u0011\u000b\u000b\u0006i\u0005M\u0013Q\u000b\u0005\b\u0003\u001b\ny\u00051\u0001w\u0011\u001d\t9&a\u0014A\u0002Y\f\u0001\u0004\u001d:fG>tG-\u001b;j_:\fG\u000eS3bI\u0016\u0014h*Y7f\u0011\u001d\tY\u0006\u0001C\u0005\u0003;\nA#Y:tKJ$hj\u001c;J[BdW-\\3oi\u0016$Gc\u0001\u001b\u0002`!A\u0011\u0011MA-\u0001\u0004\t\u0019'\u0001\u0004nKRDw\u000e\u001a\t\u0005\u0003K\n\u0019(\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003)AG\u000f\u001e9dY&,g\u000e\u001e\u0006\u0005\u0003[\ny'A\u0004d_6lwN\\:\u000b\u0007\u0005Ed!\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003k\n9G\u0001\u0006IiR\u0004X*\u001a;i_\u0012Dq!!\u001f\u0001\t\u0003\tY(A\buKN$(+Z7pm\u0016,e\u000e\u001e:z)\r!\u0014Q\u0010\u0005\u0007\u0015\u0006]\u0004\u0019A&\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\u0006\u0019B/Z:u/&\u0004XmQ1dQ\u0016\u0014UoY6fiR\u0019A'!\"\t\r)\u000by\b1\u0001L\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017\u000b!\u0003^3ti\u0006\u001b\u0018P\\2BI\u0012\u0014V-\\8wKR\u0019A'!$\t\r)\u000b9\t1\u0001L\u0011\u001d\t\t\n\u0001C\u0001\u0003'\u000ba\u0004^3tiNCw.\u001e7e\u0007>\u0004XmV5uQN+'/[1mSj\f'\r\\3\u0015\u0007Q\n)\n\u0003\u0004K\u0003\u001f\u0003\ra\u0013\u0005\b\u00033\u0003A\u0011AAN\u0003u!Xm\u001d;J]N,'\u000f^*fe&\fG.\u001b>bE2,wJ\u00196fGR\u001cHc\u0001\u001b\u0002\u001e\"1!*a&A\u0002-Cq!!)\u0001\t\u0003\t\u0019+\u0001\u000buKN$hj\u001c8fq&\u001cH/\u001a8u\u0007\u0006\u001c\u0007.\u001a\u000b\u0004i\u0005\u0015\u0006B\u0002&\u0002 \u0002\u00071\nC\u0004\u0002*\u0002!\t!a+\u0002AQ,7\u000f\u001e\"zi\u0016\f%O]1z\u0003N\u001cVM]5bY&TX\rZ(cU\u0016\u001cGo\u001d\u000b\u0004i\u00055\u0006B\u0002&\u0002(\u0002\u00071\nC\u0004\u00022\u0002!\t!a-\u0002CQ,7\u000f\u001e\"zi\u0016\f%O]1z\u0003N|5\r^3d'R\u0014X-Y7PE*,7\r^:\u0015\u0007Q\n)\f\u0003\u0004K\u0003_\u0003\ra\u0013\u0005\b\u0003s\u0003A\u0011BA^\u0003=\u0019XM\u001c3CsR,\u0017I\u001d:bs\u0006\u001bH#\u0002\u001b\u0002>\u0006}\u0006B\u0002&\u00028\u0002\u00071\nC\u0004\u0002B\u0006]\u0006\u0019\u0001<\u0002\u0017\r|g\u000e^3oiRK\b/\u001a\u0005\b\u0003\u000b\u0004A\u0011AAd\u0003U!Xm\u001d;JMVsWn\u001c3jM&,GmU5oG\u0016$2\u0001NAe\u0011\u0019Q\u00151\u0019a\u0001\u0017\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0017a\u0004;fgR,E+Y4DQ\u0006tw-Z:\u0015\u0007Q\n\t\u000e\u0003\u0004K\u0003\u0017\u0004\ra\u0013\u0005\b\u0003+\u0004A\u0011AAl\u0003q!Xm\u001d;TKJL\u0017\r\\5{K\u0012\u001cFO]5oO\u001e+GOQ=uKN$2\u0001NAm\u0011\u0019Q\u00151\u001ba\u0001\u0017\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0017!\t;fgR$UMZ1vYR\u001cuN\u001c4jOV\u0014X\rZ#ya&\u0014\u0018PV1mk\u0016\u001cHc\u0001\u001b\u0002b\"1!*a7A\u0002-Cq!!:\u0001\t\u0013\t9/\u0001\u0007xC&$hj\u001c;G_VtG\rF\u00045\u0003S\f\u00190!@\t\u0011\u0005-\u00181\u001da\u0001\u0003[\f\u0011b\u001d;beR$\u0016.\\3\u0011\u0007M\ty/C\u0002\u0002rR\u0011A\u0001T8oO\"A\u0011Q_Ar\u0001\u0004\t90\u0001\u0005mS\u001a,7\u000f]1o!\r\u0019\u0012\u0011`\u0005\u0004\u0003w$\"aA%oi\"9\u0011QJAr\u0001\u00041\bb\u0002B\u0001\u0001\u0011%!1A\u0001\u0004aV$H\u0003\u0002B\u0003\u0005\u0017\u0001B!!\u001a\u0003\b%!!\u0011BA4\u00059AE\u000f\u001e9NKRDw\u000e\u001a\"bg\u0016DaASA\u0000\u0001\u0004Y\u0005b\u0002B\u0001\u0001\u0011%!q\u0002\u000b\u0007\u0005\u000b\u0011\tBa\u0005\t\r)\u0013i\u00011\u0001L\u0011!\u0011)B!\u0004A\u0002\t]\u0011\u0001\u00023bi\u0006\u00042a\u0005B\r\u0013\r\u0011Y\u0002\u0006\u0002\u0004\u0003:L\bb\u0002B\u0001\u0001\u0011%!q\u0004\u000b\t\u0005\u000b\u0011\tCa\t\u0003&!1!J!\bA\u0002-C\u0001B!\u0006\u0003\u001e\u0001\u0007!q\u0003\u0005\b\u0003\u0003\u0014i\u00021\u0001w\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005W\t1aZ3u)\u0011\u0011)A!\f\t\r)\u00139\u00031\u0001L\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005c!bA!\u0002\u00034\tU\u0002B\u0002&\u00030\u0001\u00071\n\u0003\u0005\u00038\t=\u0002\u0019\u0001B\u001d\u0003))h.\\8e'&t7-\u001a\t\u0005'\tmb/C\u0002\u0003>Q\u0011aa\u00149uS>t\u0007b\u0002B\u0015\u0001\u0011%!\u0011\t\u000b\t\u0005\u000b\u0011\u0019E!\u0012\u0003H!1!Ja\u0010A\u0002-C\u0001Ba\u000e\u0003@\u0001\u0007!\u0011\b\u0005\t\u0005\u0013\u0012y\u00041\u0001\u0003:\u0005Q\u0011mY2faR$\u0016\u0010]3\t\u000f\t%\u0002\u0001\"\u0003\u0003NQQ!Q\u0001B(\u0005#\u0012\u0019F!\u0016\t\r)\u0013Y\u00051\u0001L\u0011!\u00119Da\u0013A\u0002\te\u0002\u0002\u0003B%\u0005\u0017\u0002\rA!\u000f\t\u0011\t]#1\na\u0001\u0003o\fq!\u001a=q\u0007>$W\rC\u0004\u0002N\u0001!IAa\u0017\u0015\u0007Y\u0014i\u0006\u0003\u0004K\u00053\u0002\ra\u0013\u0005\b\u0005C\u0002A\u0011\u0001B2\u0003\u0019\tG\r\u001a#bsR)aO!\u001a\u0003j!9!q\rB0\u0001\u00041\u0018!B1ECR,\u0007\u0002\u0003B6\u0005?\u0002\r!a>\u0002\t\u0011\f\u0017p\u001d\u0015\f\u0001\t=$Q\u000fB<\u0005{\u0012y\bE\u0002:\u0005cJ1Aa\u001d;\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\t\u0011I(\t\u0002\u0003|\u0005Qa-\u001e8di&|g.\u00197\u0002\u0011Q,7\u000f\u001e(b[\u0016\f#A!!\u0002)I,7\u000f\u001e\u0018J]R,wM]1uS>tG+Z:u\u0001")
public class IntegrationTest
implements ScalaObject {
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).toString();
    private final String DATE_PATTERN_RFC1123;

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String DATE_PATTERN_RFC1123() {
        return this.DATE_PATTERN_RFC1123;
    }

    @BeforeClass
    public void setUp() {
        ServerInstance$.MODULE$.start();
    }

    @AfterClass
    public void tearDown() {
        ServerInstance$.MODULE$.stop();
    }

    public void testBasicOperation(Method m) {
        HttpClient client = new HttpClient();
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        TopScope$ topScope$ = package$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
        insert.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(initialXML.toString().getBytes(), "application/octet-stream"));
        Client$.MODULE$.call((HttpMethodBase)insert);
        AssertJUnit.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        AssertJUnit.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        TopScope$ topScope$2 = package$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        AssertJUnit.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)remove);
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)insert);
        Client$.MODULE$.call((HttpMethodBase)get);
        TopScope$ topScope$3 = package$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)removeAll).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byteData, "application/octet-stream"));
        Client$.MODULE$.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        AssertJUnit.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        AssertJUnit.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        AssertJUnit.assertNotNull((Object)lastMod);
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = Client$.MODULE$.call((HttpMethodBase)getAgain);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        AssertJUnit.assertEquals((int)409, (int)Client$.MODULE$.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = scala.math.package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(timeToLiveSeconds).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = scala.math.package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(maxIdleTimeSeconds).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        Client$.MODULE$.call(get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPutDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Match", etag);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Match", "x");
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-None-Match", "x");
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-None-Match", etag);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Modified-Since", lastMod);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)304, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reputAgain.setRequestHeader("If-Modified-Since", dateMinus);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfUnModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reput.setRequestHeader("If-Unmodified-Since", dateMinus);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testDeleteDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Match", "x");
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Match", etag);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-None-Match", etag);
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-None-Match", "x");
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Modified-Since", lastMod);
        AssertJUnit.assertEquals((int)304, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        deleteAgain.setRequestHeader("If-Modified-Since", dateMinus);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfUnmodifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        delete.setRequestHeader("If-Unmodified-Since", dateMinus);
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteCachePreconditionUnimplemented(Method m) {
        this.testDeletePreconditionalUnimplemented(this.fullPath());
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey) {
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-None-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Modified-Since");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Unmodified-Since");
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey, String preconditionalHeaderName) {
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader(preconditionalHeaderName, "*");
        Client$.MODULE$.call((HttpMethodBase)delete);
        this.assertNotImplemented((HttpMethod)delete);
    }

    private void assertNotImplemented(HttpMethod method) {
        AssertJUnit.assertEquals((int)method.getStatusCode(), (int)501);
        AssertJUnit.assertEquals((String)method.getStatusText(), (String)"Not Implemented");
        Predef$.MODULE$.assert(method.getResponseBodyAsString().toLowerCase().contains("precondition"));
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put_);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("performAsync", "true");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        Client$.MODULE$.call((HttpMethodBase)del);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(m.getName(), obj);
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), "hola");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        AssertJUnit.assertNotNull((Object)res);
        AssertJUnit.assertEquals((String)"mic", (String)res.name());
        AssertJUnit.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        AssertJUnit.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get3);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(m, bout.toByteArray(), "application/x-java-serialized-object");
        byte[] cfr_ignored_0 = (byte[])ManagerInstance$.MODULE$.getCache("___defaultcache").get(m.getName());
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), (ClassManifest)Manifest$.MODULE$.Byte());
        this.put(m, serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        AssertJUnit.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)dateLast)).getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)datePlus)).getResponseBodyAsString());
        HttpMethodBase httpMethodBase = this.get(m, (Option<String>)new Some((Object)dateMinus), (Option<String>)None$.MODULE$, 412);
    }

    public void testETagChanges(Method m) {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertFalse((boolean)eTagFirst.equals(eTagSecond));
    }

    public void testSerializedStringGetBytes(Method m) {
        byte[] data = new StringBuilder().append((Object)"v-").append((Object)m.getName()).toString().getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(m, bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"application/x-java-serialized-object")).getResponseBody();
        AssertJUnit.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        AssertJUnit.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    public void testDefaultConfiguredExpiryValues(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = Predef$.MODULE$.augmentString("%s/rest/%s/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "-1");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        Thread.sleep(5000L);
        AssertJUnit.assertEquals((String)"data", (String)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getResponseBodyAsString());
        long startTime = System.currentTimeMillis();
        int lifespan = 3000;
        fullPathKey = Predef$.MODULE$.augmentString("%s-2").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        while (System.currentTimeMillis() < startTime + (long)lifespan - 10L) {
            AssertJUnit.assertEquals((String)"data2", (String)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getResponseBodyAsString());
            Thread.sleep(100L);
        }
        this.waitNotFound(startTime, lifespan, fullPathKey);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        startTime = System.currentTimeMillis();
        lifespan = 0;
        fullPathKey = Predef$.MODULE$.augmentString("%s-3").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data3", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        this.waitNotFound(startTime, lifespan, fullPathKey);
        fullPathKey = Predef$.MODULE$.augmentString("%s-4").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data4", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        Thread.sleep(2500L);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
    }

    private void waitNotFound(long startTime, int lifespan, String fullPathKey) {
        while (System.currentTimeMillis() < startTime + (long)lifespan + 20000L && !((Object)BoxesRunTime.boxToInteger((int)404)).equals(BoxesRunTime.boxToInteger((int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode()))) {
            Thread.sleep(100L);
        }
    }

    private HttpMethodBase put(Method m) {
        return this.put(m, "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) {
        return this.put(m, data, "application/text");
    }

    private HttpMethodBase put(Method m, Object data, String contentType) {
        Object object;
        block4: {
            StringRequestEntity stringRequestEntity;
            PutMethod put;
            block3: {
                block2: {
                    put = new PutMethod(this.fullPathKey(m));
                    put.setRequestHeader("Content-Type", contentType);
                    object = data;
                    if (!(object instanceof String)) break block2;
                    stringRequestEntity = new StringRequestEntity((String)object);
                    break block3;
                }
                if (!(object instanceof byte[])) break block4;
                stringRequestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream((byte[])object));
            }
            StringRequestEntity reqEntity = stringRequestEntity;
            put.setRequestEntity((RequestEntity)reqEntity);
            Client$.MODULE$.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
            return put;
        }
        throw new MatchError(object);
    }

    private HttpMethodBase get(Method m) {
        return this.get(m, (Option<String>)None$.MODULE$);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince) {
        return this.get(m, unmodSince, (Option<String>)None$.MODULE$, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType) {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType, int expCode) {
        GetMethod get = new GetMethod(this.fullPathKey(m));
        Option<String> option = unmodSince;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            get.setRequestHeader("If-Unmodified-Since", (String)unmodSince.get());
        }
        Option<String> option2 = acceptType;
        None$ none$2 = None$.MODULE$;
        if (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) {
            get.setRequestHeader("Accept", (String)acceptType.get());
        }
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    private String fullPathKey(Method m) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    public String addDay(String aDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat(this.DATE_PATTERN_RFC1123(), Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888";
        this.cacheName = "___defaultcache";
        this.DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    }
}

