/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.Client$;
import org.infinispan.rest.ManagerInstance$;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.rest.ServerInstance$;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="rest.IntegrationTest")
@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\u0001\u0003\u0001%\u0011q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA]3ti*\u0011QAB\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q!\u0003\u0005\u0002\f!5\tAB\u0003\u0002\u000e\u001d\u0005!A.\u00198h\u0015\u0005y\u0011\u0001\u00026bm\u0006L!!\u0005\u0007\u0003\r=\u0013'.Z2u!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0005\u0011>\u001bF+F\u0001!!\tY\u0011%\u0003\u0002#\u0019\t11\u000b\u001e:j]\u001eDa\u0001\n\u0001!\u0002\u0013\u0001\u0013!\u0002%P'R\u0003\u0003b\u0002\u0014\u0001\u0005\u0004%\taH\u0001\nG\u0006\u001c\u0007.\u001a(b[\u0016Da\u0001\u000b\u0001!\u0002\u0013\u0001\u0013AC2bG\",g*Y7fA!9!\u0006\u0001b\u0001\n\u0003y\u0012\u0001\u00034vY2\u0004\u0016\r\u001e5\t\r1\u0002\u0001\u0015!\u0003!\u0003%1W\u000f\u001c7QCRD\u0007\u0005C\u0004/\u0001\t\u0007I\u0011A\u0010\u0002)\u0011\u000bE+R0Q\u0003R#VI\u0015(`%\u001a\u001b\u0015'\r\u001a4\u0011\u0019\u0001\u0004\u0001)A\u0005A\u0005)B)\u0011+F?B\u000bE\u000bV#S\u001d~\u0013fiQ\u00192eM\u0002\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0014!B:fiV\u0003H#\u0001\u001b\u0011\u0005M)\u0014B\u0001\u001c\u0015\u0005\u0011)f.\u001b;)\u0005EB\u0004CA\u001d?\u001b\u0005Q$BA\u001e=\u0003-\tgN\\8uCRLwN\\:\u000b\u0005u2\u0011A\u0002;fgRtw-\u0003\u0002@u\tY!)\u001a4pe\u0016\u001cE.Y:t\u0011\u0015\t\u0005\u0001\"\u00014\u0003!!X-\u0019:E_^t\u0007\u0006\u0002!D\r\u001e\u0003\"!\u000f#\n\u0005\u0015S$AC!gi\u0016\u00148\t\\1tg\u0006I\u0011\r\\<bsN\u0014VO\\\r\u0002\u0003!)\u0011\n\u0001C\u0001\u0015\u0006\u0011B/Z:u\u0005\u0006\u001c\u0018nY(qKJ\fG/[8o)\t!4\nC\u0003M\u0011\u0002\u0007Q*A\u0001n!\tq\u0015+D\u0001P\u0015\t\u0001F\"A\u0004sK\u001adWm\u0019;\n\u0005I{%AB'fi\"|G\rC\u0003U\u0001\u0011\u0005Q+\u0001\u0007uKN$X)\u001c9us\u001e+G/F\u00015\u0011\u00159\u0006\u0001\"\u0001Y\u0003\u001d!Xm\u001d;HKR$\"\u0001N-\t\u000b13\u0006\u0019A'\t\u000bm\u0003A\u0011\u0001/\u0002\u0011Q,7\u000f\u001e%fC\u0012$\"\u0001N/\t\u000b1S\u0006\u0019A'\t\u000b}\u0003A\u0011\u00011\u0002'Q,7\u000f^$fi&3WK\\7pI&4\u0017.\u001a3\u0015\u0005Q\n\u0007\"\u0002'_\u0001\u0004i\u0005\"B2\u0001\t\u0003!\u0017!\u0005;fgR\u0004vn\u001d;EkBd\u0017nY1uKR\u0011A'\u001a\u0005\u0006\u0019\n\u0004\r!\u0014\u0005\u0006O\u0002!\t\u0001[\u0001\u001ai\u0016\u001cH\u000fU;u\t\u0006$\u0018mV5uQRKW.\u001a+p\u0019&4X\r\u0006\u00025S\")AJ\u001aa\u0001\u001b\")1\u000e\u0001C\u0001Y\u0006QB/Z:u!V$H)\u0019;b/&$\b.T1y\u0013\u0012dWm\u00148msR\u0011A'\u001c\u0005\u0006\u0019*\u0004\r!\u0014\u0005\u0006_\u0002!\t\u0001]\u0001\u001ei\u0016\u001cH\u000fU;u\t\u0006$\u0018mV5uQRKW.\u001a+p\u0019&4Xm\u00148msR\u0011A'\u001d\u0005\u0006\u0019:\u0004\r!\u0014\u0005\u0006g\u0002!I\u0001^\u0001\u001aaV$\u0018I\u001c3BgN,'\u000f^#qQ\u0016lWM]1m\t\u0006$\u0018\r\u0006\u00035kZt\b\"\u0002's\u0001\u0004i\u0005\"B<s\u0001\u0004A\u0018!\u0005;j[\u0016$v\u000eT5wKN+7m\u001c8egB\u0011\u0011\u0010 \b\u0003'iL!a\u001f\u000b\u0002\rA\u0013X\rZ3g\u0013\t\u0011SP\u0003\u0002|)!)qP\u001da\u0001q\u0006\u0011R.\u0019=JI2,G+[7f'\u0016\u001cwN\u001c3t\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\ta\u0003^3tiB+H\u000fR1uC^KG\u000f[%g\u001b\u0006$8\r\u001b\u000b\u0004i\u0005\u001d\u0001B\u0002'\u0002\u0002\u0001\u0007Q\nC\u0004\u0002\f\u0001!\t!!\u0004\u00025Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"LeMT8oK6\u000bGo\u00195\u0015\u0007Q\ny\u0001\u0003\u0004M\u0003\u0013\u0001\r!\u0014\u0005\b\u0003'\u0001A\u0011AA\u000b\u0003y!Xm\u001d;QkR$\u0015\r^1XSRD\u0017JZ'pI&4\u0017.\u001a3TS:\u001cW\rF\u00025\u0003/Aa\u0001TA\t\u0001\u0004i\u0005bBA\u000e\u0001\u0011\u0005\u0011QD\u0001!i\u0016\u001cH\u000fU;u\t\u0006$\u0018mV5uQ&3WK\\'pI&4\u0017.\u001a3TS:\u001cW\rF\u00025\u0003?Aa\u0001TA\r\u0001\u0004i\u0005bBA\u0012\u0001\u0011\u0005\u0011QE\u0001\u001ai\u0016\u001cH\u000fR3mKR,G)\u0019;b/&$\b.\u00134NCR\u001c\u0007\u000eF\u00025\u0003OAa\u0001TA\u0011\u0001\u0004i\u0005bBA\u0016\u0001\u0011\u0005\u0011QF\u0001\u001ei\u0016\u001cH\u000fR3mKR,G)\u0019;b/&$\b.\u00134O_:,W*\u0019;dQR\u0019A'a\f\t\r1\u000bI\u00031\u0001N\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003k\t\u0011\u0005^3ti\u0012+G.\u001a;f\t\u0006$\u0018mV5uQ&3Wj\u001c3jM&,GmU5oG\u0016$2\u0001NA\u001c\u0011\u0019a\u0015\u0011\u0007a\u0001\u001b\"9\u00111\b\u0001\u0005\u0002\u0005u\u0012a\t;fgR$U\r\\3uK\u0012\u000bG/Y,ji\"Le-\u00168n_\u0012Lg-[3e'&t7-\u001a\u000b\u0004i\u0005}\u0002B\u0002'\u0002:\u0001\u0007Q\nC\u0004\u0002D\u0001!\t!!\u0012\u0002QQ,7\u000f\u001e#fY\u0016$XmQ1dQ\u0016\u0004&/Z2p]\u0012LG/[8o+:LW\u000e\u001d7f[\u0016tG/\u001a3\u0015\u0007Q\n9\u0005\u0003\u0004M\u0003\u0003\u0002\r!\u0014\u0005\b\u0003\u0017\u0002A\u0011BA'\u0003\u0015\"Xm\u001d;EK2,G/\u001a)sK\u000e|g\u000eZ5uS>t\u0017\r\\+oS6\u0004H.Z7f]R,G\rF\u00025\u0003\u001fBq!!\u0015\u0002J\u0001\u0007\u00010A\u0006gk2d\u0007+\u0019;i\u0017\u0016L\bbBA&\u0001\u0011%\u0011Q\u000b\u000b\u0006i\u0005]\u0013\u0011\f\u0005\b\u0003#\n\u0019\u00061\u0001y\u0011\u001d\tY&a\u0015A\u0002a\f\u0001\u0004\u001d:fG>tG-\u001b;j_:\fG\u000eS3bI\u0016\u0014h*Y7f\u0011\u001d\ty\u0006\u0001C\u0005\u0003C\nA#Y:tKJ$hj\u001c;J[BdW-\\3oi\u0016$Gc\u0001\u001b\u0002d!A\u0011QMA/\u0001\u0004\t9'\u0001\u0004nKRDw\u000e\u001a\t\u0005\u0003S\n9(\u0004\u0002\u0002l)!\u0011QNA8\u0003)AG\u000f\u001e9dY&,g\u000e\u001e\u0006\u0005\u0003c\n\u0019(A\u0004d_6lwN\\:\u000b\u0007\u0005Ud!\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003s\nYG\u0001\u0006IiR\u0004X*\u001a;i_\u0012Dq!! \u0001\t\u0003\ty(A\buKN$(+Z7pm\u0016,e\u000e\u001e:z)\r!\u0014\u0011\u0011\u0005\u0007\u0019\u0006m\u0004\u0019A'\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\u0006\u0019B/Z:u/&\u0004XmQ1dQ\u0016\u0014UoY6fiR\u0019A'!#\t\r1\u000b\u0019\t1\u0001N\u0011\u001d\ti\t\u0001C\u0001\u0003\u001f\u000b!\u0003^3ti\u0006\u001b\u0018P\\2BI\u0012\u0014V-\\8wKR\u0019A'!%\t\r1\u000bY\t1\u0001N\u0011\u001d\t)\n\u0001C\u0001\u0003/\u000ba\u0004^3tiNCw.\u001e7e\u0007>\u0004XmV5uQN+'/[1mSj\f'\r\\3\u0015\u0007Q\nI\n\u0003\u0004M\u0003'\u0003\r!\u0014\u0005\b\u0003;\u0003A\u0011AAP\u0003u!Xm\u001d;J]N,'\u000f^*fe&\fG.\u001b>bE2,wJ\u00196fGR\u001cHc\u0001\u001b\u0002\"\"1A*a'A\u00025Cq!!*\u0001\t\u0003\t9+\u0001\u000buKN$hj\u001c8fq&\u001cH/\u001a8u\u0007\u0006\u001c\u0007.\u001a\u000b\u0004i\u0005%\u0006B\u0002'\u0002$\u0002\u0007Q\nC\u0004\u0002.\u0002!\t!a,\u0002AQ,7\u000f\u001e\"zi\u0016\f%O]1z\u0003N\u001cVM]5bY&TX\rZ(cU\u0016\u001cGo\u001d\u000b\u0004i\u0005E\u0006B\u0002'\u0002,\u0002\u0007Q\nC\u0004\u00026\u0002!\t!a.\u0002CQ,7\u000f\u001e\"zi\u0016\f%O]1z\u0003N|5\r^3d'R\u0014X-Y7PE*,7\r^:\u0015\u0007Q\nI\f\u0003\u0004M\u0003g\u0003\r!\u0014\u0005\b\u0003{\u0003A\u0011BA`\u0003=\u0019XM\u001c3CsR,\u0017I\u001d:bs\u0006\u001bH#\u0002\u001b\u0002B\u0006\r\u0007B\u0002'\u0002<\u0002\u0007Q\nC\u0004\u0002F\u0006m\u0006\u0019\u0001=\u0002\u0017\r|g\u000e^3oiRK\b/\u001a\u0005\b\u0003\u0013\u0004A\u0011AAf\u0003U!Xm\u001d;JMVsWn\u001c3jM&,GmU5oG\u0016$2\u0001NAg\u0011\u0019a\u0015q\u0019a\u0001\u001b\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0017a\u0004;fgR,E+Y4DQ\u0006tw-Z:\u0015\u0007Q\n)\u000e\u0003\u0004M\u0003\u001f\u0004\r!\u0014\u0005\b\u00033\u0004A\u0011AAn\u0003q!Xm\u001d;TKJL\u0017\r\\5{K\u0012\u001cFO]5oO\u001e+GOQ=uKN$2\u0001NAo\u0011\u0019a\u0015q\u001ba\u0001\u001b\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\u0018!\t;fgR$UMZ1vYR\u001cuN\u001c4jOV\u0014X\rZ#ya&\u0014\u0018PV1mk\u0016\u001cHc\u0001\u001b\u0002f\"1A*a8A\u00025Cq!!;\u0001\t\u0003\tY/A\u000buKN$\b+\u001e;CsR,\u0017I\u001d:bsR;\u0018nY3\u0015\u0007Q\ni\u000f\u0003\u0004M\u0003O\u0004\r!\u0014\u0005\b\u0003c\u0004A\u0011AAz\u0003i!Xm\u001d;EK2,G/Z*fe&\fG.\u001b>fI>\u0013'.Z2u)\r!\u0014Q\u001f\u0005\u0007\u0019\u0006=\b\u0019A'\t\u000f\u0005e\b\u0001\"\u0003\u0002|\u0006aq/Y5u\u001d>$hi\\;oIR9A'!@\u0003\b\tE\u0001\u0002CA\u0000\u0003o\u0004\rA!\u0001\u0002\u0013M$\u0018M\u001d;US6,\u0007cA\n\u0003\u0004%\u0019!Q\u0001\u000b\u0003\t1{gn\u001a\u0005\t\u0005\u0013\t9\u00101\u0001\u0003\f\u0005AA.\u001b4fgB\fg\u000eE\u0002\u0014\u0005\u001bI1Aa\u0004\u0015\u0005\rIe\u000e\u001e\u0005\b\u0003#\n9\u00101\u0001y\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/\t1\u0001];u)\u0011\u0011IBa\b\u0011\t\u0005%$1D\u0005\u0005\u0005;\tYG\u0001\bIiR\u0004X*\u001a;i_\u0012\u0014\u0015m]3\t\r1\u0013\u0019\u00021\u0001N\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005G!bA!\u0007\u0003&\t\u001d\u0002B\u0002'\u0003\"\u0001\u0007Q\n\u0003\u0005\u0003*\t\u0005\u0002\u0019\u0001B\u0016\u0003\u0011!\u0017\r^1\u0011\u0007M\u0011i#C\u0002\u00030Q\u00111!\u00118z\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005g!\u0002B!\u0007\u00036\t]\"\u0011\b\u0005\u0007\u0019\nE\u0002\u0019A'\t\u0011\t%\"\u0011\u0007a\u0001\u0005WAq!!2\u00032\u0001\u0007\u0001\u0010C\u0004\u0003>\u0001!IAa\u0010\u0002\u0007\u001d,G\u000f\u0006\u0003\u0003\u001a\t\u0005\u0003B\u0002'\u0003<\u0001\u0007Q\nC\u0004\u0003>\u0001!IA!\u0012\u0015\r\te!q\tB%\u0011\u0019a%1\ta\u0001\u001b\"A!1\nB\"\u0001\u0004\u0011i%\u0001\u0006v]6|GmU5oG\u0016\u0004Ba\u0005B(q&\u0019!\u0011\u000b\u000b\u0003\r=\u0003H/[8o\u0011\u001d\u0011i\u0004\u0001C\u0005\u0005+\"\u0002B!\u0007\u0003X\te#1\f\u0005\u0007\u0019\nM\u0003\u0019A'\t\u0011\t-#1\u000ba\u0001\u0005\u001bB\u0001B!\u0018\u0003T\u0001\u0007!QJ\u0001\u000bC\u000e\u001cW\r\u001d;UsB,\u0007b\u0002B\u001f\u0001\u0011%!\u0011\r\u000b\u000b\u00053\u0011\u0019G!\u001a\u0003h\t%\u0004B\u0002'\u0003`\u0001\u0007Q\n\u0003\u0005\u0003L\t}\u0003\u0019\u0001B'\u0011!\u0011iFa\u0018A\u0002\t5\u0003\u0002\u0003B6\u0005?\u0002\rAa\u0003\u0002\u000f\u0015D\boQ8eK\"9\u0011\u0011\u000b\u0001\u0005\n\t=Dc\u0001=\u0003r!1AJ!\u001cA\u00025CqA!\u001e\u0001\t\u0003\u00119(\u0001\u0004bI\u0012$\u0015-\u001f\u000b\u0006q\ne$Q\u0010\u0005\b\u0005w\u0012\u0019\b1\u0001y\u0003\u0015\tG)\u0019;f\u0011!\u0011yHa\u001dA\u0002\t-\u0011\u0001\u00023bsND3\u0002\u0001BB\u0005\u0013\u0013YI!%\u0003\u0014B\u0019\u0011H!\"\n\u0007\t\u001d%H\u0001\u0003UKN$\u0018AB4s_V\u00048\u000f\f\u0002\u0003\u000e\u0006\u0012!qR\u0001\u000bMVt7\r^5p]\u0006d\u0017\u0001\u0003;fgRt\u0015-\\3\"\u0005\tU\u0015\u0001\u0006:fgRt\u0013J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000f")
public class IntegrationTest
implements ScalaObject {
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).toString();
    private final String DATE_PATTERN_RFC1123;

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String DATE_PATTERN_RFC1123() {
        return this.DATE_PATTERN_RFC1123;
    }

    @BeforeClass
    public void setUp() {
        ServerInstance$.MODULE$.start();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        ServerInstance$.MODULE$.stop();
    }

    public void testBasicOperation(Method m) {
        HttpClient client = new HttpClient();
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
        insert.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(initialXML.toString().getBytes(), "application/octet-stream"));
        Client$.MODULE$.call((HttpMethodBase)insert);
        AssertJUnit.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        AssertJUnit.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        AssertJUnit.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)remove);
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)insert);
        Client$.MODULE$.call((HttpMethodBase)get);
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)removeAll).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byteData, "application/octet-stream"));
        Client$.MODULE$.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        AssertJUnit.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        AssertJUnit.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        AssertJUnit.assertNotNull((Object)lastMod);
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = Client$.MODULE$.call((HttpMethodBase)getAgain);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        AssertJUnit.assertEquals((int)409, (int)Client$.MODULE$.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(timeToLiveSeconds).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(maxIdleTimeSeconds).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        Client$.MODULE$.call(get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPutDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Match", etag);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Match", "x");
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-None-Match", "x");
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-None-Match", etag);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Modified-Since", lastMod);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)304, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reputAgain.setRequestHeader("If-Modified-Since", dateMinus);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfUnModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reput.setRequestHeader("If-Unmodified-Since", dateMinus);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testDeleteDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Match", "x");
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Match", etag);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-None-Match", etag);
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-None-Match", "x");
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Modified-Since", lastMod);
        AssertJUnit.assertEquals((int)304, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        deleteAgain.setRequestHeader("If-Modified-Since", dateMinus);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfUnmodifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        delete.setRequestHeader("If-Unmodified-Since", dateMinus);
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteCachePreconditionUnimplemented(Method m) {
        this.testDeletePreconditionalUnimplemented(this.fullPath());
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey) {
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-None-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Modified-Since");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Unmodified-Since");
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey, String preconditionalHeaderName) {
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader(preconditionalHeaderName, "*");
        Client$.MODULE$.call((HttpMethodBase)delete);
        this.assertNotImplemented((HttpMethod)delete);
    }

    private void assertNotImplemented(HttpMethod method) {
        AssertJUnit.assertEquals((int)method.getStatusCode(), (int)501);
        AssertJUnit.assertEquals((String)method.getStatusText(), (String)"Not Implemented");
        Predef$.MODULE$.assert(method.getResponseBodyAsString().toLowerCase().contains("precondition"));
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put_);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("performAsync", "true");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        Client$.MODULE$.call((HttpMethodBase)del);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put((Object)m.getName(), (Object)obj);
        ManagerInstance$.MODULE$.getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), (Object)"hola");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), (Object)new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        AssertJUnit.assertNotNull((Object)res);
        AssertJUnit.assertEquals((String)"mic", (String)res.name());
        AssertJUnit.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        AssertJUnit.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get3);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(m, bout.toByteArray(), "application/x-java-serialized-object");
        byte[] cfr_ignored_0 = (byte[])ManagerInstance$.MODULE$.getCache("___defaultcache").get(m.getName());
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), (ClassManifest)Manifest$.MODULE$.Byte());
        this.put(m, serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        AssertJUnit.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)dateLast)).getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)datePlus)).getResponseBodyAsString());
        HttpMethodBase httpMethodBase = this.get(m, (Option<String>)new Some((Object)dateMinus), (Option<String>)None$.MODULE$, 412);
    }

    public void testETagChanges(Method m) {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertFalse((boolean)eTagFirst.equals(eTagSecond));
    }

    public void testSerializedStringGetBytes(Method m) {
        byte[] data = new StringBuilder().append((Object)"v-").append((Object)m.getName()).toString().getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(m, bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"application/x-java-serialized-object")).getResponseBody();
        AssertJUnit.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        AssertJUnit.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    public void testDefaultConfiguredExpiryValues(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = Predef$.MODULE$.augmentString("%s/rest/%s/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "-1");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        Thread.sleep(5000L);
        AssertJUnit.assertEquals((String)"data", (String)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getResponseBodyAsString());
        long startTime = System.currentTimeMillis();
        int lifespan = 3000;
        fullPathKey = Predef$.MODULE$.augmentString("%s-2").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        while (System.currentTimeMillis() < startTime + (long)lifespan) {
            String response = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getResponseBodyAsString();
            if (System.currentTimeMillis() >= startTime + (long)lifespan) continue;
            AssertJUnit.assertEquals((String)"data2", (String)response);
            Thread.sleep(100L);
        }
        this.waitNotFound(startTime, lifespan, fullPathKey);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        startTime = System.currentTimeMillis();
        lifespan = 0;
        fullPathKey = Predef$.MODULE$.augmentString("%s-3").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data3", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        this.waitNotFound(startTime, lifespan, fullPathKey);
        fullPathKey = Predef$.MODULE$.augmentString("%s-4").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data4", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        Thread.sleep(2500L);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
    }

    public void testPutByteArrayTwice(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = new byte[]{42, 42, 42};
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
    }

    public void testDeleteSerializedObject(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = new byte[]{42, 42, 42};
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        HttpMethodBase delete = Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)delete.getStatusCode());
    }

    private void waitNotFound(long startTime, int lifespan, String fullPathKey) {
        while (System.currentTimeMillis() < startTime + (long)lifespan + 20000L && !((Object)BoxesRunTime.boxToInteger((int)404)).equals(BoxesRunTime.boxToInteger((int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode()))) {
            Thread.sleep(100L);
        }
    }

    private HttpMethodBase put(Method m) {
        return this.put(m, "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) {
        return this.put(m, data, "application/text");
    }

    private HttpMethodBase put(Method m, Object data, String contentType) {
        Object object;
        block4: {
            StringRequestEntity stringRequestEntity;
            PutMethod put;
            block3: {
                block2: {
                    put = new PutMethod(this.fullPathKey(m));
                    put.setRequestHeader("Content-Type", contentType);
                    object = data;
                    if (!(object instanceof String)) break block2;
                    stringRequestEntity = new StringRequestEntity((String)object);
                    break block3;
                }
                if (!(object instanceof byte[])) break block4;
                stringRequestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream((byte[])object));
            }
            StringRequestEntity reqEntity = stringRequestEntity;
            put.setRequestEntity((RequestEntity)reqEntity);
            Client$.MODULE$.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
            return put;
        }
        throw new MatchError(object);
    }

    private HttpMethodBase get(Method m) {
        return this.get(m, (Option<String>)None$.MODULE$);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince) {
        return this.get(m, unmodSince, (Option<String>)None$.MODULE$, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType) {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType, int expCode) {
        GetMethod get = new GetMethod(this.fullPathKey(m));
        Option<String> option = unmodSince;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            get.setRequestHeader("If-Unmodified-Since", (String)unmodSince.get());
        }
        Option<String> option2 = acceptType;
        None$ none$2 = None$.MODULE$;
        if (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) {
            get.setRequestHeader("Accept", (String)acceptType.get());
        }
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    private String fullPathKey(Method m) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    public String addDay(String aDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat(this.DATE_PATTERN_RFC1123(), Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888";
        this.cacheName = "___defaultcache";
        this.DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    }
}

