/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.ManagerInstance;
import org.infinispan.rest.ServerBootstrap;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;
import org.testng.AssertJUnit;

class RESTServerTestBase {
    private Map<String, Context> servers = new HashMap<String, Context>();
    private HttpClient client;

    RESTServerTestBase() {
    }

    protected void createClient() {
        this.client = new HttpClient();
    }

    protected void destroyClient() {
        ((SimpleHttpConnectionManager)this.client.getHttpConnectionManager()).shutdown();
        this.client = null;
    }

    protected void addServer(String name, int port, EmbeddedCacheManager cacheManager) {
        this.servers.put(name, this.createRESTEndpoint(port, cacheManager, new RestServerConfigurationBuilder().build()));
    }

    protected void addServer(String name, int port, EmbeddedCacheManager cacheManager, RestServerConfiguration configuration) {
        this.servers.put(name, this.createRESTEndpoint(port, cacheManager, configuration));
    }

    protected void removeServers() {
        this.servers.clear();
    }

    protected EmbeddedCacheManager getCacheManager(String name) {
        Context ctx = this.servers.get(name);
        if (ctx == null) {
            return null;
        }
        return ServerBootstrap.getCacheManager((ServletContext)ctx.getServletContext());
    }

    protected ManagerInstance getManagerInstance(String name) {
        Context ctx = this.servers.get(name);
        if (ctx == null) {
            return null;
        }
        return ServerBootstrap.getManagerInstance((ServletContext)ctx.getServletContext());
    }

    protected Context createRESTEndpoint(int port, EmbeddedCacheManager cacheManager, RestServerConfiguration configuration) {
        Context ctx = new Context((HandlerContainer)new Server(port), "/", 1);
        ctx.setInitParams(Collections.singletonMap("resteasy.resources", "org.infinispan.rest.Server"));
        ctx.addEventListener((EventListener)new ResteasyBootstrap());
        ctx.addServlet(HttpServletDispatcher.class, "/rest/*");
        ContextHandler.SContext servletContext = ctx.getServletContext();
        ServerBootstrap.setCacheManager((ServletContext)servletContext, (EmbeddedCacheManager)cacheManager);
        ServerBootstrap.setConfiguration((ServletContext)servletContext, (RestServerConfiguration)configuration);
        return ctx;
    }

    protected boolean serversStarted() {
        if (!this.servers.isEmpty()) {
            for (Context s : this.servers.values()) {
                if (s.getServer().isStarted()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void startServers() throws Exception {
        if (!this.servers.isEmpty()) {
            for (Context s : this.servers.values()) {
                EmbeddedCacheManager manager = ServerBootstrap.getCacheManager((ServletContext)s.getServletContext());
                manager.start();
                for (String cacheName : manager.getCacheNames()) {
                    manager.getCache(cacheName);
                }
                manager.getCache();
                s.getServer().start();
            }
        } else {
            throw new IllegalStateException("No servers defined!");
        }
    }

    protected void stopServers() throws Exception {
        if (!this.servers.isEmpty()) {
            for (Context s : this.servers.values()) {
                EmbeddedCacheManager manager = ServerBootstrap.getCacheManager((ServletContext)s.getServletContext());
                s.getServer().stop();
                manager.stop();
            }
        } else {
            throw new IllegalStateException("No servers defined!");
        }
    }

    protected HttpMethodBase call(HttpMethodBase method) throws Exception {
        AssertJUnit.assertTrue((boolean)this.serversStarted());
        this.client.executeMethod((HttpMethod)method);
        return method;
    }
}

