/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.rest.RESTServerTestBase;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.TwoServerTest")
public class TwoServerTest
extends RESTServerTestBase {
    private static final String PATH1 = "http://localhost:8890/rest/___defaultcache/";
    private static final String PATH2 = "http://localhost:8891/rest/___defaultcache/";

    @BeforeClass
    private void setUp() throws Exception {
        ConfigurationBuilder cfgBuilder = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        cfgBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        cfgBuilder.clustering().hash().numOwners(2);
        cfgBuilder.clustering().stateTransfer().fetchInMemoryState(true);
        cfgBuilder.clustering().stateTransfer().timeout(20000L);
        RestServerConfigurationBuilder restCfgBuilder = new RestServerConfigurationBuilder();
        this.addServer("1", 8890, TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)cfgBuilder), restCfgBuilder.build());
        this.addServer("2", 8891, TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)cfgBuilder), restCfgBuilder.build());
        this.startServers();
        TestingUtil.blockUntilViewsReceived((long)10000L, (Cache[])new Cache[]{this.getCacheManager("1").getCache("___defaultcache"), this.getCacheManager("2").getCache("___defaultcache")});
        this.createClient();
    }

    @AfterClass
    private void tearDown() throws Exception {
        this.stopServers();
        this.destroyClient();
    }

    public void testPutReplication() throws Exception {
        PutMethod put = new PutMethod("http://localhost:8890/rest/___defaultcache/a");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)put);
        Assert.assertEquals((int)put.getStatusCode(), (int)200);
        put.releaseConnection();
        GetMethod get = new GetMethod("http://localhost:8890/rest/___defaultcache/a");
        this.call((HttpMethodBase)get);
        Assert.assertEquals((int)get.getStatusCode(), (int)200);
        get.releaseConnection();
        get = new GetMethod("http://localhost:8891/rest/___defaultcache/a");
        this.call((HttpMethodBase)get);
        Assert.assertEquals((int)get.getStatusCode(), (int)200);
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        get.releaseConnection();
    }

    public void testReplace() throws Exception {
        PutMethod put = new PutMethod("http://localhost:8890/rest/___defaultcache/testReplace");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)put);
        Assert.assertEquals((int)put.getStatusCode(), (int)200);
        put.releaseConnection();
        put = new PutMethod("http://localhost:8890/rest/___defaultcache/testReplace");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "application/text", null));
        this.call((HttpMethodBase)put);
        Assert.assertEquals((int)put.getStatusCode(), (int)200);
        put.releaseConnection();
        GetMethod get = new GetMethod("http://localhost:8891/rest/___defaultcache/testReplace");
        this.call((HttpMethodBase)get);
        Assert.assertEquals((int)get.getStatusCode(), (int)200);
        Assert.assertEquals((String)"data2", (String)get.getResponseBodyAsString());
        get.releaseConnection();
    }

    public void testExtendedHeaders() throws Exception {
        PutMethod put = new PutMethod("http://localhost:8890/rest/___defaultcache/testExtendedHeaders");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)put);
        Assert.assertEquals((int)put.getStatusCode(), (int)200);
        put.releaseConnection();
        GetMethod get = new GetMethod("http://localhost:8891/rest/___defaultcache/testExtendedHeaders?extended");
        this.call((HttpMethodBase)get);
        Assert.assertEquals((int)get.getStatusCode(), (int)200);
        Header po = get.getResponseHeader("Cluster-Primary-Owner");
        Assert.assertNotNull((Object)po);
        Address primaryLocation = this.getCacheManager("1").getCache("___defaultcache").getAdvancedCache().getDistributionManager().getPrimaryLocation((Object)"testExtendedHeaders");
        Assert.assertEquals((String)primaryLocation.toString(), (String)po.getValue());
        Header sa = get.getResponseHeader("Cluster-Server-Address");
        Assert.assertNotNull((Object)sa);
        JGroupsTransport transport = (JGroupsTransport)this.getCacheManager("2").getTransport();
        Assert.assertEquals((String)transport.getPhysicalAddresses().toString(), (String)sa.getValue());
        Header nn = get.getResponseHeader("Cluster-Node-Name");
        Assert.assertNotNull((Object)nn);
        Assert.assertEquals((String)transport.getAddress().toString(), (String)nn.getValue());
        get.releaseConnection();
    }
}

