/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Collections;
import java.util.EventListener;
import javax.servlet.ServletContext;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.ServerBootstrap;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;

public class EmbeddedRestServer {
    Context context;
    final EmbeddedCacheManager cacheManager;
    final String host;
    final int port;

    public EmbeddedRestServer(String host, int port, EmbeddedCacheManager cacheManager, RestServerConfiguration configuration) {
        this.host = host;
        this.port = port;
        this.cacheManager = cacheManager;
        this.init(configuration);
    }

    public EmbeddedRestServer(int port, EmbeddedCacheManager cacheManager, RestServerConfiguration configuration) {
        this("localhost", port, cacheManager, configuration);
    }

    private void init(RestServerConfiguration configuration) {
        Server server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setHost(this.host);
        connector.setPort(this.port);
        server.addConnector((Connector)connector);
        this.context = new Context((HandlerContainer)server, "/", 1);
        this.context.setInitParams(Collections.singletonMap("resteasy.resources", "org.infinispan.rest.Server"));
        this.context.addEventListener((EventListener)new ResteasyBootstrap());
        this.context.addServlet(HttpServletDispatcher.class, "/rest/*");
        ContextHandler.SContext servletContext = this.context.getServletContext();
        ServerBootstrap.setCacheManager((ServletContext)servletContext, (EmbeddedCacheManager)this.cacheManager);
        ServerBootstrap.setConfiguration((ServletContext)servletContext, (RestServerConfiguration)configuration);
    }

    public void start() throws Exception {
        this.cacheManager.start();
        for (String cacheName : this.cacheManager.getCacheNames()) {
            this.cacheManager.getCache(cacheName);
        }
        this.cacheManager.getCache();
        this.context.getServer().start();
    }

    public void stop() throws Exception {
        this.context.getServer().stop();
        this.cacheManager.stop();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

