/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.ManagerInstance;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.rest.logging.JavaLog;
import org.infinispan.util.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServerBootstrap
implements ServletContextListener {
    private static final String INFINISPAN_CONFIG = "infinispan.config";
    private static final String EXTENDED_HEADERS = "extended.headers";
    private static final JavaLog log = (JavaLog)LogFactory.getLog(ServerBootstrap.class, JavaLog.class);
    public static final String CACHE_MANAGER = "org.infinispan.rest.ServerBootstrap.CACHE_MANAGER";
    public static final String CONFIGURATION = "org.infinispan.rest.ServerBootstrap.CONFIGURATION";
    public static final String MANAGER_INSTANCE = "org.infinispan.rest.ServerBootstrap.MANAGER_INSTANCE";

    public static void setCacheManager(ServletContext ctx, EmbeddedCacheManager cacheManager) {
        ctx.setAttribute("org.infinispan.rest.ServerBootstrap.CACHE_MANAGER", (Object)cacheManager);
        ctx.setAttribute("org.infinispan.rest.ServerBootstrap.MANAGER_INSTANCE", (Object)new ManagerInstance(cacheManager));
    }

    public static EmbeddedCacheManager getCacheManager(ServletContext ctx) {
        return (EmbeddedCacheManager)ctx.getAttribute("org.infinispan.rest.ServerBootstrap.CACHE_MANAGER");
    }

    public static RestServerConfiguration getConfiguration(ServletContext ctx) {
        return (RestServerConfiguration)ctx.getAttribute("org.infinispan.rest.ServerBootstrap.CONFIGURATION");
    }

    public static void setConfiguration(ServletContext ctx, RestServerConfiguration cfg) {
        ctx.setAttribute("org.infinispan.rest.ServerBootstrap.CONFIGURATION", (Object)cfg);
    }

    public static ManagerInstance getManagerInstance(ServletContext ctx) {
        return (ManagerInstance)ctx.getAttribute("org.infinispan.rest.ServerBootstrap.MANAGER_INSTANCE");
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        EmbeddedCacheManager cm = ServerBootstrap.getCacheManager((ServletContext)ctx);
        if (cm == null) {
            cm = this.createCacheManager(ctx);
        }
        if (ServerBootstrap.getConfiguration((ServletContext)ctx) == null) {
            this.createConfiguration(ctx);
        }
        for (String cacheName : cm.getCacheNames()) {
            cm.getCache(cacheName);
        }
        cm.getCache();
    }

    private void createConfiguration(ServletContext ctx) {
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        String extendedHeaders = ctx.getInitParameter("extended.headers");
        if (extendedHeaders != null) {
            builder.extendedHeaders(ExtendedHeaders.valueOf((String)extendedHeaders));
        }
        ServerBootstrap.setConfiguration((ServletContext)ctx, (RestServerConfiguration)builder.build());
    }

    private EmbeddedCacheManager createCacheManager(ServletContext ctx) {
        DefaultCacheManager cm;
        String cfgFile = ctx.getInitParameter("infinispan.config");
        if (cfgFile == null) {
            cm = new DefaultCacheManager();
        } else {
            try {
                cm = new DefaultCacheManager(cfgFile);
            }
            catch (IOException e) {
                log.errorReadingConfigurationFile((Throwable)e, cfgFile);
                cm = new DefaultCacheManager();
            }
        }
        ServerBootstrap.setCacheManager((ServletContext)ctx, (EmbeddedCacheManager)cm);
        return cm;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        EmbeddedCacheManager cm = ServerBootstrap.getCacheManager((ServletContext)sce.getServletContext());
        if (cm != null) {
            cm.stop();
        }
    }

    private Class<?> loadClass(String name) throws Exception {
        return Thread.currentThread().getContextClassLoader().loadClass(name);
    }
}

