/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.CacheControl;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.EmbeddedRestServer;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.rest.RestServerTestBase;
import org.infinispan.rest.RestTestingUtil;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

@Test(groups={"functional"}, testName="rest.IntegrationTest")
@ScalaSignature(bytes="\u0006\u0001\r\u001dh\u0001B\u0001\u0003\u0001%\u0011q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA]3ti*\u0011QAB\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\r\u001b\u0005\u0011\u0011BA\u0007\u0003\u0005I\u0011Vm\u001d;TKJ4XM\u001d+fgR\u0014\u0015m]3\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002CA\u0006\u0001\u0011!\u0019\u0002\u0001#b\u0001\n\u0013!\u0012a\u00017pOV\tQ\u0003\u0005\u0002\u0017;5\tqC\u0003\u0002\u00193\u00059An\\4hS:<'B\u0001\u000e\u001c\u0003\u0011\u0019wN]3\u000b\u0005q!\u0011AB:feZ,'/\u0003\u0002\u001f/\t9!*\u0019<b\u0019><\u0007\u0002\u0003\u0011\u0001\u0011\u0003\u0005\u000b\u0015B\u000b\u0002\t1|w\r\t\u0005\bE\u0001\u0011\r\u0011\"\u0001$\u0003\u0011Auj\u0015+\u0016\u0003\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004TiJLgn\u001a\u0005\u0007[\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u000b!{5\u000b\u0016\u0011\t\u000f=\u0002!\u0019!C\u0001G\u0005I1-Y2iK:\u000bW.\u001a\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u0015\r\f7\r[3OC6,\u0007\u0005C\u00044\u0001\t\u0007I\u0011A\u0012\u0002\u0011\u0019,H\u000e\u001c)bi\"Da!\u000e\u0001!\u0002\u0013!\u0013!\u00034vY2\u0004\u0016\r\u001e5!\u0011\u001d9\u0004A1A\u0005\u0002\r\nA\u0003R!U\u000b~\u0003\u0016\t\u0016+F%:{&KR\"2cI\u001a\u0004BB\u001d\u0001A\u0003%A%A\u000bE\u0003R+u\fU!U)\u0016\u0013fj\u0018*G\u0007F\n$g\r\u0011\t\u000fm\u0002\u0001\u0019!C\u0005y\u0005a1-Y2iK6\u000bg.Y4feV\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002A\t\u00059Q.\u00198bO\u0016\u0014\u0018B\u0001\"@\u0005Q)UNY3eI\u0016$7)Y2iK6\u000bg.Y4fe\"9A\t\u0001a\u0001\n\u0013)\u0015\u0001E2bG\",W*\u00198bO\u0016\u0014x\fJ3r)\t1E\n\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0003V]&$\bbB'D\u0003\u0003\u0005\r!P\u0001\u0004q\u0012\n\u0004BB(\u0001A\u0003&Q(A\u0007dC\u000eDW-T1oC\u001e,'\u000f\t\u0005\u0006#\u0002!IAU\u0001\u0011MVdG\u000eU1uQ^KG\u000f\u001b)peR$2aU-b!\t!vK\u0004\u0002H+&\u0011a\u000bS\u0001\u0007!J,G-\u001a4\n\u0005-B&B\u0001,I\u0011\u0015Q\u0006\u000b1\u0001\\\u0003\u0005i\u0007C\u0001/`\u001b\u0005i&B\u00010'\u0003\u001d\u0011XM\u001a7fGRL!\u0001Y/\u0003\r5+G\u000f[8e\u0011\u0015\u0011\u0007\u000b1\u0001d\u0003\u0011\u0001xN\u001d;\u0011\u0005\u001d#\u0017BA3I\u0005\rIe\u000e\u001e\u0005\u0006O\u0002!\t\u0001[\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\r\"\"aM\u001b:t!\tY\u0007/D\u0001m\u0015\tig.A\u0006b]:|G/\u0019;j_:\u001c(BA8\u0007\u0003\u0019!Xm\u001d;oO&\u0011\u0011\u000f\u001c\u0002\f\u0005\u00164wN]3DY\u0006\u001c8/A\u0005bY^\f\u0017p\u001d*v]f\t\u0011\u0001C\u0003v\u0001\u0011\u0005a/\u0001\nde\u0016\fG/Z\"bG\",W*\u00198bO\u0016\u0014H#A\u001f\t\u000ba\u0004A\u0011\u00015\u0002\u0011Q,\u0017M\u001d#po:DCa\u001e>sgB\u00111n_\u0005\u0003y2\u0014!\"\u00114uKJ\u001cE.Y:t\u0011\u0015q\b\u0001\"\u0001\u0000\u0003I!Xm\u001d;CCNL7m\u00149fe\u0006$\u0018n\u001c8\u0015\u0007\u0019\u000b\t\u0001C\u0003[{\u0002\u00071\f\u0003\u0004\u0002\u0006\u0001!\t\u0001[\u0001\ri\u0016\u001cH/R7qif<U\r\u001e\u0005\u0007\u0003\u0013\u0001A\u0011\u00015\u0002+Q,7\u000f\u001e#fY\u0016$XMT8o\u000bbL7\u000f^3oi\"1\u0011Q\u0002\u0001\u0005\u0002!\f\u0011\u0003^3ti\u001e+GoQ8mY\u0016\u001cG/[8o\u0011\u0019\t\t\u0002\u0001C\u0001Q\u00069B/Z:u\u000f\u0016$8i\u001c7mK\u000e$\u0018n\u001c8Fg\u000e\f\u0007/\u001a\u0005\b\u0003+\u0001A\u0011BA\f\u000359W\r^\"pY2,7\r^5p]R\u00191+!\u0007\t\u000f\u0005m\u00111\u0003a\u0001'\u00069a/\u0019:jC:$\bbBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\bi\u0016\u001cHoR3u)\r1\u00151\u0005\u0005\u00075\u0006u\u0001\u0019A.\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005AA/Z:u\u0011\u0016\fG\rF\u0002G\u0003WAaAWA\u0013\u0001\u0004Y\u0006bBA\u0018\u0001\u0011\u0005\u0011\u0011G\u0001\u0014i\u0016\u001cHoR3u\u0013\u001a,f.\\8eS\u001aLW\r\u001a\u000b\u0004\r\u0006M\u0002B\u0002.\u0002.\u0001\u00071\fC\u0004\u00028\u0001!\t!!\u000f\u0002#Q,7\u000f\u001e)pgR$U\u000f\u001d7jG\u0006$X\rF\u0002G\u0003wAaAWA\u001b\u0001\u0004Y\u0006bBA \u0001\u0011\u0005\u0011\u0011I\u0001\u001ai\u0016\u001cH\u000fU;u\t\u0006$\u0018mV5uQRKW.\u001a+p\u0019&4X\rF\u0002G\u0003\u0007BaAWA\u001f\u0001\u0004Y\u0006bBA$\u0001\u0011\u0005\u0011\u0011J\u0001\u001bi\u0016\u001cH\u000fU;u\t\u0006$\u0018mV5uQ6\u000b\u00070\u00133mK>sG.\u001f\u000b\u0004\r\u0006-\u0003B\u0002.\u0002F\u0001\u00071\fC\u0004\u0002P\u0001!\t!!\u0015\u0002;Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"$\u0016.\\3U_2Kg/Z(oYf$2ARA*\u0011\u0019Q\u0016Q\na\u00017\"9\u0011q\u000b\u0001\u0005\n\u0005e\u0013!\u00079vi\u0006sG-Q:tKJ$X\t\u001d5f[\u0016\u0014\u0018\r\u001c#bi\u0006$rARA.\u0003;\n\t\u0007\u0003\u0004[\u0003+\u0002\ra\u0017\u0005\b\u0003?\n)\u00061\u0001T\u0003E!\u0018.\\3U_2Kg/Z*fG>tGm\u001d\u0005\b\u0003G\n)\u00061\u0001T\u0003Ii\u0017\r_%eY\u0016$\u0016.\\3TK\u000e|g\u000eZ:\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\u00051B/Z:u!V$H)\u0019;b/&$\b.\u00134NCR\u001c\u0007\u000eF\u0002G\u0003WBaAWA3\u0001\u0004Y\u0006bBA8\u0001\u0011\u0005\u0011\u0011O\u0001\u001bi\u0016\u001cH\u000fU;u\t\u0006$\u0018mV5uQ&3gj\u001c8f\u001b\u0006$8\r\u001b\u000b\u0004\r\u0006M\u0004B\u0002.\u0002n\u0001\u00071\fC\u0004\u0002x\u0001!\t!!\u001f\u0002=Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"Le-T8eS\u001aLW\rZ*j]\u000e,Gc\u0001$\u0002|!1!,!\u001eA\u0002mCq!a \u0001\t\u0003\t\t)\u0001\u0011uKN$\b+\u001e;ECR\fw+\u001b;i\u0013\u001a,f.T8eS\u001aLW\rZ*j]\u000e,Gc\u0001$\u0002\u0004\"1!,! A\u0002mCq!a\"\u0001\t\u0003\tI)A\ruKN$H)\u001a7fi\u0016$\u0015\r^1XSRD\u0017JZ'bi\u000eDGc\u0001$\u0002\f\"1!,!\"A\u0002mCq!a$\u0001\t\u0003\t\t*A\u000fuKN$H)\u001a7fi\u0016$\u0015\r^1XSRD\u0017J\u001a(p]\u0016l\u0015\r^2i)\r1\u00151\u0013\u0005\u00075\u00065\u0005\u0019A.\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u0006\tC/Z:u\t\u0016dW\r^3ECR\fw+\u001b;i\u0013\u001alu\u000eZ5gS\u0016$7+\u001b8dKR\u0019a)a'\t\ri\u000b)\n1\u0001\\\u0011\u001d\ty\n\u0001C\u0001\u0003C\u000b1\u0005^3ti\u0012+G.\u001a;f\t\u0006$\u0018mV5uQ&3WK\\7pI&4\u0017.\u001a3TS:\u001cW\rF\u0002G\u0003GCaAWAO\u0001\u0004Y\u0006bBAT\u0001\u0011\u0005\u0011\u0011V\u0001)i\u0016\u001cH\u000fR3mKR,7)Y2iKB\u0013XmY8oI&$\u0018n\u001c8V]&l\u0007\u000f\\3nK:$X\r\u001a\u000b\u0004\r\u0006-\u0006B\u0002.\u0002&\u0002\u00071\fC\u0004\u00020\u0002!I!!-\u0002KQ,7\u000f\u001e#fY\u0016$X\r\u0015:fG>tG-\u001b;j_:\fG.\u00168j[BdW-\\3oi\u0016$Gc\u0001$\u00024\"9\u0011QWAW\u0001\u0004\u0019\u0016a\u00034vY2\u0004\u0016\r\u001e5LKfDq!a,\u0001\t\u0013\tI\fF\u0003G\u0003w\u000bi\fC\u0004\u00026\u0006]\u0006\u0019A*\t\u000f\u0005}\u0016q\u0017a\u0001'\u0006A\u0002O]3d_:$\u0017\u000e^5p]\u0006d\u0007*Z1eKJt\u0015-\\3\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\u0006!\u0012m]:feRtu\u000e^%na2,W.\u001a8uK\u0012$2ARAd\u0011!\tI-!1A\u0002\u0005-\u0017AB7fi\"|G\r\u0005\u0003\u0002N\u0006mWBAAh\u0015\u0011\t\t.a5\u0002\u0015!$H\u000f]2mS\u0016tGO\u0003\u0003\u0002V\u0006]\u0017aB2p[6|gn\u001d\u0006\u0004\u000334\u0011AB1qC\u000eDW-\u0003\u0003\u0002^\u0006='A\u0003%uiBlU\r\u001e5pI\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\u0018a\u0004;fgR\u0014V-\\8wK\u0016sGO]=\u0015\u0007\u0019\u000b)\u000f\u0003\u0004[\u0003?\u0004\ra\u0017\u0005\b\u0003S\u0004A\u0011AAv\u0003M!Xm\u001d;XSB,7)Y2iK\n+8m[3u)\r1\u0015Q\u001e\u0005\u00075\u0006\u001d\b\u0019A.\t\u000f\u0005E\b\u0001\"\u0001\u0002t\u0006\u0011B/Z:u\u0003NLhnY!eIJ+Wn\u001c<f)\r1\u0015Q\u001f\u0005\u00075\u0006=\b\u0019A.\t\u000f\u0005e\b\u0001\"\u0001\u0002|\u0006qB/Z:u'\"|W\u000f\u001c3D_B,w+\u001b;i'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0004\r\u0006u\bB\u0002.\u0002x\u0002\u00071\fC\u0004\u0003\u0002\u0001!\tAa\u0001\u0002;Q,7\u000f^%og\u0016\u0014HoU3sS\u0006d\u0017N_1cY\u0016|%M[3diN$2A\u0012B\u0003\u0011\u0019Q\u0016q a\u00017\"9!\u0011\u0002\u0001\u0005\u0002\t-\u0011\u0001\u0006;fgRtuN\\3ySN$XM\u001c;DC\u000eDW\rF\u0002G\u0005\u001bAaA\u0017B\u0004\u0001\u0004Y\u0006b\u0002B\t\u0001\u0011\u0005!1C\u0001!i\u0016\u001cHOQ=uK\u0006\u0013(/Y=BgN+'/[1mSj,Gm\u00142kK\u000e$8\u000fF\u0002G\u0005+AaA\u0017B\b\u0001\u0004Y\u0006b\u0002B\r\u0001\u0011\u0005!1D\u0001\"i\u0016\u001cHOQ=uK\u0006\u0013(/Y=Bg>\u001bG/Z2TiJ,\u0017-\\(cU\u0016\u001cGo\u001d\u000b\u0004\r\nu\u0001B\u0002.\u0003\u0018\u0001\u00071\fC\u0004\u0003\"\u0001!IAa\t\u0002\u001fM,g\u000e\u001a\"zi\u0016\f%O]1z\u0003N$RA\u0012B\u0013\u0005OAaA\u0017B\u0010\u0001\u0004Y\u0006b\u0002B\u0015\u0005?\u0001\raU\u0001\fG>tG/\u001a8u)f\u0004X\rC\u0004\u0003.\u0001!\tAa\f\u0002+Q,7\u000f^%g+:lw\u000eZ5gS\u0016$7+\u001b8dKR\u0019aI!\r\t\ri\u0013Y\u00031\u0001\\\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005o\tq\u0002^3ti\u0016#\u0016mZ\"iC:<Wm\u001d\u000b\u0004\r\ne\u0002B\u0002.\u00034\u0001\u00071\fC\u0004\u0003>\u0001!\tAa\u0010\u00023Q,7\u000f^\"p]\u000e,(O]3oi\u0016#\u0016mZ\"iC:<Wm\u001d\u000b\u0004\r\n\u0005\u0003B\u0002.\u0003<\u0001\u00071\fC\u0004\u0003F\u0001!\tAa\u0012\u00029Q,7\u000f^*fe&\fG.\u001b>fIN#(/\u001b8h\u000f\u0016$()\u001f;fgR\u0019aI!\u0013\t\ri\u0013\u0019\u00051\u0001\\\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005\u001f\n\u0011\u0005^3ti\u0012+g-Y;mi\u000e{gNZ5hkJ,G-\u0012=qSJLh+\u00197vKN$2A\u0012B)\u0011\u0019Q&1\na\u00017\"9!Q\u000b\u0001\u0005\u0002\t]\u0013A\b;fgR\u001c\u0015m\u00195f\u0007>tGO]8m%\u0016\u001c\bo\u001c8tK\"+\u0017\rZ3s)\r1%\u0011\f\u0005\u00075\nM\u0003\u0019A.\t\u000f\tu\u0003\u0001\"\u0001\u0003`\u0005AC/Z:u\u000f\u0016$8)Y2iK\u000e{g\u000e\u001e:pY6KgN\u0012:fg\"\u0014V-];fgRDU-\u00193feR\u0019aI!\u0019\t\ri\u0013Y\u00061\u0001\\\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005O\n\u0011\u0006^3ti\"+\u0017\rZ\"bG\",7i\u001c8ue>dW*\u001b8Ge\u0016\u001c\bNU3rk\u0016\u001cH\u000fS3bI\u0016\u0014Hc\u0001$\u0003j!1!La\u0019A\u0002mCqA!\u001c\u0001\t\u0003\u0011y'A\u000buKN$\b+\u001e;CsR,\u0017I\u001d:bsR;\u0018nY3\u0015\u0007\u0019\u0013\t\b\u0003\u0004[\u0005W\u0002\ra\u0017\u0005\b\u0005k\u0002A\u0011\u0001B<\u0003i!Xm\u001d;EK2,G/Z*fe&\fG.\u001b>fI>\u0013'.Z2u)\r1%\u0011\u0010\u0005\u00075\nM\u0004\u0019A.\t\u000f\tu\u0004\u0001\"\u0003\u0003\u0000\u0005aq/Y5u\u001d>$hi\\;oIR9aI!!\u0003\f\n=\u0005\u0002\u0003BB\u0005w\u0002\rA!\"\u0002\u0013M$\u0018M\u001d;US6,\u0007cA$\u0003\b&\u0019!\u0011\u0012%\u0003\t1{gn\u001a\u0005\b\u0005\u001b\u0013Y\b1\u0001d\u0003!a\u0017NZ3ta\u0006t\u0007bBA[\u0005w\u0002\ra\u0015\u0005\b\u0005'\u0003A\u0011\u0002BK\u0003\r\u0001X\u000f\u001e\u000b\u0005\u0005/\u0013i\n\u0005\u0003\u0002N\ne\u0015\u0002\u0002BN\u0003\u001f\u0014a\u0002\u0013;ua6+G\u000f[8e\u0005\u0006\u001cX\r\u0003\u0004[\u0005#\u0003\ra\u0017\u0005\b\u0005'\u0003A\u0011\u0002BQ)\u0019\u00119Ja)\u0003&\"1!La(A\u0002mC\u0001Ba*\u0003 \u0002\u0007!\u0011V\u0001\u0005I\u0006$\u0018\rE\u0002H\u0005WK1A!,I\u0005\r\te.\u001f\u0005\b\u0005'\u0003A\u0011\u0002BY)!\u00119Ja-\u00038\ne\u0006b\u0002B[\u0005_\u0003\raU\u0001\u0005a\u0006$\b\u000e\u0003\u0005\u0003(\n=\u0006\u0019\u0001BU\u0011\u001d\u0011ICa,A\u0002MCqA!0\u0001\t\u0013\u0011y,A\u0002hKR$BAa&\u0003B\"1!La/A\u0002mCqA!0\u0001\t\u0013\u0011)\r\u0006\u0004\u0003\u0018\n\u001d'\u0011\u001a\u0005\u00075\n\r\u0007\u0019A.\t\u0011\t-'1\u0019a\u0001\u0005\u001b\f!\"\u001e8n_\u0012\u001c\u0016N\\2f!\u00119%qZ*\n\u0007\tE\u0007J\u0001\u0004PaRLwN\u001c\u0005\b\u0005{\u0003A\u0011\u0002Bk)!\u00119Ja6\u0003Z\nm\u0007B\u0002.\u0003T\u0002\u00071\f\u0003\u0005\u0003L\nM\u0007\u0019\u0001Bg\u0011!\u0011iNa5A\u0002\t5\u0017AC1dG\u0016\u0004H\u000fV=qK\"9!Q\u0018\u0001\u0005\n\t\u0005HC\u0003BL\u0005G\u0014)Oa:\u0003j\"1!La8A\u0002mC\u0001Ba3\u0003`\u0002\u0007!Q\u001a\u0005\t\u0005;\u0014y\u000e1\u0001\u0003N\"9!1\u001eBp\u0001\u0004\u0019\u0017aB3ya\u000e{G-\u001a\u0005\b\u0003k\u0003A\u0011\u0002Bx)\r\u0019&\u0011\u001f\u0005\u00075\n5\b\u0019A.\t\u000f\u0005U\u0006\u0001\"\u0003\u0003vR)1Ka>\u0003z\"1!La=A\u0002mCaA\u0019Bz\u0001\u0004\u0019\u0007b\u0002B\u007f\u0001\u0011\u0005!q`\u0001\u0007C\u0012$G)Y=\u0015\u000bM\u001b\ta!\u0002\t\u000f\r\r!1 a\u0001'\u0006)\u0011\rR1uK\"91q\u0001B~\u0001\u0004\u0019\u0017\u0001\u00023bsN4aaa\u0003\u0001\u0001\r5!AF\"p]R\u0014x\u000e\u001c7fI\u000e\u000b7\r[3NC:\fw-\u001a:\u0014\t\r%1q\u0002\t\u0005\u0007#\u00199\"\u0004\u0002\u0004\u0014)\u00191QC \u0002\t%l\u0007\u000f\\\u0005\u0005\u00073\u0019\u0019B\u0001\u0014BEN$(/Y2u\t\u0016dWmZ1uS:<W)\u001c2fI\u0012,GmQ1dQ\u0016l\u0015M\\1hKJD!b!\b\u0004\n\t\u0005\t\u0015!\u0003>\u0003\t\u0019W\u000eC\u0006\u0004\"\r%!\u0011!Q\u0001\n\r\r\u0012A\u0003<3!V$H*\u0019;dQB!1QEB\u0018\u001b\t\u00199C\u0003\u0003\u0004*\r-\u0012AC2p]\u000e,(O]3oi*\u00191Q\u0006\u0015\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007c\u00199C\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\t\u0017\rU2\u0011\u0002B\u0001B\u0003%11E\u0001\u000bmN\u0002V\u000f\u001e'bi\u000eD\u0007bCB\u001d\u0007\u0013\u0011\t\u0011)A\u0005\u0007G\tQB\u001e\u001aGS:L7\u000f\u001b'bi\u000eD\u0007bB\b\u0004\n\u0011\u00051Q\b\u000b\u000b\u0007\u007f\u0019\u0019e!\u0012\u0004H\r%\u0003\u0003BB!\u0007\u0013i\u0011\u0001\u0001\u0005\b\u0007;\u0019Y\u00041\u0001>\u0011!\u0019\tca\u000fA\u0002\r\r\u0002\u0002CB\u001b\u0007w\u0001\raa\t\t\u0011\re21\ba\u0001\u0007GA\u0001b!\u0014\u0004\n\u0011\u00053qJ\u0001\tO\u0016$8)Y2iKV11\u0011KB0\u0007[\"\"aa\u0015\u0011\u0011\rU3qKB.\u0007Wj\u0011\u0001B\u0005\u0004\u00073\"!!D!em\u0006t7-\u001a3DC\u000eDW\r\u0005\u0003\u0004^\r}C\u0002\u0001\u0003\t\u0007C\u001aYE1\u0001\u0004d\t\t1*\u0005\u0003\u0004f\t%\u0006cA$\u0004h%\u00191\u0011\u000e%\u0003\u000f9{G\u000f[5oOB!1QLB7\t!\u0019yga\u0013C\u0002\r\r$!\u0001,\u0007\r\rM\u0004\u0001AB;\u0005=\u0019uN\u001c;s_2dW\rZ\"bG\",WCBB<\u0007\u0013\u001bii\u0005\u0003\u0004r\re\u0004\u0003CB>\u0007\u0007\u001b9ia#\u000e\u0005\ru$\u0002BB\u000b\u0007\u007fR1a!!\u0005\u0003\u0015\u0019\u0017m\u00195f\u0013\u0011\u0019)i! \u0003?\u0005\u00137\u000f\u001e:bGR$U\r\\3hCRLgnZ!em\u0006t7-\u001a3DC\u000eDW\r\u0005\u0003\u0004^\r%EaB\u0016\u0004r\t\u000711\r\t\u0005\u0007;\u001ai\t\u0002\u0005\u0003.\u000eE$\u0019AB2\u0011-\u0019\ti!\u001d\u0003\u0002\u0003\u0006Ia!%\u0011\u0011\rU31SBD\u0007\u0017K1a!&\u0005\u0005\u0015\u0019\u0015m\u00195f\u0011-\u0019\tc!\u001d\u0003\u0002\u0003\u0006Iaa\t\t\u0017\rU2\u0011\u000fB\u0001B\u0003%11\u0005\u0005\f\u0007s\u0019\tH!A!\u0002\u0013\u0019\u0019\u0003C\u0004\u0010\u0007c\"\taa(\u0015\u0015\r\u000561UBS\u0007O\u001bI\u000b\u0005\u0005\u0004B\rE4qQBF\u0011!\u0019\ti!(A\u0002\rE\u0005\u0002CB\u0011\u0007;\u0003\raa\t\t\u0011\rU2Q\u0014a\u0001\u0007GA\u0001b!\u000f\u0004\u001e\u0002\u000711\u0005\u0005\t\u0007[\u001b\t\b\"\u0011\u00040\u00069!/\u001a9mC\u000e,GCCBY\u0007o\u001bYla0\u0004DB\u0019qia-\n\u0007\rU\u0006JA\u0004C_>dW-\u00198\t\u0011\re61\u0016a\u0001\u0007\u000f\u000b1a[3z\u0011!\u0019ila+A\u0002\r-\u0015\u0001C8mIZ\u000bG.^3\t\u0011\r\u000571\u0016a\u0001\u0007\u0017\u000bQA^1mk\u0016D\u0001b!2\u0004,\u0002\u00071qY\u0001\t[\u0016$\u0018\rZ1uCB!1\u0011ZBg\u001b\t\u0019YMC\u0002\u0004F\u0012IAaa4\u0004L\nAQ*\u001a;bI\u0006$\u0018\rK\u0006\u0001\u0007'\u001cIna7\u0004b\u000e\r\bcA6\u0004V&\u00191q\u001b7\u0003\tQ+7\u000f^\u0001\u0007OJ|W\u000f]:-\u0005\ru\u0017EABp\u0003)1WO\\2uS>t\u0017\r\\\u0001\ti\u0016\u001cHOT1nK\u0006\u00121Q]\u0001\u0015e\u0016\u001cHOL%oi\u0016<'/\u0019;j_:$Vm\u001d;")
public class IntegrationTest
extends RestServerTestBase {
    private JavaLog org$infinispan$rest$IntegrationTest$$log;
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).toString();
    private final String DATE_PATTERN_RFC1123;
    private EmbeddedCacheManager cacheManager = null;
    private volatile boolean bitmap$0;

    private JavaLog org$infinispan$rest$IntegrationTest$$log$lzycompute() {
        IntegrationTest integrationTest = this;
        synchronized (integrationTest) {
            if (!this.bitmap$0) {
                this.org$infinispan$rest$IntegrationTest$$log = (JavaLog)LogFactory.getLog(this.getClass(), JavaLog.class);
                this.bitmap$0 = true;
            }
            return this.org$infinispan$rest$IntegrationTest$$log;
        }
    }

    public JavaLog org$infinispan$rest$IntegrationTest$$log() {
        return this.bitmap$0 ? this.org$infinispan$rest$IntegrationTest$$log : this.org$infinispan$rest$IntegrationTest$$log$lzycompute();
    }

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String DATE_PATTERN_RFC1123() {
        return this.DATE_PATTERN_RFC1123;
    }

    private EmbeddedCacheManager cacheManager() {
        return this.cacheManager;
    }

    private void cacheManager_$eq(EmbeddedCacheManager x$1) {
        this.cacheManager = x$1;
    }

    public String org$infinispan$rest$IntegrationTest$$fullPathWithPort(Method m, int port) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://localhost:", "/rest/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port), this.cacheName(), m.getName()}));
    }

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        this.cacheManager_$eq(TestCacheManagerFactory.fromXml((String)"test-config.xml"));
        this.addServer("single", 8888, this.cacheManager());
        this.startServers();
        this.createClient();
    }

    public EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.fromXml((String)"test-config.xml");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.destroyClient();
        this.stopServers();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager()});
    }

    public void testBasicOperation(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        insert.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(initialXML.toString().getBytes(), "application/octet-stream"));
        this.call((HttpMethodBase)insert);
        AssertJUnit.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        AssertJUnit.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        AssertJUnit.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        this.call((HttpMethodBase)remove);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        this.call((HttpMethodBase)insert);
        this.call((HttpMethodBase)get);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)removeAll).getStatusCode());
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byteData, "application/octet-stream"));
        this.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        AssertJUnit.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        AssertJUnit.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testDeleteNonExistent() {
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGetCollection() {
        PostMethod post_a = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/a"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_a.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_a);
        PostMethod post_b = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/b"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_b.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_b);
        String html = this.getCollection("text/html");
        AssertJUnit.assertTrue((boolean)html.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "/a\">a</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cacheName()}))));
        AssertJUnit.assertTrue((boolean)html.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "/b\">b</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cacheName()}))));
        String xml = this.getCollection("application/xml");
        AssertJUnit.assertTrue((boolean)xml.contains("<key>a</key>"));
        AssertJUnit.assertTrue((boolean)xml.contains("<key>b</key>"));
        String plain = this.getCollection("text/plain;charset=UTF-8");
        AssertJUnit.assertTrue((boolean)plain.contains("a\n"));
        AssertJUnit.assertTrue((boolean)plain.contains("b\n"));
        String json = this.getCollection("application/json");
        AssertJUnit.assertTrue((boolean)json.contains("\"a\""));
        AssertJUnit.assertTrue((boolean)json.contains("\"b\""));
    }

    public void testGetCollectionEscape() {
        PostMethod post_a = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/%22a%22"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_a.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_a);
        PostMethod post_b = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/b%3E"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_b.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_b);
        String html = this.getCollection("text/html");
        AssertJUnit.assertTrue((boolean)html.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "/&quot;a&quot;\">&quot;a&quot;</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cacheName()}))));
        AssertJUnit.assertTrue((boolean)html.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "/b&gt;\">b&gt;</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cacheName()}))));
        String xml = this.getCollection("application/xml");
        AssertJUnit.assertTrue((boolean)xml.contains("<key>&quot;a&quot;</key>"));
        AssertJUnit.assertTrue((boolean)xml.contains("<key>b&gt;</key>"));
        String plain = this.getCollection("text/plain;charset=UTF-8");
        AssertJUnit.assertTrue((boolean)plain.contains("\"a\"\n"));
        AssertJUnit.assertTrue((boolean)plain.contains("b>\n"));
        String json = this.getCollection("application/json");
        AssertJUnit.assertTrue((boolean)json.contains("\\\"a\\\""));
        AssertJUnit.assertTrue((boolean)json.contains("\"b>\""));
    }

    private String getCollection(String variant) {
        GetMethod get = new GetMethod(this.fullPath());
        get.addRequestHeader("Accept", variant);
        HttpMethodBase coll = this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)coll.getStatusCode());
        AssertJUnit.assertEquals((String)variant, (String)coll.getResponseHeader("Content-Type").getValue());
        return coll.getResponseBodyAsString();
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        AssertJUnit.assertNotNull((Object)lastMod);
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = this.call((HttpMethodBase)getAgain);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)post);
        AssertJUnit.assertEquals((int)409, (int)this.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, new StringOps(Predef$.MODULE$.augmentString(timeToLiveSeconds)).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, new StringOps(Predef$.MODULE$.augmentString(maxIdleTimeSeconds)).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        this.call(get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPutDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Match", etag);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Match", "x");
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-None-Match", "x");
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-None-Match", etag);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Modified-Since", lastMod);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)304, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reputAgain.setRequestHeader("If-Modified-Since", dateMinus);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfUnModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reput.setRequestHeader("If-Unmodified-Since", dateMinus);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testDeleteDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Match", "x");
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Match", etag);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-None-Match", etag);
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-None-Match", "x");
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Modified-Since", lastMod);
        AssertJUnit.assertEquals((int)304, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        deleteAgain.setRequestHeader("If-Modified-Since", dateMinus);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfUnmodifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        delete.setRequestHeader("If-Unmodified-Since", dateMinus);
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteCachePreconditionUnimplemented(Method m) {
        this.testDeletePreconditionalUnimplemented(this.fullPath());
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey) {
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-None-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Modified-Since");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Unmodified-Since");
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey, String preconditionalHeaderName) {
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader(preconditionalHeaderName, "*");
        this.call((HttpMethodBase)delete);
        this.assertNotImplemented((HttpMethod)delete);
    }

    private void assertNotImplemented(HttpMethod method) {
        AssertJUnit.assertEquals((int)method.getStatusCode(), (int)501);
        AssertJUnit.assertEquals((String)method.getStatusText(), (String)"Not Implemented");
        Predef$.MODULE$.assert(method.getResponseBodyAsString().toLowerCase().contains("precondition"));
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        this.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put_);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        this.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("performAsync", "true");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        this.call((HttpMethodBase)del);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        this.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        this.getCacheManager("single").getCache("___defaultcache").put((Object)m.getName(), (Object)obj);
        this.getCacheManager("single").getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), (Object)"hola");
        this.getCacheManager("single").getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), (Object)new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        AssertJUnit.assertNotNull((Object)res);
        AssertJUnit.assertEquals((String)"mic", (String)res.name());
        AssertJUnit.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = this.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        AssertJUnit.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        this.call((HttpMethodBase)get3);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(this.fullPathKey(m), bout.toByteArray(), "application/x-java-serialized-object");
        byte[] cfr_ignored_0 = (byte[])this.getCacheManager("single").getCache("___defaultcache").get((Object)m.getName());
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = this.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), ClassTag$.MODULE$.Byte());
        this.put(this.fullPathKey(m), serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        AssertJUnit.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)dateLast)).getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)datePlus)).getResponseBodyAsString());
        HttpMethodBase httpMethodBase = this.get(m, (Option<String>)new Some((Object)dateMinus), (Option<String>)None$.MODULE$, 412);
    }

    public void testETagChanges(Method m) {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertFalse((String)new StringOps(Predef$.MODULE$.augmentString("etag1 %s; etag2 %s; equals? %b")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eTagFirst, eTagSecond, BoxesRunTime.boxToBoolean((boolean)eTagFirst.equals(eTagSecond))})), (boolean)eTagFirst.equals(eTagSecond));
    }

    /*
     * WARNING - void declaration
     */
    public void testConcurrentETagChanges(Method m) {
        CountDownLatch v2PutLatch = new CountDownLatch(1);
        CountDownLatch v3PutLatch = new CountDownLatch(1);
        CountDownLatch v2FinishLatch = new CountDownLatch(1);
        EmbeddedCacheManager cacheManager = this.createCacheManager();
        ControlledCacheManager mockCacheManager = new ControlledCacheManager(this, cacheManager, v2PutLatch, v3PutLatch, v2FinishLatch);
        EmbeddedRestServer server = RestTestingUtil.startRestServer((EmbeddedCacheManager)mockCacheManager);
        this.put(this.org$infinispan$rest$IntegrationTest$$fullPathWithPort(m, server.getPort()), "data1", "application/text");
        try {
            Future replaceFuture = Future$.MODULE$.apply((Function0)new Serializable(this, m, v2FinishLatch, server){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IntegrationTest $outer;
                private final Method m$1;
                private final CountDownLatch v2FinishLatch$1;
                private final EmbeddedRestServer server$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    HttpClient newClient = new HttpClient();
                    PutMethod put = new PutMethod(this.$outer.org$infinispan$rest$IntegrationTest$$fullPathWithPort(this.m$1, this.server$1.getPort()));
                    put.setRequestHeader("Content-Type", "application/text");
                    put.setRequestEntity((RequestEntity)new StringRequestEntity("data2", null, null));
                    newClient.executeMethod((HttpMethod)put);
                    AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
                    this.v2FinishLatch$1.countDown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                    this.v2FinishLatch$1 = v2FinishLatch$1;
                    this.server$1 = server$1;
                }
            }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            boolean bl = v3PutLatch.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertTrue((String)"Timed out waiting for concurrent put", (boolean)bl);
            PutMethod put = new PutMethod(this.org$infinispan$rest$IntegrationTest$$fullPathWithPort(m, server.getPort()));
            put.setRequestHeader("Content-Type", "application/text");
            put.setRequestEntity((RequestEntity)new StringRequestEntity("data3", null, null));
            this.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)412, (int)put.getStatusCode());
            Await$.MODULE$.result((Awaitable)replaceFuture, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds());
            AssertJUnit.assertEquals((String)"data2", (String)this.get(m).getResponseBodyAsString());
        }
        catch (Throwable throwable) {
            void var5_5;
            void var7_7;
            var7_7.stop();
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{var5_5});
            throw throwable;
        }
        server.stop();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }

    public void testSerializedStringGetBytes(Method m) {
        byte[] data = new StringBuilder().append((Object)"v-").append((Object)m.getName()).toString().getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(this.fullPathKey(m), bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"application/x-java-serialized-object")).getResponseBody();
        AssertJUnit.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        AssertJUnit.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    public void testDefaultConfiguredExpiryValues(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "-1");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(5000L);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        AssertJUnit.assertNull((Object)get.getResponseHeader("Expires"));
        long startTime = System.currentTimeMillis();
        int lifespan = 3000;
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-2")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        while (System.currentTimeMillis() < startTime + (long)lifespan) {
            get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
            String response = get.getResponseBodyAsString();
            if (System.currentTimeMillis() >= startTime + (long)lifespan) continue;
            AssertJUnit.assertEquals((String)"data2", (String)response);
            AssertJUnit.assertNotNull((Object)get.getResponseHeader("Expires"));
            Thread.sleep(100L);
        }
        this.waitNotFound(startTime, lifespan, fullPathKey);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        startTime = System.currentTimeMillis();
        lifespan = 0;
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-3")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data3", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(1000L);
        get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        String response = get.getResponseBodyAsString();
        AssertJUnit.assertEquals((String)"data3", (String)response);
        Thread.sleep(2000L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-4")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data4", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2500L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
    }

    public void testCacheControlResponseHeader(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Cache-Control"));
        int retrievedMaxAge = CacheControl.valueOf((String)get.getResponseHeader("Cache-Control").getValue()).getMaxAge();
        AssertJUnit.assertTrue((retrievedMaxAge > 0 ? 1 : 0) != 0);
    }

    public void testGetCacheControlMinFreshRequestHeader(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        GetMethod getLongMinFresh = new GetMethod(fullPathKey);
        getLongMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=20");
        HttpMethodBase getResp = this.call((HttpMethodBase)getLongMinFresh);
        AssertJUnit.assertEquals((int)404, (int)getResp.getStatusCode());
        GetMethod getShortMinFresh = new GetMethod(fullPathKey);
        getShortMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=2");
        getResp = this.call((HttpMethodBase)getShortMinFresh);
        AssertJUnit.assertNotNull((Object)getResp.getResponseHeader("Cache-Control"));
        AssertJUnit.assertEquals((String)"data", (String)getResp.getResponseBodyAsString());
        GetMethod getNoMinFresh = new GetMethod(fullPathKey);
        getResp = this.call((HttpMethodBase)getNoMinFresh);
        AssertJUnit.assertNotNull((Object)getResp.getResponseHeader("Cache-Control"));
        AssertJUnit.assertEquals((String)"data", (String)getResp.getResponseBodyAsString());
    }

    public void testHeadCacheControlMinFreshRequestHeader(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        HeadMethod headLongMinFresh = new HeadMethod(fullPathKey);
        headLongMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=20");
        HttpMethodBase headResp = this.call((HttpMethodBase)headLongMinFresh);
        AssertJUnit.assertEquals((int)404, (int)headResp.getStatusCode());
        HeadMethod headShortMinFresh = new HeadMethod(fullPathKey);
        headShortMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=2");
        headResp = this.call((HttpMethodBase)headShortMinFresh);
        int retrievedMaxAge = CacheControl.valueOf((String)headResp.getResponseHeader("Cache-Control").getValue()).getMaxAge();
        AssertJUnit.assertTrue((retrievedMaxAge > 0 ? 1 : 0) != 0);
        HeadMethod headNoMinFresh = new HeadMethod(fullPathKey);
        headResp = this.call((HttpMethodBase)headNoMinFresh);
        AssertJUnit.assertNotNull((Object)headResp.getResponseHeader("Cache-Control"));
    }

    public void testPutByteArrayTwice(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{42, 42, 42}), ClassTag$.MODULE$.Byte());
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
    }

    public void testDeleteSerializedObject(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{42, 42, 42}), ClassTag$.MODULE$.Byte());
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        HttpMethodBase delete = this.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)delete.getStatusCode());
    }

    private void waitNotFound(long startTime, int lifespan, String fullPathKey) {
        block2: {
            BoxedUnit boxedUnit;
            while (System.currentTimeMillis() < startTime + (long)lifespan + 20000L) {
                if (((Object)BoxesRunTime.boxToInteger((int)404)).equals(BoxesRunTime.boxToInteger((int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode()))) {
                    boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                Thread.sleep(100L);
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private HttpMethodBase put(Method m) {
        return this.put(this.fullPathKey(m), "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) {
        return this.put(this.fullPathKey(m), data, "application/text");
    }

    private HttpMethodBase put(String path, Object data, String contentType) {
        Object object;
        block4: {
            StringRequestEntity stringRequestEntity;
            PutMethod put;
            block3: {
                block2: {
                    put = new PutMethod(path);
                    put.setRequestHeader("Content-Type", contentType);
                    object = data;
                    if (!(object instanceof String)) break block2;
                    String string = (String)object;
                    stringRequestEntity = new StringRequestEntity(string, null, null);
                    break block3;
                }
                if (!(object instanceof byte[])) break block4;
                byte[] byArray = (byte[])object;
                stringRequestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(byArray));
            }
            StringRequestEntity reqEntity = stringRequestEntity;
            put.setRequestEntity((RequestEntity)reqEntity);
            this.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
            return put;
        }
        throw new MatchError(object);
    }

    private HttpMethodBase get(Method m) {
        return this.get(m, (Option<String>)None$.MODULE$);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince) {
        return this.get(m, unmodSince, (Option<String>)None$.MODULE$, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType) {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType, int expCode) {
        GetMethod get = new GetMethod(this.fullPathKey(m));
        Option<String> option = unmodSince;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            get.setRequestHeader("If-Unmodified-Since", (String)unmodSince.get());
        }
        Option<String> option2 = acceptType;
        None$ none$2 = None$.MODULE$;
        if (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) {
            get.setRequestHeader("Accept", (String)acceptType.get());
        }
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    private String fullPathKey(Method m) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    private String fullPathKey(Method m, int port) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    public String addDay(String aDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat(this.DATE_PATTERN_RFC1123(), Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888";
        this.cacheName = "___defaultcache";
        this.DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    }

    public class ControlledCache<String, Any>
    extends AbstractDelegatingAdvancedCache<String, Any> {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;
        public final /* synthetic */ IntegrationTest $outer;

        public boolean replace(String key, Any oldValue, Any value, Metadata metadata) {
            Object object;
            byte[] newByteArray = (byte[])value;
            byte[] oldByteArray = (byte[])oldValue;
            String oldAsString = new String(oldByteArray);
            String newAsString = new String(newByteArray);
            if (Arrays.equals(newByteArray, "data2".getBytes())) {
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debug((Object)"Let v3 apply...");
                this.v3PutLatch.countDown();
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debug((Object)"Wait until v2 can be stored");
                boolean bl = this.v2PutLatch.await(10L, TimeUnit.SECONDS);
                if (!bl) {
                    AssertJUnit.fail((String)"Timed out waiting for v2 to be allowed");
                }
                object = BoxedUnit.UNIT;
            } else if (Arrays.equals(newByteArray, "data3".getBytes())) {
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debugf("About to store v3, let v2 apply, oldValue(for v3)=%s", new Object[]{oldAsString});
                this.v2PutLatch.countDown();
                object = BoxesRunTime.boxToBoolean((boolean)this.v2FinishLatch.await(10L, TimeUnit.SECONDS));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debugf("Replace key=%s, oldValue=%s, value=%s", key, (Object)oldAsString, (Object)newAsString);
            return super.replace(key, oldValue, value, metadata);
        }

        public /* synthetic */ IntegrationTest org$infinispan$rest$IntegrationTest$ControlledCache$$$outer() {
            return this.$outer;
        }

        public ControlledCache(IntegrationTest $outer, Cache<String, Any> cache, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(cache.getAdvancedCache());
        }
    }

    public class ControlledCacheManager
    extends AbstractDelegatingEmbeddedCacheManager {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;
        public final /* synthetic */ IntegrationTest $outer;

        public <K, V> AdvancedCache<K, V> getCache() {
            return new ControlledCache(this.org$infinispan$rest$IntegrationTest$ControlledCacheManager$$$outer(), super.getCache(), this.v2PutLatch, this.v3PutLatch, this.v2FinishLatch);
        }

        public /* synthetic */ IntegrationTest org$infinispan$rest$IntegrationTest$ControlledCacheManager$$$outer() {
            return this.$outer;
        }

        public ControlledCacheManager(IntegrationTest $outer, EmbeddedCacheManager cm, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(cm);
        }
    }
}

