/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.NettyRestServer;
import org.infinispan.rest.configuration.RestServerConfiguration;

public class EmbeddedRestServer {
    final NettyRestServer server;
    final EmbeddedCacheManager cacheManager;
    final RestServerConfiguration configuration;

    public EmbeddedRestServer(EmbeddedCacheManager cacheManager, RestServerConfiguration configuration) {
        this.cacheManager = cacheManager;
        this.configuration = configuration;
        this.server = NettyRestServer.apply((RestServerConfiguration)configuration, (EmbeddedCacheManager)cacheManager);
    }

    public void start() throws Exception {
        this.cacheManager.start();
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.cacheManager.stop();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getHost() {
        return this.configuration.host();
    }

    public int getPort() {
        return this.configuration.port();
    }
}

