/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.CacheControl;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.EmbeddedRestServer;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.rest.RestServerTestBase;
import org.infinispan.rest.RestTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

@Test(groups={"functional"}, testName="rest.IntegrationTest")
@ScalaSignature(bytes="\u0006\u0001\r\u001dh\u0001B\u0001\u0003\u0001%\u0011q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA]3ti*\u0011QAB\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\r\u001b\u0005\u0011\u0011BA\u0007\u0003\u0005I\u0011Vm\u001d;TKJ4XM\u001d+fgR\u0014\u0015m]3\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002CA\u0006\u0001\u0011\u001d\u0019\u0002A1A\u0005\u0002Q\tA\u0001S(T)V\tQ\u0003\u0005\u0002\u001775\tqC\u0003\u0002\u00193\u0005!A.\u00198h\u0015\u0005Q\u0012\u0001\u00026bm\u0006L!\u0001H\f\u0003\rM#(/\u001b8h\u0011\u0019q\u0002\u0001)A\u0005+\u0005)\u0001jT*UA!9\u0001\u0005\u0001b\u0001\n\u0003!\u0012!C2bG\",g*Y7f\u0011\u0019\u0011\u0003\u0001)A\u0005+\u0005Q1-Y2iK:\u000bW.\u001a\u0011\t\u000f\u0011\u0002!\u0019!C\u0001)\u0005Aa-\u001e7m!\u0006$\b\u000e\u0003\u0004'\u0001\u0001\u0006I!F\u0001\nMVdG\u000eU1uQ\u0002Bq\u0001\u000b\u0001C\u0002\u0013\u0005A#\u0001\u000bE\u0003R+u\fU!U)\u0016\u0013fj\u0018*G\u0007F\n$g\r\u0005\u0007U\u0001\u0001\u000b\u0011B\u000b\u0002+\u0011\u000bE+R0Q\u0003R#VI\u0015(`%\u001a\u001b\u0015'\r\u001a4A!9A\u0006\u0001a\u0001\n\u0013i\u0013\u0001D2bG\",W*\u00198bO\u0016\u0014X#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0011aB7b]\u0006<WM]\u0005\u0003gA\u0012A#R7cK\u0012$W\rZ\"bG\",W*\u00198bO\u0016\u0014\bbB\u001b\u0001\u0001\u0004%IAN\u0001\u0011G\u0006\u001c\u0007.Z'b]\u0006<WM]0%KF$\"aN\u001f\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b}Q\n\t\u00111\u0001/\u0003\rAH%\r\u0005\u0007\u0001\u0002\u0001\u000b\u0015\u0002\u0018\u0002\u001b\r\f7\r[3NC:\fw-\u001a:!\u0011\u0015\u0011\u0005\u0001\"\u0003D\u0003A1W\u000f\u001c7QCRDw+\u001b;i!>\u0014H\u000fF\u0002E\u0015J\u0003\"!\u0012%\u000f\u0005a2\u0015BA$:\u0003\u0019\u0001&/\u001a3fM&\u0011A$\u0013\u0006\u0003\u000ffBQaS!A\u00021\u000b\u0011!\u001c\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f^\tqA]3gY\u0016\u001cG/\u0003\u0002R\u001d\n1Q*\u001a;i_\u0012DQaU!A\u0002Q\u000bA\u0001]8siB\u0011\u0001(V\u0005\u0003-f\u00121!\u00138u\u0011\u0015A\u0006\u0001\"\u0001Z\u0003\u0015\u0019X\r^+q)\u00059\u0004\u0006B,\\G\u0012\u0004\"\u0001X1\u000e\u0003uS!AX0\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003A\u001a\ta\u0001^3ti:<\u0017B\u00012^\u0005-\u0011UMZ8sK\u000ec\u0017m]:\u0002\u0013\u0005dw/Y=t%Vt\u0017$A\u0001\t\u000b\u0019\u0004A\u0011A4\u0002%\r\u0014X-\u0019;f\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\u000b\u0002]!)\u0011\u000e\u0001C\u00013\u0006AA/Z1s\t><h\u000e\u000b\u0003iW\u000e$\u0007C\u0001/m\u0013\tiWL\u0001\u0006BMR,'o\u00117bgNDQa\u001c\u0001\u0005\u0002A\f!\u0003^3ti\n\u000b7/[2Pa\u0016\u0014\u0018\r^5p]R\u0011q'\u001d\u0005\u0006\u0017:\u0004\r\u0001\u0014\u0005\u0006g\u0002!\t!W\u0001\ri\u0016\u001cH/R7qif<U\r\u001e\u0005\u0006k\u0002!\t!W\u0001\u0016i\u0016\u001cH\u000fR3mKR,gj\u001c8Fq&\u001cH/\u001a8u\u0011\u00159\b\u0001\"\u0001Z\u0003E!Xm\u001d;HKR\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0006s\u0002!\t!W\u0001\u0018i\u0016\u001cHoR3u\u0007>dG.Z2uS>tWi]2ba\u0016DQa\u001f\u0001\u0005\nq\fQbZ3u\u0007>dG.Z2uS>tGC\u0001#~\u0011\u0015q(\u00101\u0001E\u0003\u001d1\u0018M]5b]RDq!!\u0001\u0001\t\u0003\t\u0019!A\u0004uKN$x)\u001a;\u0015\u0007]\n)\u0001C\u0003L\u007f\u0002\u0007A\nC\u0004\u0002\n\u0001!\t!a\u0003\u0002\u0011Q,7\u000f\u001e%fC\u0012$2aNA\u0007\u0011\u0019Y\u0015q\u0001a\u0001\u0019\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0011a\u0005;fgR<U\r^%g+:lw\u000eZ5gS\u0016$GcA\u001c\u0002\u0016!11*a\u0004A\u00021Cq!!\u0007\u0001\t\u0003\tY\"A\tuKN$\bk\\:u\tV\u0004H.[2bi\u0016$2aNA\u000f\u0011\u0019Y\u0015q\u0003a\u0001\u0019\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012!\u0007;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5US6,Gk\u001c'jm\u0016$2aNA\u0013\u0011\u0019Y\u0015q\u0004a\u0001\u0019\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012A\u0007;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5NCbLE\r\\3P]2LHcA\u001c\u0002.!11*a\nA\u00021Cq!!\r\u0001\t\u0003\t\u0019$A\u000fuKN$\b+\u001e;ECR\fw+\u001b;i)&lW\rV8MSZ,wJ\u001c7z)\r9\u0014Q\u0007\u0005\u0007\u0017\u0006=\u0002\u0019\u0001'\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u0005I\u0002/\u001e;B]\u0012\f5o]3si\u0016\u0003\b.Z7fe\u0006dG)\u0019;b)\u001d9\u0014QHA \u0003\u0007BaaSA\u001c\u0001\u0004a\u0005bBA!\u0003o\u0001\r\u0001R\u0001\u0012i&lW\rV8MSZ,7+Z2p]\u0012\u001c\bbBA#\u0003o\u0001\r\u0001R\u0001\u0013[\u0006D\u0018\n\u001a7f)&lWmU3d_:$7\u000fC\u0004\u0002J\u0001!\t!a\u0013\u0002-Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"Le-T1uG\"$2aNA'\u0011\u0019Y\u0015q\ta\u0001\u0019\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013A\u0007;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5JM:{g.Z'bi\u000eDGcA\u001c\u0002V!11*a\u0014A\u00021Cq!!\u0017\u0001\t\u0003\tY&\u0001\u0010uKN$\b+\u001e;ECR\fw+\u001b;i\u0013\u001alu\u000eZ5gS\u0016$7+\u001b8dKR\u0019q'!\u0018\t\r-\u000b9\u00061\u0001M\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\n\u0001\u0005^3tiB+H\u000fR1uC^KG\u000f[%g+:lu\u000eZ5gS\u0016$7+\u001b8dKR\u0019q'!\u001a\t\r-\u000by\u00061\u0001M\u0011\u001d\tI\u0007\u0001C\u0001\u0003W\n\u0011\u0004^3ti\u0012+G.\u001a;f\t\u0006$\u0018mV5uQ&3W*\u0019;dQR\u0019q'!\u001c\t\r-\u000b9\u00071\u0001M\u0011\u001d\t\t\b\u0001C\u0001\u0003g\nQ\u0004^3ti\u0012+G.\u001a;f\t\u0006$\u0018mV5uQ&3gj\u001c8f\u001b\u0006$8\r\u001b\u000b\u0004o\u0005U\u0004BB&\u0002p\u0001\u0007A\nC\u0004\u0002z\u0001!\t!a\u001f\u0002CQ,7\u000f\u001e#fY\u0016$X\rR1uC^KG\u000f[%g\u001b>$\u0017NZ5fINKgnY3\u0015\u0007]\ni\b\u0003\u0004L\u0003o\u0002\r\u0001\u0014\u0005\b\u0003\u0003\u0003A\u0011AAB\u0003\r\"Xm\u001d;EK2,G/\u001a#bi\u0006<\u0016\u000e\u001e5JMVsWn\u001c3jM&,GmU5oG\u0016$2aNAC\u0011\u0019Y\u0015q\u0010a\u0001\u0019\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0015\u0001\u000b;fgR$U\r\\3uK\u000e\u000b7\r[3Qe\u0016\u001cwN\u001c3ji&|g.\u00168j[BdW-\\3oi\u0016$GcA\u001c\u0002\u000e\"11*a\"A\u00021Cq!!%\u0001\t\u0013\t\u0019*A\u0013uKN$H)\u001a7fi\u0016\u0004&/Z2p]\u0012LG/[8oC2,f.[7qY\u0016lWM\u001c;fIR\u0019q'!&\t\u000f\u0005]\u0015q\u0012a\u0001\t\u0006Ya-\u001e7m!\u0006$\bnS3z\u0011\u001d\t\t\n\u0001C\u0005\u00037#RaNAO\u0003?Cq!a&\u0002\u001a\u0002\u0007A\tC\u0004\u0002\"\u0006e\u0005\u0019\u0001#\u00021A\u0014XmY8oI&$\u0018n\u001c8bY\"+\u0017\rZ3s\u001d\u0006lW\rC\u0004\u0002&\u0002!I!a*\u0002)\u0005\u001c8/\u001a:u\u001d>$\u0018*\u001c9mK6,g\u000e^3e)\r9\u0014\u0011\u0016\u0005\t\u0003W\u000b\u0019\u000b1\u0001\u0002.\u00061Q.\u001a;i_\u0012\u0004B!a,\u0002>6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),\u0001\u0006iiR\u00048\r\\5f]RTA!a.\u0002:\u000691m\\7n_:\u001c(bAA^\r\u00051\u0011\r]1dQ\u0016LA!a0\u00022\nQ\u0001\n\u001e;q\u001b\u0016$\bn\u001c3\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\u0006yA/Z:u%\u0016lwN^3F]R\u0014\u0018\u0010F\u00028\u0003\u000fDaaSAa\u0001\u0004a\u0005bBAf\u0001\u0011\u0005\u0011QZ\u0001\u0014i\u0016\u001cHoV5qK\u000e\u000b7\r[3Ck\u000e\\W\r\u001e\u000b\u0004o\u0005=\u0007BB&\u0002J\u0002\u0007A\nC\u0004\u0002T\u0002!\t!!6\u0002%Q,7\u000f^!ts:\u001c\u0017\t\u001a3SK6|g/\u001a\u000b\u0004o\u0005]\u0007BB&\u0002R\u0002\u0007A\nC\u0004\u0002\\\u0002!\t!!8\u0002=Q,7\u000f^*i_VdGmQ8qK^KG\u000f[*fe&\fG.\u001b>bE2,GcA\u001c\u0002`\"11*!7A\u00021Cq!a9\u0001\t\u0003\t)/A\u000fuKN$\u0018J\\:feR\u001cVM]5bY&T\u0018M\u00197f\u001f\nTWm\u0019;t)\r9\u0014q\u001d\u0005\u0007\u0017\u0006\u0005\b\u0019\u0001'\t\u000f\u0005-\b\u0001\"\u0001\u0002n\u0006!B/Z:u\u001d>tW\r_5ti\u0016tGoQ1dQ\u0016$2aNAx\u0011\u0019Y\u0015\u0011\u001ea\u0001\u0019\"9\u00111\u001f\u0001\u0005\u0002\u0005U\u0018\u0001\t;fgR\u0014\u0015\u0010^3BeJ\f\u00170Q:TKJL\u0017\r\\5{K\u0012|%M[3diN$2aNA|\u0011\u0019Y\u0015\u0011\u001fa\u0001\u0019\"9\u00111 \u0001\u0005\u0002\u0005u\u0018!\t;fgR\u0014\u0015\u0010^3BeJ\f\u00170Q:PGR,7m\u0015;sK\u0006lwJ\u00196fGR\u001cHcA\u001c\u0002\u0000\"11*!?A\u00021CqAa\u0001\u0001\t\u0013\u0011)!A\btK:$')\u001f;f\u0003J\u0014\u0018-_!t)\u00159$q\u0001B\u0005\u0011\u0019Y%\u0011\u0001a\u0001\u0019\"9!1\u0002B\u0001\u0001\u0004!\u0015aC2p]R,g\u000e\u001e+za\u0016DqAa\u0004\u0001\t\u0003\u0011\t\"A\u000buKN$\u0018JZ+o[>$\u0017NZ5fINKgnY3\u0015\u0007]\u0012\u0019\u0002\u0003\u0004L\u0005\u001b\u0001\r\u0001\u0014\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0003=!Xm\u001d;F)\u0006<7\t[1oO\u0016\u001cHcA\u001c\u0003\u001c!11J!\u0006A\u00021CqAa\b\u0001\t\u0003\u0011\t#A\ruKN$8i\u001c8dkJ\u0014XM\u001c;F)\u0006<7\t[1oO\u0016\u001cHcA\u001c\u0003$!11J!\bA\u00021CqAa\n\u0001\t\u0003\u0011I#\u0001\u000fuKN$8+\u001a:jC2L'0\u001a3TiJLgnZ$fi\nKH/Z:\u0015\u0007]\u0012Y\u0003\u0003\u0004L\u0005K\u0001\r\u0001\u0014\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0003\u0005\"Xm\u001d;EK\u001a\fW\u000f\u001c;D_:4\u0017nZ;sK\u0012,\u0005\u0010]5ssZ\u000bG.^3t)\r9$1\u0007\u0005\u0007\u0017\n5\u0002\u0019\u0001'\t\u000f\t]\u0002\u0001\"\u0001\u0003:\u0005qB/Z:u\u0007\u0006\u001c\u0007.Z\"p]R\u0014x\u000e\u001c*fgB|gn]3IK\u0006$WM\u001d\u000b\u0004o\tm\u0002BB&\u00036\u0001\u0007A\nC\u0004\u0003@\u0001!\tA!\u0011\u0002QQ,7\u000f^$fi\u000e\u000b7\r[3D_:$(o\u001c7NS:4%/Z:i%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\u0015\u0007]\u0012\u0019\u0005\u0003\u0004L\u0005{\u0001\r\u0001\u0014\u0005\b\u0005\u000f\u0002A\u0011\u0001B%\u0003%\"Xm\u001d;IK\u0006$7)Y2iK\u000e{g\u000e\u001e:pY6KgN\u0012:fg\"\u0014V-];fgRDU-\u00193feR\u0019qGa\u0013\t\r-\u0013)\u00051\u0001M\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#\nQ\u0003^3tiB+HOQ=uK\u0006\u0013(/Y=Uo&\u001cW\rF\u00028\u0005'Baa\u0013B'\u0001\u0004a\u0005b\u0002B,\u0001\u0011\u0005!\u0011L\u0001\u001bi\u0016\u001cH\u000fR3mKR,7+\u001a:jC2L'0\u001a3PE*,7\r\u001e\u000b\u0004o\tm\u0003BB&\u0003V\u0001\u0007A\nC\u0004\u0003`\u0001!\tA!\u0019\u0002!Q,7\u000f\u001e#jg\u0006\u0014G.Z\"bG\",GcA\u001c\u0003d!11J!\u0018A\u00021CqAa\u001a\u0001\t\u0013\u0011I'\u0001\u0007xC&$hj\u001c;G_VtG\rF\u00048\u0005W\u0012)H!\u001f\t\u0011\t5$Q\ra\u0001\u0005_\n\u0011b\u001d;beR$\u0016.\\3\u0011\u0007a\u0012\t(C\u0002\u0003te\u0012A\u0001T8oO\"9!q\u000fB3\u0001\u0004!\u0016\u0001\u00037jM\u0016\u001c\b/\u00198\t\u000f\u0005]%Q\ra\u0001\t\"9!Q\u0010\u0001\u0005\n\t}\u0014a\u00019viR!!\u0011\u0011BD!\u0011\tyKa!\n\t\t\u0015\u0015\u0011\u0017\u0002\u000f\u0011R$\b/T3uQ>$')Y:f\u0011\u0019Y%1\u0010a\u0001\u0019\"9!Q\u0010\u0001\u0005\n\t-EC\u0002BA\u0005\u001b\u0013y\t\u0003\u0004L\u0005\u0013\u0003\r\u0001\u0014\u0005\t\u0005#\u0013I\t1\u0001\u0003\u0014\u0006!A-\u0019;b!\rA$QS\u0005\u0004\u0005/K$aA!os\"9!Q\u0010\u0001\u0005\n\tmE\u0003\u0003BA\u0005;\u0013\tKa)\t\u000f\t}%\u0011\u0014a\u0001\t\u0006!\u0001/\u0019;i\u0011!\u0011\tJ!'A\u0002\tM\u0005b\u0002B\u0006\u00053\u0003\r\u0001\u0012\u0005\b\u0005O\u0003A\u0011\u0002BU\u0003\r9W\r\u001e\u000b\u0005\u0005\u0003\u0013Y\u000b\u0003\u0004L\u0005K\u0003\r\u0001\u0014\u0005\b\u0005O\u0003A\u0011\u0002BX)\u0019\u0011\tI!-\u00034\"11J!,A\u00021C\u0001B!.\u0003.\u0002\u0007!qW\u0001\u000bk:lw\u000eZ*j]\u000e,\u0007\u0003\u0002\u001d\u0003:\u0012K1Aa/:\u0005\u0019y\u0005\u000f^5p]\"9!q\u0015\u0001\u0005\n\t}F\u0003\u0003BA\u0005\u0003\u0014\u0019M!2\t\r-\u0013i\f1\u0001M\u0011!\u0011)L!0A\u0002\t]\u0006\u0002\u0003Bd\u0005{\u0003\rAa.\u0002\u0015\u0005\u001c7-\u001a9u)f\u0004X\rC\u0004\u0003(\u0002!IAa3\u0015\u0015\t\u0005%Q\u001aBh\u0005#\u0014\u0019\u000e\u0003\u0004L\u0005\u0013\u0004\r\u0001\u0014\u0005\t\u0005k\u0013I\r1\u0001\u00038\"A!q\u0019Be\u0001\u0004\u00119\fC\u0004\u0003V\n%\u0007\u0019\u0001+\u0002\u000f\u0015D\boQ8eK\"9\u0011q\u0013\u0001\u0005\n\teGc\u0001#\u0003\\\"11Ja6A\u00021Cq!a&\u0001\t\u0013\u0011y\u000eF\u0003E\u0005C\u0014\u0019\u000f\u0003\u0004L\u0005;\u0004\r\u0001\u0014\u0005\u0007'\nu\u0007\u0019\u0001+\t\u000f\t\u001d\b\u0001\"\u0001\u0003j\u00061\u0011\r\u001a3ECf$R\u0001\u0012Bv\u0005_DqA!<\u0003f\u0002\u0007A)A\u0003b\t\u0006$X\rC\u0004\u0003r\n\u0015\b\u0019\u0001+\u0002\t\u0011\f\u0017p\u001d\u0004\u0007\u0005k\u0004\u0001Aa>\u0003-\r{g\u000e\u001e:pY2,GmQ1dQ\u0016l\u0015M\\1hKJ\u001cBAa=\u0003zB!!1`B\u0001\u001b\t\u0011iPC\u0002\u0003\u0000B\nA![7qY&!11\u0001B\u007f\u0005\u0019\n%m\u001d;sC\u000e$H)\u001a7fO\u0006$\u0018N\\4F[\n,G\rZ3e\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\u0005\u000b\u0007\u000f\u0011\u0019P!A!\u0002\u0013q\u0013AA2n\u0011-\u0019YAa=\u0003\u0002\u0003\u0006Ia!\u0004\u0002\u0015Y\u0014\u0004+\u001e;MCR\u001c\u0007\u000e\u0005\u0003\u0004\u0010\reQBAB\t\u0015\u0011\u0019\u0019b!\u0006\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0004\u0018e\tA!\u001e;jY&!11DB\t\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D1ba\b\u0003t\n\u0005\t\u0015!\u0003\u0004\u000e\u0005Qao\r)vi2\u000bGo\u00195\t\u0017\r\r\"1\u001fB\u0001B\u0003%1QB\u0001\u000emJ2\u0015N\\5tQ2\u000bGo\u00195\t\u000f=\u0011\u0019\u0010\"\u0001\u0004(QQ1\u0011FB\u0017\u0007_\u0019\tda\r\u0011\t\r-\"1_\u0007\u0002\u0001!91qAB\u0013\u0001\u0004q\u0003\u0002CB\u0006\u0007K\u0001\ra!\u0004\t\u0011\r}1Q\u0005a\u0001\u0007\u001bA\u0001ba\t\u0004&\u0001\u00071Q\u0002\u0005\t\u0007o\u0011\u0019\u0010\"\u0011\u0004:\u0005Aq-\u001a;DC\u000eDW-\u0006\u0004\u0004<\r%3q\u000b\u000b\u0003\u0007{\u0001\u0002ba\u0010\u0004B\r\u00153QK\u0007\u0002\t%\u001911\t\u0003\u0003\u001b\u0005#g/\u00198dK\u0012\u001c\u0015m\u00195f!\u0011\u00199e!\u0013\r\u0001\u0011A11JB\u001b\u0005\u0004\u0019iEA\u0001L#\u0011\u0019yEa%\u0011\u0007a\u001a\t&C\u0002\u0004Te\u0012qAT8uQ&tw\r\u0005\u0003\u0004H\r]C\u0001CB-\u0007k\u0011\ra!\u0014\u0003\u0003Y3aa!\u0018\u0001\u0001\r}#aD\"p]R\u0014x\u000e\u001c7fI\u000e\u000b7\r[3\u0016\r\r\u000541OB<'\u0011\u0019Yfa\u0019\u0011\u0011\r\u00154QNB9\u0007kj!aa\u001a\u000b\t\t}8\u0011\u000e\u0006\u0004\u0007W\"\u0011!B2bG\",\u0017\u0002BB8\u0007O\u0012q$\u00112tiJ\f7\r\u001e#fY\u0016<\u0017\r^5oO\u0006#g/\u00198dK\u0012\u001c\u0015m\u00195f!\u0011\u00199ea\u001d\u0005\u000fq\u0019YF1\u0001\u0004NA!1qIB<\t!\u00119ja\u0017C\u0002\r5\u0003bCB6\u00077\u0012\t\u0011)A\u0005\u0007w\u0002\u0002ba\u0010\u0004~\rE4QO\u0005\u0004\u0007\u007f\"!!B\"bG\",\u0007bCB\u0006\u00077\u0012\t\u0011)A\u0005\u0007\u001bA1ba\b\u0004\\\t\u0005\t\u0015!\u0003\u0004\u000e!Y11EB.\u0005\u0003\u0005\u000b\u0011BB\u0007\u0011\u001dy11\fC\u0001\u0007\u0013#\"ba#\u0004\u000e\u000e=5\u0011SBJ!!\u0019Yca\u0017\u0004r\rU\u0004\u0002CB6\u0007\u000f\u0003\raa\u001f\t\u0011\r-1q\u0011a\u0001\u0007\u001bA\u0001ba\b\u0004\b\u0002\u00071Q\u0002\u0005\t\u0007G\u00199\t1\u0001\u0004\u000e!A1qSB.\t\u0003\u001aI*A\u0004sKBd\u0017mY3\u0015\u0015\rm5\u0011UBS\u0007S\u001bi\u000bE\u00029\u0007;K1aa(:\u0005\u001d\u0011un\u001c7fC:D\u0001ba)\u0004\u0016\u0002\u00071\u0011O\u0001\u0004W\u0016L\b\u0002CBT\u0007+\u0003\ra!\u001e\u0002\u0011=dGMV1mk\u0016D\u0001ba+\u0004\u0016\u0002\u00071QO\u0001\u0006m\u0006dW/\u001a\u0005\t\u0007_\u001b)\n1\u0001\u00042\u0006AQ.\u001a;bI\u0006$\u0018\r\u0005\u0003\u00044\u000e]VBAB[\u0015\r\u0019y\u000bB\u0005\u0005\u0007s\u001b)L\u0001\u0005NKR\fG-\u0019;b\u00111\u0019i\f\u0001I\u0001\u0002\u0003\u0005I\u0011AB`\u00035\u0001(o\u001c;fGR,G\r\n7pOR!1\u0011YBh!\u0011\u0019\u0019ma3\u000e\u0005\r\u0015'\u0002BBd\u0007\u0013\fq\u0001\\8hO&twMC\u0002\u0004\u0018\u0011IAa!4\u0004F\n\u0019Aj\\4\t\u0011y\u001aY,!AA\u0002EA3\u0002ABj\u00073\u001cYn!9\u0004dB\u0019Al!6\n\u0007\r]WL\u0001\u0003UKN$\u0018AB4s_V\u00048\u000f\f\u0002\u0004^\u0006\u00121q\\\u0001\u000bMVt7\r^5p]\u0006d\u0017\u0001\u0003;fgRt\u0015-\\3\"\u0005\r\u0015\u0018\u0001\u0006:fgRt\u0013J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000f")
public class IntegrationTest
extends RestServerTestBase {
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).toString();
    private final String DATE_PATTERN_RFC1123;
    private EmbeddedCacheManager cacheManager = null;

    public /* synthetic */ Log protected$log(IntegrationTest x$1) {
        return x$1.log;
    }

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String DATE_PATTERN_RFC1123() {
        return this.DATE_PATTERN_RFC1123;
    }

    private EmbeddedCacheManager cacheManager() {
        return this.cacheManager;
    }

    private void cacheManager_$eq(EmbeddedCacheManager x$1) {
        this.cacheManager = x$1;
    }

    public String org$infinispan$rest$IntegrationTest$$fullPathWithPort(Method m, int port) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://localhost:", "/rest/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port), this.cacheName(), m.getName()}));
    }

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        this.cacheManager_$eq(TestCacheManagerFactory.fromXml((String)"test-config.xml"));
        this.addServer("single", 8888, this.cacheManager());
        this.startServers();
        this.createClient();
    }

    public EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.fromXml((String)"test-config.xml");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.destroyClient();
        this.stopServers();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager()});
    }

    public void testBasicOperation(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        insert.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(initialXML.toString().getBytes(), "application/octet-stream"));
        this.call((HttpMethodBase)insert);
        AssertJUnit.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        AssertJUnit.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        AssertJUnit.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        this.call((HttpMethodBase)remove);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        this.call((HttpMethodBase)insert);
        this.call((HttpMethodBase)get);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)removeAll).getStatusCode());
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byteData, "application/octet-stream"));
        this.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        AssertJUnit.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        AssertJUnit.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testDeleteNonExistent() {
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGetCollection() {
        PostMethod post_a = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/a"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_a.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_a);
        PostMethod post_b = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/b"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_b.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_b);
        String html = this.getCollection("text/html");
        AssertJUnit.assertTrue((boolean)html.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "/a\">a</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cacheName()}))));
        AssertJUnit.assertTrue((boolean)html.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "/b\">b</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cacheName()}))));
        String xml = this.getCollection("application/xml");
        AssertJUnit.assertTrue((boolean)xml.contains("<key>a</key>"));
        AssertJUnit.assertTrue((boolean)xml.contains("<key>b</key>"));
        String plain = this.getCollection("text/plain;charset=UTF-8");
        AssertJUnit.assertTrue((boolean)plain.contains("a\n"));
        AssertJUnit.assertTrue((boolean)plain.contains("b\n"));
        String json = this.getCollection("application/json");
        AssertJUnit.assertTrue((boolean)json.contains("\"a\""));
        AssertJUnit.assertTrue((boolean)json.contains("\"b\""));
    }

    public void testGetCollectionEscape() {
        PostMethod post_a = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/%22a%22"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_a.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_a);
        PostMethod post_b = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/b%3E"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_b.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_b);
        String html = this.getCollection("text/html");
        AssertJUnit.assertTrue((boolean)html.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "/&quot;a&quot;\">&quot;a&quot;</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cacheName()}))));
        AssertJUnit.assertTrue((boolean)html.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a href=\"", "/b&gt;\">b&gt;</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cacheName()}))));
        String xml = this.getCollection("application/xml");
        AssertJUnit.assertTrue((boolean)xml.contains("<key>&quot;a&quot;</key>"));
        AssertJUnit.assertTrue((boolean)xml.contains("<key>b&gt;</key>"));
        String plain = this.getCollection("text/plain;charset=UTF-8");
        AssertJUnit.assertTrue((boolean)plain.contains("\"a\"\n"));
        AssertJUnit.assertTrue((boolean)plain.contains("b>\n"));
        String json = this.getCollection("application/json");
        AssertJUnit.assertTrue((boolean)json.contains("\\\"a\\\""));
        AssertJUnit.assertTrue((boolean)json.contains("\"b>\""));
    }

    private String getCollection(String variant) {
        GetMethod get = new GetMethod(this.fullPath());
        get.addRequestHeader("Accept", variant);
        HttpMethodBase coll = this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)coll.getStatusCode());
        AssertJUnit.assertEquals((String)variant, (String)coll.getResponseHeader("Content-Type").getValue());
        return coll.getResponseBodyAsString();
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        AssertJUnit.assertNotNull((Object)lastMod);
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = this.call((HttpMethodBase)getAgain);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)post);
        AssertJUnit.assertEquals((int)409, (int)this.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, new StringOps(Predef$.MODULE$.augmentString(timeToLiveSeconds)).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, new StringOps(Predef$.MODULE$.augmentString(maxIdleTimeSeconds)).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        this.call(get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPutDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Match", etag);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Match", "x");
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-None-Match", "x");
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-None-Match", etag);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Modified-Since", lastMod);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)304, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reputAgain.setRequestHeader("If-Modified-Since", dateMinus);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfUnModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reput.setRequestHeader("If-Unmodified-Since", dateMinus);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testDeleteDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Match", "x");
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Match", etag);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-None-Match", etag);
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-None-Match", "x");
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Modified-Since", lastMod);
        AssertJUnit.assertEquals((int)304, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        deleteAgain.setRequestHeader("If-Modified-Since", dateMinus);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfUnmodifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        delete.setRequestHeader("If-Unmodified-Since", dateMinus);
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteCachePreconditionUnimplemented(Method m) {
        this.testDeletePreconditionalUnimplemented(this.fullPath());
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey) {
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-None-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Modified-Since");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Unmodified-Since");
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey, String preconditionalHeaderName) {
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader(preconditionalHeaderName, "*");
        this.call((HttpMethodBase)delete);
        this.assertNotImplemented((HttpMethod)delete);
    }

    private void assertNotImplemented(HttpMethod method) {
        AssertJUnit.assertEquals((int)method.getStatusCode(), (int)501);
        AssertJUnit.assertEquals((String)method.getStatusText(), (String)"Not Implemented");
        Predef$.MODULE$.assert(method.getResponseBodyAsString().toLowerCase().contains("precondition"));
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        this.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put_);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        this.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("performAsync", "true");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        this.call((HttpMethodBase)del);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        this.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        this.getCacheManager("single").getCache("___defaultcache").put((Object)m.getName(), (Object)obj);
        this.getCacheManager("single").getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), (Object)"hola");
        this.getCacheManager("single").getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), (Object)new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        AssertJUnit.assertNotNull((Object)res);
        AssertJUnit.assertEquals((String)"mic", (String)res.name());
        AssertJUnit.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = this.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        AssertJUnit.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        this.call((HttpMethodBase)get3);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(this.fullPathKey(m), bout.toByteArray(), "application/x-java-serialized-object");
        byte[] cfr_ignored_0 = (byte[])this.getCacheManager("single").getCache("___defaultcache").get((Object)m.getName());
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = this.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), ClassTag$.MODULE$.Byte());
        this.put(this.fullPathKey(m), serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        AssertJUnit.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)dateLast)).getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)datePlus)).getResponseBodyAsString());
        HttpMethodBase httpMethodBase = this.get(m, (Option<String>)new Some((Object)dateMinus), (Option<String>)None$.MODULE$, 412);
    }

    public void testETagChanges(Method m) {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertFalse((String)new StringOps(Predef$.MODULE$.augmentString("etag1 %s; etag2 %s; equals? %b")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eTagFirst, eTagSecond, BoxesRunTime.boxToBoolean((boolean)eTagFirst.equals(eTagSecond))})), (boolean)eTagFirst.equals(eTagSecond));
    }

    /*
     * WARNING - void declaration
     */
    public void testConcurrentETagChanges(Method m) {
        CountDownLatch v2PutLatch = new CountDownLatch(1);
        CountDownLatch v3PutLatch = new CountDownLatch(1);
        CountDownLatch v2FinishLatch = new CountDownLatch(1);
        EmbeddedCacheManager cacheManager = this.createCacheManager();
        ControlledCacheManager mockCacheManager = new ControlledCacheManager(this, cacheManager, v2PutLatch, v3PutLatch, v2FinishLatch);
        EmbeddedRestServer server = RestTestingUtil.startRestServer((EmbeddedCacheManager)mockCacheManager);
        this.put(this.org$infinispan$rest$IntegrationTest$$fullPathWithPort(m, server.getPort()), "data1", "application/text");
        try {
            Future replaceFuture = Future$.MODULE$.apply((Function0)new Serializable(this, m, v2FinishLatch, server){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IntegrationTest $outer;
                private final Method m$1;
                private final CountDownLatch v2FinishLatch$1;
                private final EmbeddedRestServer server$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    HttpClient newClient = new HttpClient();
                    PutMethod put = new PutMethod(this.$outer.org$infinispan$rest$IntegrationTest$$fullPathWithPort(this.m$1, this.server$1.getPort()));
                    put.setRequestHeader("Content-Type", "application/text");
                    put.setRequestEntity((RequestEntity)new StringRequestEntity("data2", null, null));
                    newClient.executeMethod((HttpMethod)put);
                    AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
                    this.v2FinishLatch$1.countDown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                    this.v2FinishLatch$1 = v2FinishLatch$1;
                    this.server$1 = server$1;
                }
            }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            boolean bl = v3PutLatch.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertTrue((String)"Timed out waiting for concurrent put", (boolean)bl);
            PutMethod put = new PutMethod(this.org$infinispan$rest$IntegrationTest$$fullPathWithPort(m, server.getPort()));
            put.setRequestHeader("Content-Type", "application/text");
            put.setRequestEntity((RequestEntity)new StringRequestEntity("data3", null, null));
            this.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)412, (int)put.getStatusCode());
            Await$.MODULE$.result((Awaitable)replaceFuture, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds());
            AssertJUnit.assertEquals((String)"data2", (String)this.get(m).getResponseBodyAsString());
        }
        catch (Throwable throwable) {
            void var5_5;
            void var7_7;
            var7_7.stop();
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{var5_5});
            throw throwable;
        }
        server.stop();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }

    public void testSerializedStringGetBytes(Method m) {
        byte[] data = new StringBuilder().append((Object)"v-").append((Object)m.getName()).toString().getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(this.fullPathKey(m), bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"application/x-java-serialized-object")).getResponseBody();
        AssertJUnit.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        AssertJUnit.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    public void testDefaultConfiguredExpiryValues(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "-1");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(5000L);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        AssertJUnit.assertNull((Object)get.getResponseHeader("Expires"));
        long startTime = System.currentTimeMillis();
        int lifespan = 3000;
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-2")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        while (System.currentTimeMillis() < startTime + (long)lifespan) {
            get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
            String response = get.getResponseBodyAsString();
            if (System.currentTimeMillis() >= startTime + (long)lifespan) continue;
            AssertJUnit.assertEquals((String)"data2", (String)response);
            AssertJUnit.assertNotNull((Object)get.getResponseHeader("Expires"));
            Thread.sleep(100L);
        }
        this.waitNotFound(startTime, lifespan, fullPathKey);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        startTime = System.currentTimeMillis();
        lifespan = 0;
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-3")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data3", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(1000L);
        get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        String response = get.getResponseBodyAsString();
        AssertJUnit.assertEquals((String)"data3", (String)response);
        Thread.sleep(2000L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-4")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data4", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2500L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
    }

    public void testCacheControlResponseHeader(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Cache-Control"));
        int retrievedMaxAge = CacheControl.valueOf((String)get.getResponseHeader("Cache-Control").getValue()).getMaxAge();
        AssertJUnit.assertTrue((retrievedMaxAge > 0 ? 1 : 0) != 0);
    }

    public void testGetCacheControlMinFreshRequestHeader(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        GetMethod getLongMinFresh = new GetMethod(fullPathKey);
        getLongMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=20");
        HttpMethodBase getResp = this.call((HttpMethodBase)getLongMinFresh);
        AssertJUnit.assertEquals((int)404, (int)getResp.getStatusCode());
        GetMethod getShortMinFresh = new GetMethod(fullPathKey);
        getShortMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=2");
        getResp = this.call((HttpMethodBase)getShortMinFresh);
        AssertJUnit.assertNotNull((Object)getResp.getResponseHeader("Cache-Control"));
        AssertJUnit.assertEquals((String)"data", (String)getResp.getResponseBodyAsString());
        GetMethod getNoMinFresh = new GetMethod(fullPathKey);
        getResp = this.call((HttpMethodBase)getNoMinFresh);
        AssertJUnit.assertNotNull((Object)getResp.getResponseHeader("Cache-Control"));
        AssertJUnit.assertEquals((String)"data", (String)getResp.getResponseBodyAsString());
    }

    public void testHeadCacheControlMinFreshRequestHeader(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        HeadMethod headLongMinFresh = new HeadMethod(fullPathKey);
        headLongMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=20");
        HttpMethodBase headResp = this.call((HttpMethodBase)headLongMinFresh);
        AssertJUnit.assertEquals((int)404, (int)headResp.getStatusCode());
        HeadMethod headShortMinFresh = new HeadMethod(fullPathKey);
        headShortMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=2");
        headResp = this.call((HttpMethodBase)headShortMinFresh);
        int retrievedMaxAge = CacheControl.valueOf((String)headResp.getResponseHeader("Cache-Control").getValue()).getMaxAge();
        AssertJUnit.assertTrue((retrievedMaxAge > 0 ? 1 : 0) != 0);
        HeadMethod headNoMinFresh = new HeadMethod(fullPathKey);
        headResp = this.call((HttpMethodBase)headNoMinFresh);
        AssertJUnit.assertNotNull((Object)headResp.getResponseHeader("Cache-Control"));
    }

    public void testPutByteArrayTwice(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{42, 42, 42}), ClassTag$.MODULE$.Byte());
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
    }

    public void testDeleteSerializedObject(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{42, 42, 42}), ClassTag$.MODULE$.Byte());
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        HttpMethodBase delete = this.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)delete.getStatusCode());
    }

    public void testDisableCache(Method m) {
        this.put(m);
        AssertJUnit.assertEquals((int)200, (int)this.doGet$1(m).getStatusCode());
        this.ignoreCache(this.cacheName());
        AssertJUnit.assertEquals((int)500, (int)this.doGet$1(m).getStatusCode());
        this.enableCache(this.cacheName());
        AssertJUnit.assertEquals((int)200, (int)this.doGet$1(m).getStatusCode());
    }

    private void waitNotFound(long startTime, int lifespan, String fullPathKey) {
        block2: {
            BoxedUnit boxedUnit;
            while (System.currentTimeMillis() < startTime + (long)lifespan + 20000L) {
                if (((Object)BoxesRunTime.boxToInteger((int)404)).equals(BoxesRunTime.boxToInteger((int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode()))) {
                    boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                Thread.sleep(100L);
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private HttpMethodBase put(Method m) {
        return this.put(this.fullPathKey(m), "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) {
        return this.put(this.fullPathKey(m), data, "application/text");
    }

    private HttpMethodBase put(String path, Object data, String contentType) {
        Object object;
        block4: {
            StringRequestEntity stringRequestEntity;
            PutMethod put;
            block3: {
                block2: {
                    put = new PutMethod(path);
                    put.setRequestHeader("Content-Type", contentType);
                    object = data;
                    if (!(object instanceof String)) break block2;
                    String string = (String)object;
                    stringRequestEntity = new StringRequestEntity(string, null, null);
                    break block3;
                }
                if (!(object instanceof byte[])) break block4;
                byte[] byArray = (byte[])object;
                stringRequestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(byArray));
            }
            StringRequestEntity reqEntity = stringRequestEntity;
            put.setRequestEntity((RequestEntity)reqEntity);
            this.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
            return put;
        }
        throw new MatchError(object);
    }

    private HttpMethodBase get(Method m) {
        return this.get(m, (Option<String>)None$.MODULE$);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince) {
        return this.get(m, unmodSince, (Option<String>)None$.MODULE$, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType) {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType, int expCode) {
        GetMethod get = new GetMethod(this.fullPathKey(m));
        Option<String> option = unmodSince;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            get.setRequestHeader("If-Unmodified-Since", (String)unmodSince.get());
        }
        Option<String> option2 = acceptType;
        None$ none$2 = None$.MODULE$;
        if (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) {
            get.setRequestHeader("Accept", (String)acceptType.get());
        }
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    private String fullPathKey(Method m) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    private String fullPathKey(Method m, int port) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    public String addDay(String aDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat(this.DATE_PATTERN_RFC1123(), Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    private final HttpMethodBase doGet$1(Method m$2) {
        return this.call((HttpMethodBase)new GetMethod(this.fullPathKey(m$2)));
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888";
        this.cacheName = "___defaultcache";
        this.DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    }

    public class ControlledCache<String, Any>
    extends AbstractDelegatingAdvancedCache<String, Any> {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;
        public final /* synthetic */ IntegrationTest $outer;

        public boolean replace(String key, Any oldValue, Any value, Metadata metadata) {
            Object object;
            byte[] newByteArray = (byte[])value;
            byte[] oldByteArray = (byte[])oldValue;
            String oldAsString = new String(oldByteArray);
            String newAsString = new String(newByteArray);
            if (Arrays.equals(newByteArray, "data2".getBytes())) {
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().protected$log(this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer()).debug((Object)"Let v3 apply...");
                this.v3PutLatch.countDown();
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().protected$log(this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer()).debug((Object)"Wait until v2 can be stored");
                boolean bl = this.v2PutLatch.await(10L, TimeUnit.SECONDS);
                if (!bl) {
                    AssertJUnit.fail((String)"Timed out waiting for v2 to be allowed");
                }
                object = BoxedUnit.UNIT;
            } else if (Arrays.equals(newByteArray, "data3".getBytes())) {
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().protected$log(this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer()).debugf("About to store v3, let v2 apply, oldValue(for v3)=%s", new Object[]{oldAsString});
                this.v2PutLatch.countDown();
                object = BoxesRunTime.boxToBoolean((boolean)this.v2FinishLatch.await(10L, TimeUnit.SECONDS));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().protected$log(this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer()).debugf("Replace key=%s, oldValue=%s, value=%s", key, (Object)oldAsString, (Object)newAsString);
            return super.replace(key, oldValue, value, metadata);
        }

        public /* synthetic */ IntegrationTest org$infinispan$rest$IntegrationTest$ControlledCache$$$outer() {
            return this.$outer;
        }

        public ControlledCache(IntegrationTest $outer, Cache<String, Any> cache, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(cache.getAdvancedCache());
        }
    }

    public class ControlledCacheManager
    extends AbstractDelegatingEmbeddedCacheManager {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;
        public final /* synthetic */ IntegrationTest $outer;

        public <K, V> AdvancedCache<K, V> getCache() {
            return new ControlledCache(this.org$infinispan$rest$IntegrationTest$ControlledCacheManager$$$outer(), super.getCache(), this.v2PutLatch, this.v3PutLatch, this.v2FinishLatch);
        }

        public /* synthetic */ IntegrationTest org$infinispan$rest$IntegrationTest$ControlledCacheManager$$$outer() {
            return this.$outer;
        }

        public ControlledCacheManager(IntegrationTest $outer, EmbeddedCacheManager cm, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(cm);
        }
    }
}

