/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.infinispan.rest.logging.JavaLog;
import org.infinispan.util.logging.LogFactory;

@Provider
public class RestAccessLoggingHandler
implements ContainerResponseFilter,
ContainerRequestFilter {
    private static final JavaLog log = (JavaLog)LogFactory.getLog(RestAccessLoggingHandler.class, JavaLog.class);
    private static final String NANO_TIME = "NanoTime";
    @Context
    private ChannelHandlerContext context;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object entity;
        String remoteAddress = this.context.channel().remoteAddress().toString();
        long startNano = Long.parseLong(requestContext.getHeaderString(NANO_TIME));
        String requestMethod = requestContext.getMethod();
        String uri = requestContext.getUriInfo().getPath();
        int status = responseContext.getStatus();
        int requestSize = requestContext.getLength();
        int responseSize = responseContext.getLength();
        if (responseSize == -1 && responseContext.hasEntity() && (entity = responseContext.getEntity()) instanceof byte[]) {
            responseSize = ((byte[])entity).length;
            responseContext.getHeaders().addFirst((Object)"Content-Length", (Object)responseSize);
        }
        long responseTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNano);
        log.tracef("%s [%s] \"%s %s\" %s %d %d %d ms", new Object[]{remoteAddress, responseTime, requestMethod, uri, status, requestSize, responseSize, responseTime});
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        int requestSize = requestContext.getLength();
        if (requestSize == -1) {
            requestSize = requestContext.getEntityStream().available();
            requestContext.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(requestSize));
        }
        requestContext.getHeaders().putSingle((Object)NANO_TIME, (Object)Long.toString(System.nanoTime()));
    }
}

