/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.IOException;
import java.util.function.Consumer;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestCacheManager;
import org.infinispan.rest.SecurityActions;
import org.infinispan.rest.Server;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.logging.RestAccessLoggingHandler;
import org.infinispan.server.core.AbstractCacheIgnoreAware;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfiguration;
import org.infinispan.server.core.utils.SslUtils;
import org.jboss.resteasy.plugins.server.netty.NettyJaxrsServer;
import org.jboss.resteasy.plugins.server.netty.SniConfiguration;
import org.jboss.resteasy.spi.ResteasyDeployment;

public final class NettyRestServer
extends AbstractCacheIgnoreAware
implements Lifecycle {
    final EmbeddedCacheManager cacheManager;
    private final RestServerConfiguration configuration;
    private final NettyJaxrsServer netty;
    private final Consumer<? super EmbeddedCacheManager> onStop;
    private static final Log log = (Log)LogFactory.getLog(NettyRestServer.class, Log.class);

    public static NettyRestServer createServer(RestServerConfiguration configuration) {
        return NettyRestServer.createServer(configuration, (EmbeddedCacheManager)new DefaultCacheManager(), Lifecycle::stop);
    }

    public static NettyRestServer createServer(RestServerConfiguration configuration, String configurationFile) {
        return NettyRestServer.createServer(configuration, NettyRestServer.createCacheManager(configurationFile), Lifecycle::stop);
    }

    public static NettyRestServer createServer(RestServerConfiguration configuration, EmbeddedCacheManager manager) {
        return NettyRestServer.createServer(configuration, manager, cm -> {});
    }

    public static NettyRestServer createServer(RestServerConfiguration configuration, EmbeddedCacheManager manager, Consumer<? super EmbeddedCacheManager> consumer) {
        NettyRestServer.startCaches(manager);
        NettyJaxrsServer netty = new NettyJaxrsServer();
        ResteasyDeployment deployment = new ResteasyDeployment();
        netty.setDeployment(deployment);
        netty.setHostname(configuration.host());
        netty.setPort(configuration.port());
        netty.setRootResourcePath("");
        netty.setSecurityDomain(null);
        NettyRestServer.addEncryption(configuration, netty);
        return new NettyRestServer(manager, configuration, netty, consumer);
    }

    private static void addEncryption(RestServerConfiguration config, NettyJaxrsServer netty) {
        if (config.ssl() != null && config.ssl().enabled()) {
            SslConfiguration sslConfig = config.ssl();
            SniConfiguration nettySniConfiguration = new SniConfiguration(SslUtils.createJdkSslContext((SslConfiguration)sslConfig, (SslEngineConfiguration)((SslEngineConfiguration)sslConfig.sniDomainsConfiguration().get("*"))));
            sslConfig.sniDomainsConfiguration().forEach((domainName, domainConfiguration) -> nettySniConfiguration.addSniMapping(domainName, SslUtils.createJdkSslContext((SslConfiguration)sslConfig, (SslEngineConfiguration)domainConfiguration)));
            netty.setSSLContext(sslConfig.sslContext());
            netty.setSniConfiguration(nettySniConfiguration);
        }
    }

    private static void startCaches(EmbeddedCacheManager cm) {
        cm.getCacheNames().forEach(name -> SecurityActions.getCache(cm, name));
        cm.getCache();
    }

    private static EmbeddedCacheManager createCacheManager(String cfgFile) {
        try {
            return new DefaultCacheManager(cfgFile);
        }
        catch (IOException e) {
            log.errorReadingConfigurationFile(e, cfgFile);
            return new DefaultCacheManager();
        }
    }

    private NettyRestServer(EmbeddedCacheManager cacheManager, RestServerConfiguration configuration, NettyJaxrsServer netty, Consumer<? super EmbeddedCacheManager> onStop) {
        this.cacheManager = cacheManager;
        this.configuration = configuration;
        this.netty = netty;
        this.onStop = onStop;
    }

    public void start() {
        this.netty.start();
        ResteasyDeployment deployment = this.netty.getDeployment();
        this.configuration.ignoredCaches().forEach(arg_0 -> ((NettyRestServer)this).ignoreCache(arg_0));
        RestCacheManager restCacheManager = new RestCacheManager(this.cacheManager, arg_0 -> ((NettyRestServer)this).isCacheIgnored(arg_0));
        Server server = new Server(this.configuration, restCacheManager);
        deployment.getRegistry().addSingletonResource((Object)server);
        deployment.getProviderFactory().register((Object)new RestAccessLoggingHandler(), new Class[]{ContainerRequestFilter.class, ContainerResponseFilter.class});
        log.startRestServer(this.configuration.host(), this.configuration.port());
    }

    public void stop() {
        this.netty.stop();
        this.onStop.accept((EmbeddedCacheManager)this.cacheManager);
    }
}

