/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.CacheControl;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.EmbeddedRestServer;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.rest.RestServerTestBase;
import org.infinispan.rest.RestTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.IntegrationTest")
public class IntegrationTest
extends RestServerTestBase {
    private static final String HOST = "http://localhost:8888";
    private static final String cacheName = "___defaultcache";
    private static final String fullPath = "http://localhost:8888/rest/___defaultcache";
    private static final String DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private EmbeddedCacheManager cacheManager = null;

    private String fullPathWithPort(Method m, int port) {
        return "http://localhost:" + port + "/rest/" + cacheName + "/" + m.getName();
    }

    @BeforeClass(alwaysRun=true)
    void setUp() throws Exception {
        this.cacheManager = TestCacheManagerFactory.fromXml((String)"test-config.xml");
        this.addServer("single", 8888, this.cacheManager);
        this.startServers();
        this.createClient();
    }

    EmbeddedCacheManager createCacheManager() throws IOException {
        return TestCacheManagerFactory.fromXml((String)"test-config.xml");
    }

    @AfterClass(alwaysRun=true)
    void tearDown() throws Exception {
        this.destroyClient();
        this.stopServers();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testBasicOperation(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod insert = new PutMethod(fullPathKey);
        String initialXML = "<hey>ho</hey>";
        insert.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(initialXML.getBytes(), "application/octet-stream"));
        this.call((HttpMethodBase)insert);
        AssertJUnit.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        AssertJUnit.assertEquals((int)bytes.length, (int)initialXML.getBytes().length);
        AssertJUnit.assertEquals((String)initialXML, (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        AssertJUnit.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        this.call((HttpMethodBase)remove);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        this.call((HttpMethodBase)insert);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)initialXML, (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(fullPath);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)removeAll).getStatusCode());
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byteData, "application/octet-stream"));
        this.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        AssertJUnit.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        AssertJUnit.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() throws Exception {
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod("http://localhost:8888/rest/___defaultcache/nodata")).getStatusCode());
    }

    public void testDeleteNonExistent() throws Exception {
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new DeleteMethod("http://localhost:8888/rest/___defaultcache/nodata")).getStatusCode());
    }

    public void testGetCollection() throws Exception {
        PostMethod post_a = new PostMethod("http://localhost:8888/rest/___defaultcache/a");
        post_a.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_a);
        PostMethod post_b = new PostMethod("http://localhost:8888/rest/___defaultcache/b");
        post_b.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_b);
        String html = this.getCollection("text/html");
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"___defaultcache/a\">a</a>"));
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"___defaultcache/b\">b</a>"));
        String xml = this.getCollection("application/xml");
        AssertJUnit.assertTrue((boolean)xml.contains("<key>a</key>"));
        AssertJUnit.assertTrue((boolean)xml.contains("<key>b</key>"));
        String plain = this.getCollection("text/plain;charset=UTF-8");
        AssertJUnit.assertTrue((boolean)plain.contains("a" + System.lineSeparator()));
        AssertJUnit.assertTrue((boolean)plain.contains("b" + System.lineSeparator()));
        String json = this.getCollection("application/json");
        AssertJUnit.assertTrue((boolean)json.contains("\"a\""));
        AssertJUnit.assertTrue((boolean)json.contains("\"b\""));
    }

    public void testGetCollectionEscape() throws Exception {
        PostMethod post_a = new PostMethod("http://localhost:8888/rest/___defaultcache/%22a%22");
        post_a.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_a);
        PostMethod post_b = new PostMethod("http://localhost:8888/rest/___defaultcache/b%3E");
        post_b.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_b);
        String html = this.getCollection("text/html");
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"___defaultcache/&quot;a&quot;\">&quot;a&quot;</a>"));
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"___defaultcache/b&gt;\">b&gt;</a>"));
        String xml = this.getCollection("application/xml");
        AssertJUnit.assertTrue((boolean)xml.contains("<key>&quot;a&quot;</key>"));
        AssertJUnit.assertTrue((boolean)xml.contains("<key>b&gt;</key>"));
        String plain = this.getCollection("text/plain;charset=UTF-8");
        AssertJUnit.assertTrue((boolean)plain.contains("\"a\"" + System.lineSeparator()));
        AssertJUnit.assertTrue((boolean)plain.contains("b>" + System.lineSeparator()));
        String json = this.getCollection("application/json");
        AssertJUnit.assertTrue((boolean)json.contains("\\\"a\\\""));
        AssertJUnit.assertTrue((boolean)json.contains("\"b>\""));
    }

    private String getCollection(String variant) throws Exception {
        GetMethod get = new GetMethod(fullPath);
        get.addRequestHeader("Accept", variant);
        HttpMethodBase coll = this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)coll.getStatusCode());
        AssertJUnit.assertEquals((String)variant, (String)coll.getResponseHeader("Content-Type").getValue());
        return coll.getResponseBodyAsString();
    }

    public void testGet(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        AssertJUnit.assertNotNull((Object)lastMod);
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = this.call((HttpMethodBase)getAgain);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)post);
        AssertJUnit.assertEquals((int)409, (int)this.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) throws Exception {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) throws Exception {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) throws Exception {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PostMethod post = new PostMethod(fullPathKey);
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = Math.max(maxWaitTime, Integer.parseInt(timeToLiveSeconds));
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = Math.max(maxWaitTime, Integer.parseInt(maxIdleTimeSeconds));
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        this.call(get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPutDataWithIfMatch(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Match", etag);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Match", "x");
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfNoneMatch(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-None-Match", "x");
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-None-Match", etag);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfModifiedSince(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Modified-Since", lastMod);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)304, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reputAgain.setRequestHeader("If-Modified-Since", dateMinus);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfUnModifiedSince(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reput.setRequestHeader("If-Unmodified-Since", dateMinus);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testDeleteDataWithIfMatch(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Match", "x");
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Match", etag);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfNoneMatch(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-None-Match", etag);
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-None-Match", "x");
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfModifiedSince(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Modified-Since", lastMod);
        AssertJUnit.assertEquals((int)304, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        deleteAgain.setRequestHeader("If-Modified-Since", dateMinus);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfUnmodifiedSince(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        delete.setRequestHeader("If-Unmodified-Since", dateMinus);
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteCachePreconditionUnimplemented(Method m) throws Exception {
        this.testDeletePreconditionalUnimplemented(fullPath);
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey) throws Exception {
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-None-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Modified-Since");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Unmodified-Since");
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey, String preconditionalHeaderName) throws Exception {
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader(preconditionalHeaderName, "*");
        this.call((HttpMethodBase)delete);
        this.assertNotImplemented((HttpMethod)delete);
    }

    private void assertNotImplemented(HttpMethod method) throws IOException {
        AssertJUnit.assertEquals((int)method.getStatusCode(), (int)501);
        AssertJUnit.assertEquals((String)method.getStatusText(), (String)"Not Implemented");
        assert (method.getResponseBodyAsString().toLowerCase().contains("precondition"));
    }

    public void testRemoveEntry(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        this.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(fullPathKey + "2");
        put_.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put_);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        this.call((HttpMethodBase)new DeleteMethod(fullPath));
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("performAsync", "true");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        this.call((HttpMethodBase)del);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        this.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name = "mic";
        this.getCacheManager("single").getCache(cacheName).put((Object)m.getName(), (Object)obj);
        this.getCacheManager("single").getCache(cacheName).put((Object)(m.getName() + "2"), (Object)"hola");
        this.getCacheManager("single").getCache(cacheName).put((Object)(m.getName() + "3"), (Object)new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        AssertJUnit.assertNotNull((Object)res);
        AssertJUnit.assertEquals((String)"mic", (String)res.name);
        AssertJUnit.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = this.call((HttpMethodBase)new GetMethod(fullPathKey + "2"));
        AssertJUnit.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(fullPathKey + "3");
        get3.setRequestHeader("Accept", "application/json");
        this.call((HttpMethodBase)get3);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(this.fullPathKey(m), bout.toByteArray(), "application/x-java-serialized-object");
        this.getCacheManager("single").getCache(cacheName).get((Object)m.getName());
    }

    public void testNonexistentCache(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/nonexistent/" + m.getName();
        GetMethod get = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = this.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) throws Exception {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) throws Exception {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) throws Exception {
        byte[] serializedOnClient = new byte[]{101, 102, 103};
        this.put(this.fullPathKey(m), serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, Optional.empty(), Optional.of(contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        AssertJUnit.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) throws Exception {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        AssertJUnit.assertNotNull((Object)this.get(m, Optional.of(dateLast)).getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)this.get(m, Optional.of(datePlus)).getResponseBodyAsString());
        result = this.get(m, Optional.of(dateMinus), Optional.empty(), 412);
    }

    public void testETagChanges(Method m) throws Exception {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertFalse((String)String.format(eTagFirst, eTagSecond, eTagFirst.equals(eTagSecond)), (boolean)eTagFirst.equals(eTagSecond));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentETagChanges(Method m) throws Exception {
        CountDownLatch v2PutLatch = new CountDownLatch(1);
        CountDownLatch v3PutLatch = new CountDownLatch(1);
        CountDownLatch v2FinishLatch = new CountDownLatch(1);
        EmbeddedCacheManager cacheManager = this.createCacheManager();
        ControlledCacheManager mockCacheManager = new ControlledCacheManager(cacheManager, v2PutLatch, v3PutLatch, v2FinishLatch);
        EmbeddedRestServer server = RestTestingUtil.startRestServer((EmbeddedCacheManager)mockCacheManager);
        this.put(this.fullPathWithPort(m, server.getPort()), "data1", "application/text");
        try {
            Future replaceFuture = this.fork(() -> {
                HttpClient newClient = new HttpClient();
                PutMethod put = new PutMethod(this.fullPathWithPort(m, server.getPort()));
                put.setRequestHeader("Content-Type", "application/text");
                put.setRequestEntity((RequestEntity)new StringRequestEntity("data2", null, null));
                newClient.executeMethod((HttpMethod)put);
                AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
                v2FinishLatch.countDown();
                return null;
            });
            boolean cont = v3PutLatch.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertTrue((String)"Timed out waiting for concurrent put", (boolean)cont);
            PutMethod put = new PutMethod(this.fullPathWithPort(m, server.getPort()));
            put.setRequestHeader("Content-Type", "application/text");
            put.setRequestEntity((RequestEntity)new StringRequestEntity("data3", null, null));
            this.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)412, (int)put.getStatusCode());
            replaceFuture.get(5L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)"data2", (String)this.get(m).getResponseBodyAsString());
        }
        catch (Throwable throwable) {
            server.stop();
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
            throw throwable;
        }
        server.stop();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }

    public void testSerializedStringGetBytes(Method m) throws Exception {
        byte[] data = ("v-" + m.getName()).getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(this.fullPathKey(m), bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, Optional.empty(), Optional.of("application/x-java-serialized-object")).getResponseBody();
        AssertJUnit.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        AssertJUnit.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    public void testDefaultConfiguredExpiryValues(Method m) throws Exception {
        String response;
        String cacheName = "evictExpiryCache";
        String fullPathKey = String.format("%s/rest/%s/%s", HOST, cacheName, m.getName());
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "-1");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(5000L);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        AssertJUnit.assertNull((Object)get.getResponseHeader("Expires"));
        long startTime = System.currentTimeMillis();
        int lifespan = 3000;
        fullPathKey = fullPathKey + "-2";
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        while (System.currentTimeMillis() < startTime + (long)lifespan) {
            get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
            response = get.getResponseBodyAsString();
            if (System.currentTimeMillis() >= startTime + (long)lifespan) continue;
            AssertJUnit.assertEquals((String)"data2", (String)response);
            AssertJUnit.assertNotNull((Object)get.getResponseHeader("Expires"));
            Thread.sleep(100L);
        }
        this.waitNotFound(startTime, lifespan, fullPathKey);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        startTime = System.currentTimeMillis();
        lifespan = 0;
        fullPathKey = String.format(fullPathKey, new Object[0]);
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data3", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(1000L);
        get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        response = get.getResponseBodyAsString();
        AssertJUnit.assertEquals((String)"data3", (String)response);
        Thread.sleep(2000L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        fullPathKey = String.format(fullPathKey, new Object[0]);
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data4", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2500L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
    }

    public void testCacheControlResponseHeader(Method m) throws Exception {
        String cacheName = "evictExpiryCache";
        String fullPathKey = String.format("%s/rest/%s/%s", HOST, cacheName, m.getName());
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Cache-Control"));
        int retrievedMaxAge = CacheControl.valueOf((String)get.getResponseHeader("Cache-Control").getValue()).getMaxAge();
        AssertJUnit.assertTrue((retrievedMaxAge > 0 ? 1 : 0) != 0);
    }

    public void testGetCacheControlMinFreshRequestHeader(Method m) throws Exception {
        String cacheName = "evictExpiryCache";
        String fullPathKey = String.format("%s/rest/%s/%s", HOST, cacheName, m.getName());
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        GetMethod getLongMinFresh = new GetMethod(fullPathKey);
        getLongMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=20");
        HttpMethodBase getResp = this.call((HttpMethodBase)getLongMinFresh);
        AssertJUnit.assertEquals((int)404, (int)getResp.getStatusCode());
        GetMethod getShortMinFresh = new GetMethod(fullPathKey);
        getShortMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=2");
        getResp = this.call((HttpMethodBase)getShortMinFresh);
        AssertJUnit.assertNotNull((Object)getResp.getResponseHeader("Cache-Control"));
        AssertJUnit.assertEquals((String)"data", (String)getResp.getResponseBodyAsString());
        GetMethod getNoMinFresh = new GetMethod(fullPathKey);
        getResp = this.call((HttpMethodBase)getNoMinFresh);
        AssertJUnit.assertNotNull((Object)getResp.getResponseHeader("Cache-Control"));
        AssertJUnit.assertEquals((String)"data", (String)getResp.getResponseBodyAsString());
    }

    public void testHeadCacheControlMinFreshRequestHeader(Method m) throws Exception {
        String cacheName = "evictExpiryCache";
        String fullPathKey = String.format("%s/rest/%s/%s", HOST, cacheName, m.getName());
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        HeadMethod headLongMinFresh = new HeadMethod(fullPathKey);
        headLongMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=20");
        HttpMethodBase headResp = this.call((HttpMethodBase)headLongMinFresh);
        AssertJUnit.assertEquals((int)404, (int)headResp.getStatusCode());
        HeadMethod headShortMinFresh = new HeadMethod(fullPathKey);
        headShortMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=2");
        headResp = this.call((HttpMethodBase)headShortMinFresh);
        int retrievedMaxAge = CacheControl.valueOf((String)headResp.getResponseHeader("Cache-Control").getValue()).getMaxAge();
        AssertJUnit.assertTrue((retrievedMaxAge > 0 ? 1 : 0) != 0);
        HeadMethod headNoMinFresh = new HeadMethod(fullPathKey);
        headResp = this.call((HttpMethodBase)headNoMinFresh);
        AssertJUnit.assertNotNull((Object)headResp.getResponseHeader("Cache-Control"));
    }

    public void testPutByteArrayTwice(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = new byte[]{42, 42, 42};
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
    }

    public void testDeleteSerializedObject(Method m) throws Exception {
        String fullPathKey = "http://localhost:8888/rest/___defaultcache/" + m.getName();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = new byte[]{42, 42, 42};
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        HttpMethodBase delete = this.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)delete.getStatusCode());
    }

    public void testDisableCache(Method m) throws Exception {
        Callable<HttpMethodBase> doGet = () -> this.call((HttpMethodBase)new GetMethod(this.fullPathKey(m)));
        this.put(m);
        AssertJUnit.assertEquals((int)200, (int)doGet.call().getStatusCode());
        this.ignoreCache(cacheName);
        AssertJUnit.assertEquals((int)500, (int)doGet.call().getStatusCode());
        this.enableCache(cacheName);
        AssertJUnit.assertEquals((int)200, (int)doGet.call().getStatusCode());
    }

    private void waitNotFound(Long startTime, int lifespan, String fullPathKey) throws Exception {
        if (System.currentTimeMillis() < startTime + (long)lifespan + 20000L && 404 != this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode()) {
            Thread.sleep(100L);
            this.waitNotFound(startTime, lifespan, fullPathKey);
        }
    }

    private HttpMethodBase put(Method m) throws Exception {
        return this.put(this.fullPathKey(m), "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) throws Exception {
        return this.put(this.fullPathKey(m), data, "application/text");
    }

    private HttpMethodBase put(String path, Object data, String contentType) throws Exception {
        StringRequestEntity reqEntity;
        PutMethod put = new PutMethod(path);
        put.setRequestHeader("Content-Type", contentType);
        if (data instanceof String) {
            reqEntity = new StringRequestEntity((String)data, null, null);
        } else if (data instanceof byte[]) {
            reqEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream((byte[])data));
        } else {
            throw new IllegalArgumentException("Only String or byte[] allowed, received: " + data.getClass());
        }
        put.setRequestEntity((RequestEntity)reqEntity);
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
        return put;
    }

    private HttpMethodBase get(Method m) throws Exception {
        return this.get(m, Optional.empty());
    }

    private HttpMethodBase get(Method m, Optional<String> unmodSince) throws Exception {
        return this.get(m, unmodSince, Optional.empty(), 200);
    }

    private HttpMethodBase get(Method m, Optional<String> unmodSince, Optional<String> acceptType) throws Exception {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Optional<String> unmodSince, Optional<String> acceptType, int expCode) throws Exception {
        GetMethod get = new GetMethod(this.fullPathKey(m));
        if (unmodSince.isPresent()) {
            get.setRequestHeader("If-Unmodified-Since", unmodSince.get());
        }
        if (acceptType.isPresent()) {
            get.setRequestHeader("Accept", acceptType.get());
        }
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    private String fullPathKey(Method m) {
        return "http://localhost:8888/rest/___defaultcache/" + m.getName();
    }

    private String fullPathKey(Method m, int port) {
        return "http://localhost:8888/rest/___defaultcache/" + m.getName();
    }

    String addDay(String aDate, int days) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN_RFC1123, Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    class ControlledCache
    extends AbstractDelegatingAdvancedCache<String, Object> {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;

        public ControlledCache(Cache<String, Object> cache, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            super(cache.getAdvancedCache());
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
        }

        public boolean replace(String key, Object oldValue, Object value, Metadata metadata) {
            byte[] newByteArray = (byte[])value;
            byte[] oldByteArray = (byte[])oldValue;
            String oldAsString = new String(oldByteArray);
            String newAsString = new String(newByteArray);
            try {
                if (Arrays.equals(newByteArray, "data2".getBytes())) {
                    IntegrationTest.this.log.debug((Object)"Let v3 apply...");
                    this.v3PutLatch.countDown();
                    IntegrationTest.this.log.debug((Object)"Wait until v2 can be stored");
                    boolean cont = this.v2PutLatch.await(10L, TimeUnit.SECONDS);
                    if (!cont) {
                        AssertJUnit.fail((String)"Timed out waiting for v2 to be allowed");
                    }
                } else if (Arrays.equals(newByteArray, "data3".getBytes())) {
                    IntegrationTest.this.log.debugf("About to store v3, let v2 apply, oldValue(for v3)=%s", (Object)oldAsString);
                    this.v2PutLatch.countDown();
                    this.v2FinishLatch.await(10L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
            IntegrationTest.this.log.debugf("Replace key=%s, oldValue=%s, value=%s", (Object)key, (Object)oldAsString, (Object)newAsString);
            return super.replace((Object)key, oldValue, value, metadata);
        }
    }

    class ControlledCacheManager
    extends AbstractDelegatingEmbeddedCacheManager {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;

        public ControlledCacheManager(EmbeddedCacheManager cm, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            super(cm);
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
        }

        public <K, V> Cache<K, V> getCache() {
            return new ControlledCache((Cache<String, Object>)super.getCache(), this.v2PutLatch, this.v3PutLatch, this.v2FinishLatch);
        }
    }
}

