/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.rest.RestServerTestBase;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.TwoServerTest")
public class TwoServerTest
extends RestServerTestBase {
    private static final String PATH1 = "http://localhost:8890/rest/___defaultcache/";
    private static final String PATH2 = "http://localhost:8891/rest/___defaultcache/";
    private static final String EXPIRY_PATH1 = "http://localhost:8890/rest/expiry/";
    private static final String EXPIRY_PATH2 = "http://localhost:8891/rest/expiry/";

    @BeforeClass
    private void setUp() throws Exception {
        ConfigurationBuilder cfgBuilder = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        cfgBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        cfgBuilder.clustering().hash().numOwners(2);
        cfgBuilder.clustering().stateTransfer().fetchInMemoryState(true);
        cfgBuilder.clustering().stateTransfer().timeout(20000L);
        ConfigurationBuilder expiryCfgBuilder = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        expiryCfgBuilder.expiration().lifespan(2000L).maxIdle(2000L);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)cfgBuilder);
        cm1.defineConfiguration("expiry", expiryCfgBuilder.build());
        this.addServer("1", cm1, ((RestServerConfigurationBuilder)new RestServerConfigurationBuilder().port(8890)).build());
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)cfgBuilder);
        cm2.defineConfiguration("expiry", expiryCfgBuilder.build());
        this.addServer("2", cm2, ((RestServerConfigurationBuilder)new RestServerConfigurationBuilder().port(8891)).build());
        this.startServers();
        TestingUtil.blockUntilViewsReceived((long)10000L, (Cache[])new Cache[]{this.getCacheManager("1").getCache("___defaultcache"), this.getCacheManager("2").getCache("___defaultcache")});
        this.createClient();
    }

    @AfterClass
    private void tearDown() throws Exception {
        this.stopServers();
        this.destroyClient();
    }

    public void testPutReplication() throws Exception {
        PutMethod put = new PutMethod("http://localhost:8890/rest/___defaultcache/a");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)put);
        Assert.assertEquals((int)put.getStatusCode(), (int)200);
        put.releaseConnection();
        GetMethod get = new GetMethod("http://localhost:8890/rest/___defaultcache/a");
        this.call((HttpMethodBase)get);
        Assert.assertEquals((int)get.getStatusCode(), (int)200);
        get.releaseConnection();
        get = new GetMethod("http://localhost:8891/rest/___defaultcache/a");
        this.call((HttpMethodBase)get);
        Assert.assertEquals((int)get.getStatusCode(), (int)200);
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        get.releaseConnection();
    }

    public void testReplace() throws Exception {
        PutMethod put = new PutMethod("http://localhost:8890/rest/___defaultcache/testReplace");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)put);
        Assert.assertEquals((int)put.getStatusCode(), (int)200);
        put.releaseConnection();
        put = new PutMethod("http://localhost:8890/rest/___defaultcache/testReplace");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "application/text", null));
        this.call((HttpMethodBase)put);
        Assert.assertEquals((int)put.getStatusCode(), (int)200);
        put.releaseConnection();
        GetMethod get = new GetMethod("http://localhost:8891/rest/___defaultcache/testReplace");
        this.call((HttpMethodBase)get);
        Assert.assertEquals((int)get.getStatusCode(), (int)200);
        Assert.assertEquals((String)"data2", (String)get.getResponseBodyAsString());
        get.releaseConnection();
    }

    public void testExtendedHeaders() throws Exception {
        PutMethod put = new PutMethod("http://localhost:8890/rest/___defaultcache/testExtendedHeaders");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)put);
        Assert.assertEquals((int)put.getStatusCode(), (int)200);
        put.releaseConnection();
        GetMethod get = new GetMethod("http://localhost:8891/rest/___defaultcache/testExtendedHeaders?extended");
        this.call((HttpMethodBase)get);
        Assert.assertEquals((int)get.getStatusCode(), (int)200);
        Header po = get.getResponseHeader("Cluster-Primary-Owner");
        Assert.assertNotNull((Object)po);
        Address primaryLocation = this.getCacheManager("1").getCache("___defaultcache").getAdvancedCache().getDistributionManager().getPrimaryLocation((Object)"testExtendedHeaders");
        Assert.assertEquals((String)primaryLocation.toString(), (String)po.getValue());
        Header sa = get.getResponseHeader("Cluster-Server-Address");
        Assert.assertNotNull((Object)sa);
        JGroupsTransport transport = (JGroupsTransport)this.getCacheManager("2").getTransport();
        Assert.assertEquals((String)transport.getPhysicalAddresses().toString(), (String)sa.getValue());
        Header nn = get.getResponseHeader("Cluster-Node-Name");
        Assert.assertNotNull((Object)nn);
        Assert.assertEquals((String)transport.getAddress().toString(), (String)nn.getValue());
        get.releaseConnection();
    }

    public void testExpiration() throws Exception {
        String key1Path = "http://localhost:8890/rest/expiry/k1";
        String key2Path = "http://localhost:8891/rest/expiry/k2";
        String key3Path = "http://localhost:8890/rest/expiry/k3";
        String key4Path = "http://localhost:8890/rest/expiry/k4";
        this.post(key1Path, "v1", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "3", "maxIdleTimeSeconds", "3");
        this.post(key2Path, "v2", "application/text", 200, "Content-Type", "application/text");
        this.post(key3Path, "v3", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "0", "maxIdleTimeSeconds", "0");
        this.post(key4Path, "v4", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "0", "maxIdleTimeSeconds", "2");
        TestingUtil.sleepThread((long)1000L);
        this.get(key1Path, "v1");
        this.get(key3Path, "v3");
        this.get(key4Path, "v4");
        TestingUtil.sleepThread((long)1100L);
        this.get(key1Path, "v1");
        this.head(key3Path, 404);
        this.head(key4Path, 404);
        TestingUtil.sleepThread((long)1000L);
        this.head(key1Path, 404);
        this.head(key2Path, 200);
    }

    private void post(String uri, String data, String contentType, int expectedCode, Object ... headers) throws Exception {
        PostMethod post = new PostMethod(uri);
        for (int i = 0; i < headers.length; i += 2) {
            post.setRequestHeader(headers[i].toString(), headers[i + 1].toString());
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity(data, contentType, null));
        this.call((HttpMethodBase)post);
        Assert.assertEquals((int)expectedCode, (int)post.getStatusCode());
    }

    private void get(String uri, String expectedResponseBody) throws Exception {
        GetMethod get = new GetMethod(uri);
        this.call((HttpMethodBase)get);
        Assert.assertEquals((String)expectedResponseBody, (String)get.getResponseBodyAsString());
    }

    private void head(String uri, int expectedCode) throws Exception {
        HeadMethod head = new HeadMethod(uri);
        this.call((HttpMethodBase)head);
        Assert.assertEquals((int)expectedCode, (int)head.getStatusCode());
    }
}

