/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.MimeExpirableMetadata;
import org.infinispan.rest.MimeLifespanExpirableMetadata;
import org.infinispan.rest.MimeMaxIdleExpirableMetadata;
import org.infinispan.rest.MimeMetadataBuilder;
import org.jboss.marshalling.util.IdentityIntMap;

public class MimeMetadata
implements Metadata {
    protected final String contentType;
    private static final int Immortal = 0;
    private static final int Expirable = 1;
    private static final int LifespanExpirable = 2;
    private static final int MaxIdleExpirable = 3;
    private static final IdentityIntMap<Class> numbers = new IdentityIntMap(4);

    public MimeMetadata(String contentType) {
        this.contentType = Objects.requireNonNull(contentType);
    }

    public long lifespan() {
        return -1L;
    }

    public long maxIdle() {
        return -1L;
    }

    public EntryVersion version() {
        return null;
    }

    public Metadata.Builder builder() {
        return new MimeMetadataBuilder().contentType(this.contentType);
    }

    public String contentType() {
        return this.contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MimeMetadata that = (MimeMetadata)o;
        return this.contentType.equals(that.contentType);
    }

    public int hashCode() {
        return 41 + this.contentType.hashCode();
    }

    public String toString() {
        return "MimeMetadata{contentType='" + this.contentType + '\'' + '}';
    }

    static {
        numbers.put(MimeMetadata.class, 0);
        numbers.put(MimeExpirableMetadata.class, 1);
        numbers.put(MimeLifespanExpirableMetadata.class, 2);
        numbers.put(MimeMaxIdleExpirableMetadata.class, 3);
    }

    public static class Externalizer
    extends AbstractExternalizer<MimeMetadata> {
        public MimeMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String contentType = input.readUTF();
            int number = input.readUnsignedByte();
            switch (number) {
                case 0: {
                    return new MimeMetadata(contentType);
                }
                case 1: {
                    long lifespan = input.readLong();
                    long maxIdle = input.readLong();
                    return new MimeExpirableMetadata(contentType, lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS);
                }
                case 2: {
                    long lifespan = input.readLong();
                    return new MimeLifespanExpirableMetadata(contentType, lifespan, TimeUnit.MILLISECONDS);
                }
                case 3: {
                    long maxIdle = input.readLong();
                    return new MimeMaxIdleExpirableMetadata(contentType, maxIdle, TimeUnit.MILLISECONDS);
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + number);
        }

        public void writeObject(ObjectOutput output, MimeMetadata meta) throws IOException {
            output.writeUTF(meta.contentType);
            int number = numbers.get(meta.getClass(), -1);
            output.write(number);
            switch (number) {
                case 0: {
                    break;
                }
                case 1: {
                    output.writeLong(meta.lifespan());
                    output.writeLong(meta.maxIdle());
                    break;
                }
                case 2: {
                    output.writeLong(meta.lifespan());
                    break;
                }
                case 3: {
                    output.writeLong(meta.maxIdle());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + number);
                }
            }
        }

        public Set<Class<? extends MimeMetadata>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MimeMetadata.class, MimeExpirableMetadata.class, MimeLifespanExpirableMetadata.class, MimeMaxIdleExpirableMetadata.class});
        }
    }
}

