/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestCacheManager;
import org.infinispan.rest.SecurityActions;
import org.infinispan.rest.Server;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.logging.RestAccessLoggingHandler;
import org.infinispan.server.core.AbstractCacheIgnoreAware;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfiguration;
import org.infinispan.server.core.utils.SslUtils;
import org.jboss.resteasy.plugins.server.netty.NettyJaxrsServer;
import org.jboss.resteasy.plugins.server.netty.SniConfiguration;
import org.jboss.resteasy.spi.ResteasyDeployment;

public final class NettyRestServer
extends AbstractCacheIgnoreAware
implements Lifecycle {
    private static final Log log = (Log)LogFactory.getLog(NettyRestServer.class, Log.class);
    private static final String DEFAULT_REST_PATH = "rest";
    private final EmbeddedCacheManager cacheManager;
    private final RestServerConfiguration configuration;
    private NettyJaxrsServer netty;
    private Server server;

    public static NettyRestServer createServer(RestServerConfiguration configuration, EmbeddedCacheManager manager) {
        return new NettyRestServer(manager, configuration);
    }

    private static void addEncryption(RestServerConfiguration config, NettyJaxrsServer netty) {
        if (config.ssl() != null && config.ssl().enabled()) {
            SslConfiguration sslConfig = config.ssl();
            SniConfiguration nettySniConfiguration = new SniConfiguration(SslUtils.createJdkSslContext((SslConfiguration)sslConfig, (SslEngineConfiguration)((SslEngineConfiguration)sslConfig.sniDomainsConfiguration().get("*"))));
            sslConfig.sniDomainsConfiguration().forEach((domainName, domainConfiguration) -> nettySniConfiguration.addSniMapping(domainName, SslUtils.createJdkSslContext((SslConfiguration)sslConfig, (SslEngineConfiguration)domainConfiguration)));
            netty.setSSLContext(sslConfig.sslContext());
            netty.setSniConfiguration(nettySniConfiguration);
        }
    }

    private static void startCaches(EmbeddedCacheManager cm) {
        cm.getCacheNames().forEach(name -> SecurityActions.getCache(cm, name));
        cm.getCache();
    }

    private static EmbeddedCacheManager createCacheManager(String cfgFile) {
        try {
            return new DefaultCacheManager(cfgFile);
        }
        catch (IOException e) {
            log.errorReadingConfigurationFile(e, cfgFile);
            return new DefaultCacheManager();
        }
    }

    private NettyRestServer(EmbeddedCacheManager cacheManager, RestServerConfiguration configuration) {
        this.cacheManager = cacheManager;
        this.configuration = configuration;
    }

    public void start() {
        this.configuration.ignoredCaches().forEach(arg_0 -> ((NettyRestServer)this).ignoreCache(arg_0));
        RestCacheManager restCacheManager = new RestCacheManager(this.cacheManager, arg_0 -> ((NettyRestServer)this).isCacheIgnored(arg_0));
        this.server = new Server(this.configuration, restCacheManager);
        if (this.configuration.startTransport()) {
            NettyJaxrsServer nettyServer = this.createNetty();
            NettyRestServer.addEncryption(this.configuration, nettyServer);
            nettyServer.start();
            ResteasyDeployment deployment = nettyServer.getDeployment();
            deployment.getRegistry().addSingletonResource((Object)this.server, DEFAULT_REST_PATH);
            deployment.getProviderFactory().register((Object)new RestAccessLoggingHandler(), new Class[]{ContainerRequestFilter.class, ContainerResponseFilter.class});
            log.startRestServer(this.configuration.host(), this.configuration.port());
            this.netty = nettyServer;
        }
    }

    private NettyJaxrsServer createNetty() {
        NettyRestServer.startCaches(this.cacheManager);
        NettyJaxrsServer netty = new NettyJaxrsServer();
        ResteasyDeployment deployment = new ResteasyDeployment();
        netty.setDeployment(deployment);
        netty.setHostname(this.configuration.host());
        netty.setPort(this.configuration.port());
        netty.setRootResourcePath("");
        netty.setSecurityDomain(null);
        return netty;
    }

    public void stop() {
        if (this.netty != null) {
            this.netty.stop();
        }
        this.netty = null;
        this.server = null;
    }

    public Server getServer() {
        return this.server;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }
}

