/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.MimeMetadata;
import org.infinispan.rest.MimeMetadataBuilder;

class MimeMaxIdleExpirableMetadata
extends MimeMetadata {
    private final long maxIdleTime;
    private final TimeUnit maxIdleUnit;

    public MimeMaxIdleExpirableMetadata(String contentType, long maxIdleTime, TimeUnit maxIdleUnit) {
        super(contentType);
        this.maxIdleTime = maxIdleTime;
        this.maxIdleUnit = Objects.requireNonNull(maxIdleUnit);
    }

    public long maxIdle() {
        return this.maxIdleUnit.toMillis(this.maxIdleTime);
    }

    public Metadata.Builder builder() {
        return new MimeMetadataBuilder().contentType(this.contentType).maxIdle(this.maxIdleTime, this.maxIdleUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MimeMaxIdleExpirableMetadata that = (MimeMaxIdleExpirableMetadata)o;
        if (this.maxIdleTime != that.maxIdleTime) {
            return false;
        }
        return this.maxIdleUnit == that.maxIdleUnit;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.maxIdleTime ^ this.maxIdleTime >>> 32);
        result = 31 * result + this.maxIdleUnit.hashCode();
        return result;
    }

    public String toString() {
        return "MimeMaxIdleExpirableMetadata{maxIdleTime=" + this.maxIdleTime + ", maxIdleUnit=" + (Object)((Object)this.maxIdleUnit) + '}';
    }
}

