/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.logging.Log;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.util.logging.LogFactory;

public class RestServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<RestServerConfiguration, RestServerConfigurationBuilder>
implements Builder<RestServerConfiguration> {
    private static final Log logger = (Log)LogFactory.getLog(RestServerConfigurationBuilder.class, Log.class);
    public static final String DEFAULT_CONTEXT_PATH = "rest";
    private boolean startTransport = true;
    private static final int DEFAULT_PORT = 8080;
    private ExtendedHeaders extendedHeaders = ExtendedHeaders.ON_DEMAND;
    private String contextPath = "rest";

    public RestServerConfigurationBuilder() {
        super(8080);
    }

    public RestServerConfigurationBuilder extendedHeaders(ExtendedHeaders extendedHeaders) {
        this.extendedHeaders = extendedHeaders;
        return this;
    }

    public RestServerConfigurationBuilder startTransport(boolean startTransport) {
        this.startTransport = startTransport;
        return this;
    }

    public RestServerConfigurationBuilder contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public void validate() {
    }

    public RestServerConfiguration create() {
        return new RestServerConfiguration(this.extendedHeaders, this.host, this.port, this.ignoredCaches, this.ssl.create(), this.startTransport, this.contextPath);
    }

    public Builder<?> read(RestServerConfiguration template) {
        this.extendedHeaders = template.extendedHeaders();
        this.host = template.host();
        this.port = template.port();
        return this;
    }

    public RestServerConfiguration build() {
        return this.build(true);
    }

    public RestServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public RestServerConfigurationBuilder self() {
        return this;
    }

    public RestServerConfigurationBuilder defaultCacheName(String defaultCacheName) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder idleTimeout(int idleTimeout) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder recvBufSize(int recvBufSize) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder sendBufSize(int sendBufSize) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder workerThreads(int workerThreads) {
        throw logger.unsupportedConfigurationOption();
    }
}

