/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.embedded.netty4.security;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.security.Principal;
import java.util.Base64;
import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.infinispan.rest.embedded.netty4.NettySecurityContext;
import org.infinispan.rest.embedded.netty4.security.Authenticator;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class BasicAuthenticator
implements Authenticator {
    private final SecurityDomain domain;
    private final boolean secure;
    private final String realm;
    private final String authenticateHeader;

    public BasicAuthenticator(SecurityDomain domain, boolean secure, String realm) {
        this.domain = domain;
        this.secure = secure;
        this.realm = realm;
        this.authenticateHeader = realm != null ? String.format("Basic realm=\"%s\"", realm) : "Basic";
    }

    @Override
    public SecurityContext authenticate(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) throws IOException {
        String auth;
        List headers = request.getHttpHeaders().getRequestHeader("Authorization");
        if (!headers.isEmpty() && (auth = (String)headers.get(0)).length() > 5) {
            String type = auth.substring(0, 5);
            if ("basic".equals(type = type.toLowerCase())) {
                String cookie = auth.substring(6);
                cookie = new String(Base64.getDecoder().decode(cookie.getBytes()));
                String[] split = cookie.split(":");
                try {
                    Principal user = this.domain.authenticate(split[0], split[1]);
                    return new NettySecurityContext(user, this.domain, "BASIC", this.secure);
                }
                catch (SecurityException e) {
                    this.sendUnauthorizedResponse(response);
                    return null;
                }
            }
            this.sendUnauthorizedResponse(response);
            return null;
        }
        this.sendUnauthorizedResponse(response);
        return null;
    }

    private void sendUnauthorizedResponse(HttpResponse response) throws IOException {
        response.getOutputHeaders().add((Object)"WWW-Authenticate", (Object)this.authenticateHeader);
        response.sendError(401);
    }
}

