/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.rest.operations.CacheOperationsHelper;
import org.infinispan.rest.operations.mime.MimeMetadata;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.RestOperationsTest")
public class RestOperationsTest
extends AbstractInfinispanTest {
    private HttpClient client;
    private RestServerHelper restServer;

    @BeforeSuite
    public void beforeSuite() throws Exception {
        this.restServer = RestServerHelper.defaultRestServer("default");
        ConfigurationBuilder configuration = new ConfigurationBuilder();
        configuration.expiration().lifespan(100L).maxIdle(100L);
        this.restServer.defineCache("expiration", configuration);
        this.restServer.start();
        this.client = new HttpClient();
        this.client.start();
    }

    @AfterSuite
    public void afterSuite() throws Exception {
        this.client.stop();
        this.restServer.stop();
    }

    @AfterMethod
    public void afterMethod() {
        this.restServer.clear();
    }

    @Test
    public void shouldGetNonExistingValue() throws Exception {
        ContentResponse response = this.client.GET("http://localhost:" + this.restServer.getPort() + "/rest/default/nonExisting");
        ResponseAssertion.assertThat(response).doesntExist();
    }

    @Test
    public void shouldReturnNotExistingOnWrongContext() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test", "text/plain", Optional.empty(), Optional.empty());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/wrongContext/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).doesntExist();
    }

    @Test
    public void shouldGetAsciiValueStoredInSpecificFormat() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test", "text/plain", Optional.empty(), Optional.empty());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldHaveProperEtagWhenGettingValue() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test", "text/plain", Optional.empty(), Optional.empty());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).hasEtag();
        ResponseAssertion.assertThat(response).hasHeaderMatching("ETag", "text/plain-\\d+");
    }

    @Test
    public void shouldReturnExtendedHeaders() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test", "text/plain", Optional.empty(), Optional.empty());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s?extended=true", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).hasExtendedHeaders();
    }

    @Test
    public void shouldGetUtf8ValueStoredInSpecificFormat() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test", "text/plain;charset=UTF-8", Optional.empty(), Optional.empty());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain;charset=UTF-8").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain;charset=UTF-8");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldGetJsonValueStoredInSpecificFormat() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "{\"name\": \"test\"}", "application/json", Optional.empty(), Optional.empty());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"name\": \"test\"}");
    }

    @Test
    public void shouldGetXmlValueStoredInSpecificFormat() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "<xml><name>test</name></xml>", "application/xml", Optional.empty(), Optional.empty());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "application/xml").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<xml><name>test</name></xml>");
    }

    @Test
    public void shouldGetValueStoredInUnknownFormat() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test", "application/unknown", Optional.empty(), Optional.empty());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/unknown");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldGetOctetStreamValueStoredInSpecificFormat() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("default", "test", this.convertToBytes(testClass));
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "application/octet-stream").send();
        TestClass convertedObject = this.convertFromBytes(response.getContent(), TestClass.class);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
        ResponseAssertion.assertThat(response).hasNoCharset();
        Assertions.assertThat((String)convertedObject.getName()).isEqualTo((Object)"test");
    }

    @Test
    public void shouldConvertExistingObjectToText() throws Exception {
        this.putValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldConvertExistingObjectToTextUtf8() throws Exception {
        this.putValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "text/plain;charset=utf-8").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain;charset=UTF-8");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToJson() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("default", "test", testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"name\":\"test\"}");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToXml() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("default", "test", testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header(HttpHeader.ACCEPT, "application/xml").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<org.infinispan.rest.RestOperationsTest_-TestClass>\n  <name>test</name>\n</org.infinispan.rest.RestOperationsTest_-TestClass>");
    }

    @Test
    public void shouldGetExistingValueWithoutOutputUsingHEAD() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.HEAD).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
    }

    private void putValueWithMetadataInCache(String cacheName, String key, String testValue, String dataType, Optional<Long> ttl, Optional<Long> idleTime) {
        Metadata metadata = CacheOperationsHelper.createMetadata((Configuration)this.restServer.getCacheManager().getCacheConfiguration(cacheName), (String)dataType, ttl, idleTime);
        this.restServer.getCacheManager().getCache(cacheName).getAdvancedCache().put((Object)key, (Object)testValue.getBytes(), metadata);
    }

    private void putValueWithMetadataInCache(String cacheName, String key, String testValue) {
        this.putValueWithMetadataInCache(cacheName, key, testValue, "text/plain", Optional.empty(), Optional.empty());
    }

    private void putValueInCache(String cacheName, String key, Object testValue) {
        this.restServer.getCacheManager().getCache(cacheName).getAdvancedCache().put((Object)key, testValue);
    }

    /*
     * Exception decompiling
     */
    private byte[] convertToBytes(Object object) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> T convertFromBytes(byte[] bytes, Class<T> klass) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            ObjectInputStream in = new ObjectInputStream(bis);
            Object object = in.readObject();
            return (T)object;
        }
    }

    @Test
    public void shouldDeleteExistingValue() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer.getCacheManager().getCache("default")).isEmpty();
    }

    @Test
    public void shouldDeleteNonExistingValue() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "doesnt_exist")).method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void shouldDeleteEntireCache() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "default")).method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer.getCacheManager().getCache("default")).isEmpty();
    }

    @Test
    public void shouldGetAllEntriesFromEmptyCache() throws Exception {
        ContentResponse response = this.client.newRequest("http://localhost:" + this.restServer.getPort() + "/rest/default").method(HttpMethod.GET).header("Content-Type", "text/plain; charset=utf-8").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("");
    }

    @Test
    public void shouldGetAllEntriesConvertedToText() throws Exception {
        this.putValueInCache("default", "key1", "test1".getBytes());
        this.putValueInCache("default", "key2", "test2".getBytes());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "default")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("key1\nkey2");
    }

    @Test
    public void shouldGetAllEntriesConvertedToTextUtf8() throws Exception {
        this.putValueInCache("default", "key1", "test1".getBytes());
        this.putValueInCache("default", "key2", "test2".getBytes());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "default")).header(HttpHeader.ACCEPT, "text/plain;charset=UTF-8").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain;charset=UTF-8");
        ResponseAssertion.assertThat(response).hasReturnedText("key1\nkey2");
    }

    @Test
    public void shouldGetAllEntriesConvertedToTextIso_8859_1() throws Exception {
        this.putValueInCache("default", "key1", "test1".getBytes());
        this.putValueInCache("default", "key2", "test2".getBytes());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "default")).header(HttpHeader.ACCEPT, "text/plain; charset=ISO-8859-1").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain; charset=ISO-8859-1");
        ResponseAssertion.assertThat(response).hasReturnedText("key1\nkey2");
    }

    @Test
    public void shouldGetAllEntriesConvertedToHtml() throws Exception {
        this.putValueInCache("default", "key1", "test1".getBytes());
        this.putValueInCache("default", "key2", "test2".getBytes());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "default")).header(HttpHeader.ACCEPT, "text/html").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/html");
        ResponseAssertion.assertThat(response).hasReturnedText("<html><body><a href=\"default/key1\">key1</a><br/><a href=\"default/key2\">key2</a></body></html>");
    }

    @Test
    public void shouldGetAllEntriesConvertedToJson() throws Exception {
        this.putValueInCache("default", "key1", "test1".getBytes());
        this.putValueInCache("default", "key2", "test2".getBytes());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "default")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("keys=[key1,key2]");
    }

    @Test
    public void shouldGetAllEntriesConvertedToXml() throws Exception {
        this.putValueInCache("default", "key1", "test1".getBytes());
        this.putValueInCache("default", "key2", "test2".getBytes());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s", this.restServer.getPort(), "default")).header(HttpHeader.ACCEPT, "application/xml").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<?xml version=\"1.0\" encoding=\"UTF-8\"?><keys><key>key1</key><key>key2</key></keys>");
    }

    @Test
    public void shouldAcceptMultipleAcceptHeaderValues() throws Exception {
        this.putValueWithMetadataInCache("default", "key1", "test1", "text/plain", Optional.empty(), Optional.empty());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "key1")).header(HttpHeader.ACCEPT, "ignored/wrong , text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test1");
    }

    @Test
    public void shouldNotAcceptUnknownContentType() throws Exception {
        this.putValueWithMetadataInCache("default", "key1", "test1", "text/plain", Optional.empty(), Optional.empty());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "key1")).header(HttpHeader.ACCEPT, "application/wrong-content-type").send();
        ResponseAssertion.assertThat(response).isNotAcceptable();
    }

    @Test
    public void shouldNotReturnValueIfSendingCorrectETag() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test");
        ContentResponse firstResponse = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.GET).send();
        String etagFromFirstCall = firstResponse.getHeaders().get("ETag");
        ContentResponse secondResponse = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header("If-None-Match", etagFromFirstCall).method(HttpMethod.GET).send();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)etagFromFirstCall).isNotNull()).isNotEmpty();
        ResponseAssertion.assertThat(secondResponse).isNotModified();
    }

    @Test
    public void shouldReturnEntityWhenSendingWrongETag() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header("If-None-Match", "Invalid-etag").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldPutTextValueInCache() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).content((ContentProvider)new StringContentProvider("Hey!")).header("Content-type", "text/plain;charset=UTF-8").send();
        InternalCacheEntry cacheEntry = (InternalCacheEntry)this.restServer.getCacheManager().getCache("default", false).getAdvancedCache().getCacheEntry((Object)"test");
        MimeMetadata metadata = (MimeMetadata)cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasEtag();
        Assertions.assertThat((String)new String((byte[])cacheEntry.getValue())).isEqualTo((Object)"Hey!");
        Assertions.assertThat((String)metadata.contentType()).isEqualTo((Object)"text/plain;charset=UTF-8");
    }

    @Test
    public void shouldPutUnknownFormatValueInCache() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).content((ContentProvider)new StringContentProvider("Hey!")).header("Content-type", "application/unknown").send();
        InternalCacheEntry cacheEntry = (InternalCacheEntry)this.restServer.getCacheManager().getCache("default", false).getAdvancedCache().getCacheEntry((Object)"test");
        MimeMetadata metadata = (MimeMetadata)cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasEtag();
        Assertions.assertThat((String)new String((byte[])cacheEntry.getValue())).isEqualTo((Object)"Hey!");
        Assertions.assertThat((String)metadata.contentType()).isEqualTo((Object)"application/unknown");
    }

    @Test
    public void shouldPutSerializedValueInCache() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{this.convertToBytes(testClass)})).header("Content-type", "application/octet-stream").send();
        InternalCacheEntry cacheEntry = (InternalCacheEntry)this.restServer.getCacheManager().getCache("default", false).getAdvancedCache().getCacheEntry((Object)"test");
        MimeMetadata metadata = (MimeMetadata)cacheEntry.getMetadata();
        TestClass valueFromCache = this.convertFromBytes((byte[])cacheEntry.getValue(), TestClass.class);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasEtag();
        Assertions.assertThat((String)valueFromCache.getName()).isEqualTo((Object)"test");
        Assertions.assertThat((String)metadata.contentType()).isEqualTo((Object)"application/octet-stream");
    }

    @Test
    public void shouldConflictWhenTryingToReplaceExistingEntryUsingPost() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test");
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).content((ContentProvider)new StringContentProvider("Hey!")).header("Content-type", "text/plain;charset=UTF-8").send();
        ResponseAssertion.assertThat(response).isConflicted();
    }

    @Test
    public void shouldUpdateEntryWhenReplacingUsingPut() throws Exception {
        this.putValueWithMetadataInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).content((ContentProvider)new StringContentProvider("Hey!")).header("Content-type", "text/plain;charset=UTF-8").method(HttpMethod.PUT).send();
        String valueFromCache = new String((byte[])this.restServer.getCacheManager().getCache("default", false).getAdvancedCache().getCacheEntry((Object)"test").getValue());
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((String)valueFromCache).isEqualTo((Object)"Hey!");
    }

    @Test
    public void shouldServeHtmlFile() throws Exception {
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest", this.restServer.getPort())).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/html");
        ResponseAssertion.assertThat(response).hasContentEqualToFile("index.html");
    }

    @Test
    public void shouldServeBannerFile() throws Exception {
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/banner.png", this.restServer.getPort())).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("image/png");
        ResponseAssertion.assertThat(response).hasContentEqualToFile("banner.png");
    }

    @Test
    public void shouldSupportCompatibilityWithCustomClass() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.restServer.getCacheManager().getCache("default").getAdvancedCache().put((Object)"test", (Object)testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header("Content-type", "text/plain;charset=UTF-8").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain;charset=UTF-8");
        ResponseAssertion.assertThat(response).hasReturnedText("TestClass{name='test'}");
    }

    @Test
    public void shouldSupportCompatibilityWithStrings() throws Exception {
        this.restServer.getCacheManager().getCache("default").getAdvancedCache().put((Object)"test", (Object)"test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).header("Content-type", "text/plain;charset=UTF-8").method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain;charset=UTF-8");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldPutEntryWithDefaultTllAndIdleTime() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "expiration", "test")).content((ContentProvider)new StringContentProvider("test")).send();
        InternalCacheEntry cacheEntry = (InternalCacheEntry)this.restServer.getCacheManager().getCache("expiration", false).getAdvancedCache().getCacheEntry((Object)"test");
        MimeMetadata metadata = (MimeMetadata)cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(100L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(100L);
    }

    @Test
    public void shouldPutImmortalEntryWithMinusOneTtlAndIdleTime() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "expiration", "test")).content((ContentProvider)new StringContentProvider("test")).header("timeToLiveSeconds", "-1").header("maxIdleTimeSeconds", "-1").send();
        InternalCacheEntry cacheEntry = (InternalCacheEntry)this.restServer.getCacheManager().getCache("expiration", false).getAdvancedCache().getCacheEntry((Object)"test");
        MimeMetadata metadata = (MimeMetadata)cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(-1L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(-1L);
    }

    @Test
    public void shouldPutImmortalEntryWithZeroTtlAndIdleTime() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "expiration", "test")).content((ContentProvider)new StringContentProvider("test")).header("timeToLiveSeconds", "0").header("maxIdleTimeSeconds", "0").send();
        InternalCacheEntry cacheEntry = (InternalCacheEntry)this.restServer.getCacheManager().getCache("expiration", false).getAdvancedCache().getCacheEntry((Object)"test");
        MimeMetadata metadata = (MimeMetadata)cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(100L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(100L);
    }

    @Test
    public void shouldPutEntryWithTtlAndIdleTime() throws Exception {
        ContentResponse response = this.client.POST(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "expiration", "test")).content((ContentProvider)new StringContentProvider("test")).header("timeToLiveSeconds", "50").header("maxIdleTimeSeconds", "50").send();
        InternalCacheEntry cacheEntry = (InternalCacheEntry)this.restServer.getCacheManager().getCache("expiration", false).getAdvancedCache().getCacheEntry((Object)"test");
        MimeMetadata metadata = (MimeMetadata)cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(50000L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(50000L);
    }

    static class TestClass
    implements Serializable {
        private String name;

        TestClass() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "TestClass{name='" + this.name + '\'' + '}';
        }
    }
}

