/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import org.infinispan.rest.Http11To2UpgradeHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyTransport;

public class RestChannelInitializer
extends NettyChannelInitializer {
    private final Http11To2UpgradeHandler http11To2UpgradeHandler;

    public RestChannelInitializer(RestServer server, NettyTransport transport) {
        super((ProtocolServer)server, transport, null, null);
        this.http11To2UpgradeHandler = new Http11To2UpgradeHandler(server);
    }

    public void initializeChannel(Channel ch) throws Exception {
        super.initializeChannel(ch);
        if (this.server.getConfiguration().ssl().enabled()) {
            ch.pipeline().addLast(new ChannelHandler[]{this.http11To2UpgradeHandler});
        } else {
            this.http11To2UpgradeHandler.configurePipeline(ch.pipeline(), "http/1.1");
        }
    }

    protected ApplicationProtocolConfig getAlpnConfiguration() {
        if (this.server.getConfiguration().ssl().enabled()) {
            return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"});
        }
        return null;
    }

    public Http11To2UpgradeHandler getHttp11To2UpgradeHandler() {
        return this.http11To2UpgradeHandler;
    }
}

