/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import org.infinispan.rest.Http10RequestHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyTransport;

public class RestChannelInitializer
extends NettyChannelInitializer {
    private static final int MAX_PAYLOAD_SIZE = 0x500000;
    private RestServer restServer;

    public RestChannelInitializer(RestServer server, NettyTransport transport) {
        super((ProtocolServer)server, transport, null, null);
        this.restServer = server;
    }

    public void initializeChannel(Channel ch) throws Exception {
        super.initializeChannel(ch);
        ch.pipeline().addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        ch.pipeline().addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(0x500000)});
        ch.pipeline().addLast("rest-handler", (ChannelHandler)this.getHttpHandler());
    }

    public Http10RequestHandler getHttpHandler() {
        return new Http10RequestHandler((RestServerConfiguration)this.restServer.getConfiguration(), this.restServer.getCacheManager(), this.restServer.getAuthenticator());
    }
}

