/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.AsciiString;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManagerFactory;
import org.infinispan.rest.http2.Http2ClientInitializer;
import org.infinispan.rest.http2.Http2SettingsHandler;
import org.infinispan.rest.http2.HttpResponseHandler;

public class Http2Client {
    final SslContext sslCtx;
    final EventLoopGroup workerGroup = new NioEventLoopGroup();
    Channel channel;
    Http2ClientInitializer initializer;
    AtomicInteger streamCounter = new AtomicInteger(3);
    AsciiString hostname;

    public Http2Client(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    public static Http2Client newClientWithHttp11Upgrade() {
        return new Http2Client(null);
    }

    public static Http2Client newClientWithAlpn(String keystorePath, String keystorePassword) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(keystorePath), keystorePassword.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, "secret".toCharArray());
        SslProvider provider = OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK;
        SslContext sslCtx = SslContextBuilder.forClient().sslProvider(provider).keyManager(kmf).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"})).build();
        return new Http2Client(sslCtx);
    }

    public void start(String host, int port) throws Exception {
        this.hostname = new AsciiString((CharSequence)(host + ':' + port));
        this.initializer = new Http2ClientInitializer(this.sslCtx, Integer.MAX_VALUE);
        Bootstrap b = new Bootstrap();
        b.group(this.workerGroup);
        b.channel(NioSocketChannel.class);
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.remoteAddress(host, port);
        b.handler((ChannelHandler)this.initializer);
        this.channel = b.connect().syncUninterruptibly().channel();
        System.out.println("Connected to [" + host + ':' + port + ']');
        Http2SettingsHandler http2SettingsHandler = this.initializer.settingsHandler();
        http2SettingsHandler.awaitSettings(15L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.workerGroup.shutdownGracefully();
    }

    public void awaitForResponses() {
        HttpResponseHandler responseHandler = this.initializer.responseHandler();
        responseHandler.awaitResponses(60L, TimeUnit.SECONDS);
    }

    public Queue<FullHttpResponse> getResponses() {
        this.awaitForResponses();
        HttpResponseHandler responseHandler = this.initializer.responseHandler();
        return responseHandler.getResponses();
    }

    public void sendRequest(FullHttpRequest request) {
        HttpResponseHandler responseHandler = this.initializer.responseHandler();
        int streamId = this.streamCounter.getAndAdd(2);
        HttpScheme scheme = this.sslCtx != null ? HttpScheme.HTTPS : HttpScheme.HTTP;
        request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)this.hostname);
        request.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)scheme.name());
        request.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        responseHandler.put(streamId, this.channel.write((Object)request), this.channel.newPromise());
        this.channel.flush();
    }
}

