/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.assertion;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpHeader;

public class ResponseAssertion {
    private ContentResponse response;

    private ResponseAssertion(ContentResponse response) {
        this.response = response;
    }

    public static ResponseAssertion assertThat(ContentResponse response) {
        return new ResponseAssertion(response);
    }

    public ResponseAssertion isOk() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(200);
        return this;
    }

    public ResponseAssertion doesntExist() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(404);
        return this;
    }

    public ResponseAssertion hasReturnedText(String text) {
        Assertions.assertThat((String)this.response.getContentAsString()).isEqualTo((Object)text);
        return this;
    }

    public ResponseAssertion hasEtag() {
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.response.getHeaders().get("etag")).isNotNull()).isNotEmpty();
        return this;
    }

    public ResponseAssertion hasNoContent() {
        Assertions.assertThat((String)this.response.getContentAsString()).isEmpty();
        return this;
    }

    public ResponseAssertion hasContentType(String contentType) {
        Assertions.assertThat((String)this.response.getHeaders().get("Content-Type").replace(" ", "")).contains(new CharSequence[]{contentType.replace(" ", "")});
        return this;
    }

    public ResponseAssertion hasHeaderMatching(String header, String regexp) {
        Assertions.assertThat((String)this.response.getHeaders().get(header)).matches((CharSequence)regexp);
        return this;
    }

    public ResponseAssertion hasExtendedHeaders() {
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.response.getHeaders().get("Cluster-Primary-Owner")).isNotNull()).isNotEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.response.getHeaders().get("Cluster-Node-Name")).isNotNull()).isNotEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.response.getHeaders().get("Cluster-Server-Address")).isNotNull()).isNotEmpty();
        return this;
    }

    public ResponseAssertion isConflicted() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(409);
        return this;
    }

    public ResponseAssertion isUnauthorized() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(401);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.response.getHeaders().get(HttpHeader.WWW_AUTHENTICATE)).isNotNull()).isNotEmpty();
        return this;
    }

    public ResponseAssertion isNotFound() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(404);
        return this;
    }

    public ResponseAssertion isPayloadTooLarge() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(413);
        return this;
    }

    public ResponseAssertion isNotModified() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(304);
        return this;
    }

    public ResponseAssertion hasContentEqualToFile(String fileName) {
        try {
            Path path = Paths.get(this.getClass().getClassLoader().getResource(fileName).toURI());
            byte[] loadedFile = Files.readAllBytes(path);
            Assertions.assertThat((byte[])this.response.getContent()).isEqualTo((Object)loadedFile);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public ResponseAssertion isNotAcceptable() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(406);
        return this;
    }

    public ResponseAssertion hasNoCharset() {
        Assertions.assertThat((String)this.response.getHeaders().get("Content-Type")).doesNotContain((CharSequence)"charset");
        return this;
    }
}

