/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.helper;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.impl.VoidAuthenticator;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;

public class RestServerHelper {
    private final EmbeddedCacheManager cacheManager;
    private final RestServer restServer = new RestServer();
    private final RestServerConfigurationBuilder restServerConfigurationBuilder = new RestServerConfigurationBuilder();
    private Authenticator authenticator = new VoidAuthenticator();
    private String host;

    private RestServerHelper(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        ((RestServerConfigurationBuilder)((RestServerConfigurationBuilder)this.restServerConfigurationBuilder.host("localhost")).port(0)).maxContentLength(1000000);
    }

    public static RestServerHelper defaultRestServer(String ... cachesDefined) {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalConfiguration.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
        ConfigurationBuilder configuration = new ConfigurationBuilder();
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfiguration.build(), configuration.build());
        for (String cacheConfiguration : cachesDefined) {
            cacheManager.defineConfiguration(cacheConfiguration, configuration.build());
        }
        return new RestServerHelper((EmbeddedCacheManager)cacheManager);
    }

    public RestServerHelper withAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public void defineCache(String cacheName, ConfigurationBuilder configurationBuilder) {
        this.cacheManager.defineConfiguration(cacheName, configurationBuilder.build());
    }

    public RestServerHelper start() {
        this.restServer.setAuthenticator(this.authenticator);
        this.restServer.start((ProtocolServerConfiguration)this.restServerConfigurationBuilder.build(), this.cacheManager);
        return this;
    }

    public void clear() {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            this.cacheManager.getCache(cacheName).clear();
        }
    }

    public void stop() {
        this.restServer.stop();
        this.cacheManager.stop();
    }

    public int getPort() {
        return this.restServer.getPort();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public RestServerHelper withKeyStore(String keyStorePath, String secret) {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().keyStoreFileName(keyStorePath).keyStorePassword(secret.toCharArray());
        return this;
    }

    public RestServerHelper withTrustStore(String trustStorePath, String secret) {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().trustStoreFileName(trustStorePath).trustStorePassword(secret.toCharArray());
        return this;
    }

    public RestServerHelper withClientAuth() {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().requireClientAuth(true);
        return this;
    }

    public String getHost() {
        return this.restServer.getHost();
    }
}

