/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.rest.BaseRestOperationsTest;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.RestOperationsTest")
public class RestOperationsTest
extends BaseRestOperationsTest {
    @Override
    public ConfigurationBuilder getDefaultCacheBuilder() {
        return new ConfigurationBuilder();
    }

    @Override
    protected void defineCaches() {
        super.defineCaches();
        ConfigurationBuilder object = this.getDefaultCacheBuilder();
        object.encoding().key().mediaType("text/plain");
        object.encoding().value().mediaType("application/x-java-object");
        this.restServer.defineCache("objectCache", object);
    }

    @Test
    public void shouldConvertExistingSerializableObjectToJson() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("objectCache", "test", testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "objectCache", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        System.out.println(response.getContentAsString());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"_type\":\"" + TestClass.class.getName() + "\",\"name\":\"test\"}");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToXml() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("objectCache", "test", testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "objectCache", "test")).header(HttpHeader.ACCEPT, "application/xml").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<org.infinispan.rest.TestClass>\n  <name>test</name>\n</org.infinispan.rest.TestClass>");
    }

    @Test
    public void shouldReadAsBinaryWithCompatMode() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("compatCache", "test", testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "compatCache", "test")).header(HttpHeader.ACCEPT, "application/octet-stream").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadTextWithCompatMode() throws Exception {
        this.putValueInCache("compatCache", "k1", "v1");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "compatCache", "k1")).header(HttpHeader.ACCEPT, "application/octet-stream").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadByteArrayWithCompatMode() throws Exception {
        AdvancedCache cache = this.restServer.getCacheManager().getCache("compatCache").getAdvancedCache().withEncoding(IdentityEncoder.class);
        cache.put((Object)"k1", (Object)"v1".getBytes());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "compatCache", "k1")).header(HttpHeader.ACCEPT, "application/octet-stream").send();
        System.out.println(response.getContentAsString());
        ResponseAssertion.assertThat(response).hasReturnedBytes("v1".getBytes());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadAsJsonWithCompatMode() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("compatCache", "test", testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "compatCache", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test\"}");
    }

    @Test
    public void shouldWriteTextContentWithCompatMode() throws Exception {
        this.putStringValueInCache("compatCache", "key1", "data");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "compatCache", "key1")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("data");
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
    }

    @Test
    public void shouldWriteOctetStreamToDefaultCache() throws Exception {
        this.putBinaryValueInCache("default", "keyA", "<hey>ho</hey>".getBytes(), MediaType.APPLICATION_OCTET_STREAM);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "keyA")).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedBytes("<hey>ho</hey>".getBytes());
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }
}

