/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.Optional;
import org.infinispan.rest.InfinispanResponse;
import org.infinispan.rest.operations.CacheOperations;

public abstract class InfinispanRequest {
    protected final FullHttpRequest request;
    private final Optional<String> streamId;
    private final ChannelHandlerContext nettyChannelContext;
    private final String cacheName;
    private final String context;
    protected final QueryStringDecoder queryStringDecoder;

    protected InfinispanRequest(FullHttpRequest request, ChannelHandlerContext ctx, String cacheName, String context) {
        this.request = request;
        this.queryStringDecoder = new QueryStringDecoder(request.uri());
        this.streamId = Optional.ofNullable(request.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text()));
        this.nettyChannelContext = ctx;
        this.cacheName = cacheName;
        this.context = context;
    }

    protected abstract InfinispanResponse execute(CacheOperations var1);

    public Optional<String> getCacheName() {
        return Optional.ofNullable(this.cacheName);
    }

    public Optional<String> getStreamId() {
        return this.streamId;
    }

    public FullHttpRequest getRawRequest() {
        return this.request;
    }

    public ChannelHandlerContext getRawContext() {
        return this.nettyChannelContext;
    }

    public Optional<Boolean> getUseAsync() {
        String performAsync = this.request.headers().get("performAsync");
        if ("true".equals(performAsync)) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<String> getAcceptContentType() {
        return Optional.ofNullable(this.request.headers().get((CharSequence)HttpHeaderNames.ACCEPT));
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(this.request.headers().get("Content-type"));
    }

    public Optional<String> getAuthorization() {
        return Optional.ofNullable(this.request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION));
    }

    public String getContext() {
        return this.context;
    }

    public Optional<byte[]> data() {
        if (this.request.content() != null) {
            ByteBuf content = this.request.content();
            if (content.hasArray()) {
                return Optional.of(content.array());
            }
            byte[] bufferCopy = new byte[content.readableBytes()];
            content.readBytes(bufferCopy);
            return Optional.of(bufferCopy);
        }
        return Optional.empty();
    }
}

