/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Optional;
import java.util.StringTokenizer;
import org.infinispan.rest.InfinispanCacheAPIRequest;
import org.infinispan.rest.InfinispanRequest;

class InfinispanRequestCreator {
    InfinispanRequestCreator() {
    }

    static InfinispanRequest createRequest(FullHttpRequest request, ChannelHandlerContext ctx) {
        Optional<String> key;
        Optional<String> cacheName;
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.uri());
        StringTokenizer pathTokenizer = new StringTokenizer(queryStringDecoder.path(), "/");
        String context = pathTokenizer.nextToken();
        if (pathTokenizer.hasMoreTokens()) {
            String nextToken = pathTokenizer.nextToken();
            cacheName = Optional.of(nextToken);
        } else {
            cacheName = Optional.empty();
        }
        if (pathTokenizer.hasMoreTokens()) {
            String next = pathTokenizer.nextToken();
            key = Optional.of(next);
        } else {
            key = Optional.empty();
        }
        return new InfinispanCacheAPIRequest(request, ctx, cacheName, key, context);
    }
}

