/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.cachemanager;

import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.UTF8CompatEncoder;
import org.infinispan.commons.dataconversion.UTF8Encoder;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.rest.cachemanager.RestSourceMigrator;
import org.infinispan.rest.cachemanager.exceptions.CacheUnavailableException;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.upgrade.RollingUpgradeManager;

public class RestCacheManager<V> {
    private final EmbeddedCacheManager instance;
    private final Predicate<? super String> isCacheIgnored;
    private final boolean allowInternalCacheAccess;
    private Map<String, AdvancedCache<String, V>> knownCaches = CollectionFactory.makeConcurrentMap((int)4, (float)0.9f, (int)16);

    public RestCacheManager(EmbeddedCacheManager instance) {
        this(instance, s -> Boolean.FALSE);
    }

    private RestCacheManager(EmbeddedCacheManager instance, Predicate<? super String> isCacheIgnored) {
        this.instance = instance;
        this.isCacheIgnored = isCacheIgnored;
        this.allowInternalCacheAccess = instance.getCacheManagerConfiguration().security().authorization().enabled();
    }

    public AdvancedCache<String, V> getCache(String name, MediaType mediaType) {
        String cacheKey = mediaType == null ? name : name + mediaType.getTypeSubtype();
        AdvancedCache<String, V> registered = this.knownCaches.get(cacheKey);
        if (registered != null) {
            return registered;
        }
        if (name.equals("___protobuf_metadata")) {
            return this.instance.getCache("___protobuf_metadata").getAdvancedCache().withEncoding(UTF8CompatEncoder.class);
        }
        AdvancedCache<String, V> knownCache = this.getCache(name);
        AdvancedCache encodedCache = knownCache.getAdvancedCache();
        StorageType storageType = encodedCache.getCacheConfiguration().memory().storageType();
        if (mediaType != null) {
            encodedCache = encodedCache.withMediaType("text/plain", mediaType.toString());
        }
        if (storageType == StorageType.OFF_HEAP) {
            encodedCache = encodedCache.withKeyEncoding(UTF8Encoder.class);
        }
        AdvancedCache decoratedCache = encodedCache;
        this.knownCaches.putIfAbsent(cacheKey, decoratedCache);
        return decoratedCache;
    }

    private AdvancedCache<String, V> getCache(String name) {
        if (this.isCacheIgnored.test(name)) {
            throw new CacheUnavailableException("Cache with name '" + name + "' is temporarily unavailable.");
        }
        boolean isKnownCache = this.knownCaches.containsKey(name);
        if (!("___defaultcache".equals(name) || isKnownCache || this.instance.getCacheNames().contains(name))) {
            throw new NoCacheFoundException("Cache with name '" + name + "' not found amongst the configured caches");
        }
        if (isKnownCache) {
            return this.knownCaches.get(name);
        }
        InternalCacheRegistry icr = (InternalCacheRegistry)this.instance.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (icr.isPrivateCache(name)) {
            throw new CacheUnavailableException(String.format("Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'", name));
        }
        if (!this.allowInternalCacheAccess && icr.isInternalCache(name) && !icr.internalCacheHasFlag(name, InternalCacheRegistry.Flag.USER)) {
            throw new CacheUnavailableException(String.format("Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'", name));
        }
        Cache cache = name.equals("___defaultcache") ? this.instance.getCache() : this.instance.getCache(name);
        this.tryRegisterMigrationManager(cache);
        return cache.getAdvancedCache();
    }

    public CacheEntry<String, V> getInternalEntry(String cacheName, String key, MediaType mediaType) {
        return this.getInternalEntry(cacheName, key, false, mediaType);
    }

    public MediaType getConfiguredMediaType(String cacheName) {
        ContentTypeConfiguration valueMediaType = this.getCache(cacheName).getCacheConfiguration().encoding().valueDataType();
        if (!valueMediaType.isMediaTypeChanged()) {
            return null;
        }
        return valueMediaType.mediaType();
    }

    public CacheEntry<String, V> getInternalEntry(String cacheName, String key, boolean skipListener, MediaType mediaType) {
        AdvancedCache cache = skipListener ? this.getCache(cacheName, mediaType).withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}) : this.getCache(cacheName, mediaType);
        return cache.getCacheEntry((Object)key);
    }

    public String getNodeName() {
        Address addressToBeReturned = this.instance.getAddress();
        if (addressToBeReturned == null) {
            return "0.0.0.0";
        }
        return addressToBeReturned.toString();
    }

    public String getServerAddress() {
        Transport transport = this.instance.getTransport();
        if (transport instanceof JGroupsTransport) {
            return transport.getPhysicalAddresses().toString();
        }
        return "0.0.0.0";
    }

    public EncoderRegistry encoderRegistry() {
        return (EncoderRegistry)this.getInstance().getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
    }

    public String getPrimaryOwner(String cacheName, String key, MediaType contentType) {
        DistributionManager dm = this.getCache(cacheName, contentType).getDistributionManager();
        if (dm == null) {
            return "0.0.0.0";
        }
        return dm.getCacheTopology().getDistribution((Object)key).primary().toString();
    }

    public EmbeddedCacheManager getInstance() {
        return this.instance;
    }

    private void tryRegisterMigrationManager(Cache<String, V> cache) {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        RollingUpgradeManager migrationManager = (RollingUpgradeManager)cr.getComponent(RollingUpgradeManager.class);
        if (migrationManager != null) {
            migrationManager.addSourceMigrator(new RestSourceMigrator<V>(cache));
        }
    }
}

