/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.dataconversion.JsonObjectTranscoder;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Person;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.JsonObjectTranscoderTest")
public class JsonObjectTranscoderTest {
    @Test
    public void testJsonObjectTranscoder() throws Exception {
        Person joe = new Person("joe");
        Address address = new Address();
        address.setCity("London");
        joe.setAddress(address);
        JsonObjectTranscoder transcoder = new JsonObjectTranscoder();
        MediaType jsonMediaType = MediaType.APPLICATION_JSON;
        MediaType personMediaType = MediaType.fromString((String)"application/x-java-object;type=org.infinispan.test.data.Person");
        Object result = transcoder.transcode((Object)joe, personMediaType, jsonMediaType);
        Assert.assertEquals((Object)result, (Object)String.format("{\"_type\":\"%s\",\"name\":\"%s\",\"address\":{\"_type\":\"%s\",\"street\":null,\"city\":\"%s\",\"zip\":0}}", Person.class.getName(), "joe", Address.class.getName(), "London"));
        Object fromJson = transcoder.transcode(result, jsonMediaType, personMediaType);
        Assert.assertEquals((Object)fromJson, (Object)joe);
    }
}

