/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.cachemanager;

import java.util.Map;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.RestCacheManagerTest")
public class RestCacheManagerTest
extends SingleCacheManagerTest {
    @BeforeClass
    public void prepare() throws Exception {
        Configuration config = new ConfigurationBuilder().build();
        this.cacheManager.defineConfiguration("cache1", config);
        this.cacheManager.defineConfiguration("cache2", config);
    }

    @Test
    public void testShouldKeepEncodedCachesRegistered() {
        EmbeddedCacheManager embeddedCacheManager = (EmbeddedCacheManager)Mockito.spy((Object)this.cacheManager);
        RestCacheManager restCacheManager = new RestCacheManager(embeddedCacheManager, c -> Boolean.FALSE);
        Map knownCaches = (Map)TestingUtil.extractField((Object)restCacheManager, (String)"knownCaches");
        restCacheManager.getCache("cache1", MediaType.MATCH_ALL);
        restCacheManager.getCache("cache2", MediaType.MATCH_ALL);
        Assert.assertEquals((int)knownCaches.keySet().size(), (int)2);
        Mockito.reset((Object[])new EmbeddedCacheManager[]{embeddedCacheManager});
        restCacheManager.getCache("cache1", MediaType.MATCH_ALL);
        restCacheManager.getCache("cache2", MediaType.MATCH_ALL);
        Mockito.verifyZeroInteractions((Object[])new Object[]{embeddedCacheManager});
        restCacheManager.getCache("cache2", MediaType.APPLICATION_JSON);
        restCacheManager.getCache("cache2", MediaType.TEXT_PLAIN);
        Assert.assertEquals((int)knownCaches.keySet().size(), (int)4);
        restCacheManager.getCache("cache2", MediaType.TEXT_PLAIN);
        restCacheManager.getCache("cache2", MediaType.fromString((String)"text/plain; charset=UTF-8"));
        restCacheManager.getCache("cache2", MediaType.fromString((String)"text/plain; charset=SHIFT-JIS"));
        Assert.assertEquals((int)knownCaches.keySet().size(), (int)4);
        Mockito.verifyZeroInteractions((Object[])new Object[]{embeddedCacheManager});
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false));
    }
}

