/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.dataconversion.TextBinaryTranscoder;
import org.infinispan.test.dataconversion.AbstractTranscoderTest;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.TextBinaryTranscoderTest")
public class TextBinaryTranscoderTest
extends AbstractTranscoderTest {
    protected String dataSrc;

    @BeforeTest
    public void setUp() {
        this.dataSrc = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
        this.transcoder = new TextBinaryTranscoder();
        this.supportedMediaTypes = this.transcoder.getSupportedMediaTypes();
    }

    public void testTranscoderTranscode() {
        Object transcoded = this.transcoder.transcode((Object)this.dataSrc, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OCTET_STREAM);
        Assert.assertTrue((boolean)(transcoded instanceof byte[]), (String)"Must be byte[]");
        String transcodedBack = new String(Base64.getDecoder().decode((String)this.transcoder.transcode(transcoded, MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN)), StandardCharsets.UTF_8);
        Assert.assertEquals((String)transcodedBack, (String)this.dataSrc, (String)"Must be an equal objects");
    }
}

