/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JavaSerializationTranscoder
implements Transcoder {
    protected static final Log logger = (Log)LogFactory.getLog(JavaSerializationTranscoder.class, Log.class);
    private final Set<MediaType> supported = new HashSet<MediaType>();
    private static final JavaSerializationMarshaller marshaller = new JavaSerializationMarshaller();

    public JavaSerializationTranscoder() {
        this.supported.add(MediaType.APPLICATION_OBJECT);
        this.supported.add(MediaType.APPLICATION_SERIALIZED_OBJECT);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.match(MediaType.APPLICATION_SERIALIZED_OBJECT)) {
                return marshaller.objectToByteBuffer(content);
            }
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                return marshaller.objectFromByteBuffer((byte[])content);
            }
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            throw logger.errorTranscodingContent(e, content);
        }
        throw logger.unsupportedContent(content);
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return this.supported;
    }
}

